/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.tiff;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.faceless.tiff.Tag;
import org.faceless.tiff.Tiff;
import org.faceless.tiff.a;
import org.faceless.tiff.b;
import org.faceless.tiff.c;
import org.faceless.tiff.d;
import org.faceless.tiff.e;
import org.faceless.tiff.f;
import org.faceless.tiff.g;
import org.faceless.tiff.h;
import org.faceless.tiff.i;
import org.faceless.tiff.j;
import org.faceless.util.CCITTOutputStream;
import org.faceless.util.LZWOutputStream;
import org.faceless.util.RLEOutputStream;

public final class TiffImage {
    final Tiff a;
    private d b;
    private BufferedImage c;
    private ByteArrayOutputStream d;
    private Map e;
    private int f;
    private int g;

    public TiffImage(BufferedImage bufferedImage) {
        ColorModel colorModel;
        block21: {
            Object object;
            int n2;
            this.a = null;
            this.e = new TreeMap();
            this.c = bufferedImage;
            this.d = null;
            this.g = 128;
            colorModel = bufferedImage.getColorModel();
            ColorSpace colorSpace = colorModel.getColorSpace();
            this.setTagInt(Tag.ImageWidth, bufferedImage.getWidth());
            this.setTagInt(Tag.ImageLength, bufferedImage.getHeight());
            if (colorModel instanceof IndexColorModel) {
                this.setTagInt(Tag.SamplesPerPixel, 1);
                n2 = ((IndexColorModel)colorModel).getMapSize();
                this.setTagInt(Tag.PhotometricInterpretation, 3);
                object = new int[n2 * 3];
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n3 = ((IndexColorModel)colorModel).getRGB(i2);
                    object[i2] = (n3 >> 16 & 0xFF) << 8;
                    object[n2 + i2] = (n3 >> 8 & 0xFF) << 8;
                    object[n2 + n2 + i2] = (n3 & 0xFF) << 8;
                }
                this.setTagIntArray(Tag.ColorMap, (int[])object);
            } else {
                int n4;
                Tag tag;
                TiffImage tiffImage;
                block20: {
                    block19: {
                        if (colorModel.hasAlpha()) {
                            this.setTagInt(Tag.ExtraSamples, 1);
                        }
                        n2 = colorSpace.getNumComponents();
                        Tag tag2 = Tag.SamplesPerPixel;
                        int n5 = n2;
                        int n6 = colorModel.hasAlpha() ? 1 : 0;
                        this.setTagInt(tag2, n5 + n6);
                        tiffImage = this;
                        tag = Tag.PhotometricInterpretation;
                        if (n2 != 1) break block19;
                        n4 = 1;
                        break block20;
                    }
                    n4 = n2 == 3 ? 2 : 5;
                }
                tiffImage.setTagInt(tag, n4);
                if (!(colorSpace instanceof ICC_ColorSpace) || colorSpace.isCS_sRGB()) break block21;
                try {
                    object = ((ICC_ColorSpace)colorSpace).getProfile();
                    this.setTagByteArray(Tag.ICCProfile, ((ICC_Profile)object).getData());
                }
                catch (Throwable throwable) {
                    Tiff.a.warning("TIFF", "Unable to embed ICC profile", throwable);
                }
            }
        }
        int[] nArray = new int[this.getTagInt(Tag.SamplesPerPixel)];
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            nArray[i3] = colorModel.getPixelSize() / nArray.length;
        }
        this.setTagIntArray(Tag.BitsPerSample, nArray);
    }

    public TiffImage(InputStream inputStream, int n2, int n3, int n4, int n5, int[] nArray, boolean bl) throws IOException {
        int n6;
        this.a = null;
        this.e = new TreeMap();
        this.setTagInt(Tag.ImageWidth, n2);
        this.setTagInt(Tag.ImageLength, n3);
        if (bl) {
            this.setTagInt(Tag.ExtraSamples, 1);
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        this.setTagIntArray(Tag.BitsPerSample, nArray2);
        this.setTagInt(Tag.PhotometricInterpretation, n5);
        this.setTagInt(Tag.SamplesPerPixel, nArray.length);
        this.setTagIntArray(Tag.RowsPerStrip, new int[]{n3});
        this.d = new ByteArrayOutputStream(inputStream.available());
        byte[] byArray = new byte[8192];
        while ((n6 = inputStream.read(byArray)) >= 0) {
            this.d.write(byArray, 0, n6);
        }
        this.c = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void a(boolean bl, boolean bl2, b b2) throws IOException {
        Object object;
        Object object2;
        block72: {
            OutputStream outputStream;
            int n2;
            int n3;
            block80: {
                int n4;
                int n5;
                int[][] nArray;
                int n6;
                boolean bl3;
                int n7;
                block83: {
                    short[][] sArray;
                    block82: {
                        WritableRaster writableRaster;
                        int n8;
                        int n9;
                        block78: {
                            block77: {
                                Object object3;
                                Object object4;
                                int n10;
                                block74: {
                                    block81: {
                                        block79: {
                                            block75: {
                                                SampleModel sampleModel;
                                                block76: {
                                                    block73: {
                                                        if (this.c == null) break block72;
                                                        object2 = this.c.getColorModel();
                                                        object = ((ColorModel)object2).getColorSpace();
                                                        sampleModel = this.c.getSampleModel();
                                                        n9 = this.getWidth();
                                                        n3 = this.getHeight();
                                                        n7 = ((ColorModel)object2).getNumColorComponents();
                                                        n8 = sampleModel.getNumBands();
                                                        bl3 = this.getTagInt(Tag.ExtraSamples) == 1;
                                                        n2 = this.getCompressionType();
                                                        if (n2 == 32773 && this.getTagInt(Tag.BitsPerSample) == 1) {
                                                            n2 = 4;
                                                        }
                                                        if (n2 == 0) {
                                                            n2 = Tiff.a("CompressNone") != null ? 1 : (object2 instanceof IndexColorModel && ((IndexColorModel)object2).getMapSize() == 2 ? 4 : (Tiff.a("CompressFlate") != null ? 8 : (Tiff.a("CompressPackbits") != null ? 32773 : 5)));
                                                        }
                                                        this.d = new ByteArrayOutputStream(32768);
                                                        if (n2 != 4 || object2 instanceof IndexColorModel && ((IndexColorModel)object2).getMapSize() == 2) break block73;
                                                        this.removeTag(Tag.ExtraSamples);
                                                        this.setTagInt(Tag.SamplesPerPixel, 1);
                                                        this.setTagInt(Tag.BitsPerSample, 1);
                                                        this.setTagInt(Tag.PhotometricInterpretation, 0);
                                                        if (Tiff.a("CCITTThresholding") != null) {
                                                            this.setTagInt(Tag.Thresholding, 1);
                                                        }
                                                        outputStream = new CCITTOutputStream(this.d, n9, false);
                                                        n10 = 0;
                                                        object4 = this.c.getRaster();
                                                        object3 = null;
                                                        break block74;
                                                    }
                                                    if (n2 == 8) {
                                                        if (this.containsTag(Tag.ZipQuality)) {
                                                            Deflater deflater = new Deflater(this.getTagInt(Tag.ZipQuality));
                                                            outputStream = new BufferedOutputStream(new DeflaterOutputStream((OutputStream)this.d, deflater));
                                                        } else {
                                                            outputStream = new BufferedOutputStream(new DeflaterOutputStream(this.d));
                                                        }
                                                    } else if (n2 == 32773) {
                                                        outputStream = new RLEOutputStream(this.d, n9);
                                                    } else if (n2 == 5) {
                                                        outputStream = new LZWOutputStream(this.d);
                                                    } else if (n2 == 4) {
                                                        outputStream = new CCITTOutputStream(this.d, n9, ((IndexColorModel)object2).getRed(0) > ((IndexColorModel)object2).getRed(1));
                                                        this.setTagInt(Tag.PhotometricInterpretation, 0);
                                                        if (Tiff.a("CCITTThresholding") != null) {
                                                            this.setTagInt(Tag.Thresholding, 1);
                                                        }
                                                    } else {
                                                        if (n2 != 1) {
                                                            throw new IOException("Unsupported compression algorithm \"" + Tag.a(n2) + "\"");
                                                        }
                                                        outputStream = this.d;
                                                        if (sampleModel.getSampleSize(0) == 1 && object2 instanceof IndexColorModel) {
                                                            boolean bl4 = ((IndexColorModel)object2).getRed(0) > ((IndexColorModel)object2).getRed(1);
                                                            this.setTagInt(Tag.PhotometricInterpretation, bl4 ? 0 : 1);
                                                        }
                                                    }
                                                    writableRaster = this.c.getRaster();
                                                    object4 = writableRaster.getDataBuffer();
                                                    this.c = null;
                                                    if (writableRaster.getParent() == null) break block75;
                                                    if (sampleModel.getSampleSize(0) != 1) break block76;
                                                    break block77;
                                                }
                                                if (sampleModel.getSampleSize(0) != 8) {
                                                    throw new IllegalArgumentException("Unable to support sample size of " + sampleModel.getSampleSize(0) + " bits");
                                                }
                                                break block78;
                                            }
                                            if (((DataBuffer)object4).getDataType() != 0) break block79;
                                            byte[][] byArray = ((DataBufferByte)object4).getBankData();
                                            for (n6 = 0; n6 < byArray.length; ++n6) {
                                                outputStream.write(byArray[n6]);
                                            }
                                            break block80;
                                        }
                                        if (((DataBuffer)object4).getDataType() != 1) break block81;
                                        sArray = ((DataBufferUShort)object4).getBankData();
                                        break block82;
                                    }
                                    if (((DataBuffer)object4).getDataType() != 3) {
                                        throw new IllegalArgumentException("DataBuffer type " + ((DataBuffer)object4).getDataType() + " not supported");
                                    }
                                    nArray = ((DataBufferInt)object4).getBankData();
                                    break block83;
                                }
                                for (n6 = 0; n6 < n3; ++n6) {
                                    n5 = 0;
                                    while (n5 < n9) {
                                        int n11;
                                        n4 = ((ColorModel)object2).getRGB(object3 = ((Raster)object4).getDataElements(n5, n6, object3));
                                        int n12 = n11 = (n4 & 0xFFFFFF) == 0xFFFFFF ? 255 : (n4 & 0xFF0000) / 850 + (n4 << 8 & 0xFF0000) / 432 + (n4 << 16 & 0xFF0000) / 2318 >> 8;
                                        if (n11 >= this.g) {
                                            n10 |= 1 << 7 - (n5 & 7);
                                        }
                                        if ((++n5 & 7) != 0 && n5 != n9) continue;
                                        outputStream.write(n10);
                                        n10 = 0;
                                    }
                                }
                                break block80;
                            }
                            for (int i2 = 0; i2 < n3; ++i2) {
                                for (n6 = 0; n6 < n9; n6 += 8) {
                                    n5 = 0;
                                    for (n4 = 0; n4 < 8; ++n4) {
                                        if (n4 + n6 >= n9 || writableRaster.getSample(n6 + n4, i2, 0) == 0) continue;
                                        n5 |= 1 << 7 - n4;
                                    }
                                    outputStream.write(n5);
                                }
                            }
                            break block80;
                        }
                        for (int i3 = 0; i3 < n3; ++i3) {
                            for (n6 = 0; n6 < n9; ++n6) {
                                for (n5 = 0; n5 < n8; ++n5) {
                                    outputStream.write(writableRaster.getSample(n6, i3, n5));
                                }
                            }
                        }
                        break block80;
                    }
                    for (n6 = 0; n6 < sArray.length; ++n6) {
                        for (n5 = 0; n5 < sArray[n6].length; ++n5) {
                            outputStream.write(sArray[n6][n5] >> 8 & 0xFF);
                            outputStream.write(sArray[n6][n5] & 0xFF);
                        }
                    }
                    break block80;
                }
                for (n6 = 0; n6 < nArray.length; ++n6) {
                    for (n5 = 0; n5 < nArray[n6].length; ++n5) {
                        n4 = nArray[n6][n5];
                        if (n7 == 4) {
                            outputStream.write(n4 >> 24 & 0xFF);
                            outputStream.write(n4 >> 16 & 0xFF);
                            outputStream.write(n4 >> 8 & 0xFF);
                            outputStream.write(n4 >> 0 & 0xFF);
                            continue;
                        }
                        if (n7 == 3) {
                            outputStream.write(n4 >> 16 & 0xFF);
                            outputStream.write(n4 >> 8 & 0xFF);
                            outputStream.write(n4 >> 0 & 0xFF);
                            if (!bl3) continue;
                            outputStream.write(n4 >> 24 & 0xFF);
                            continue;
                        }
                        if (n7 != 1) {
                            throw new IllegalStateException("Can't render model " + object2);
                        }
                        outputStream.write(n4 & 0xFF);
                    }
                }
            }
            outputStream.close();
            this.setTagInt(Tag.Compression, n2);
            if (this.getPhotoMetric() != 3) {
                this.removeTag(Tag.ColorMap);
            }
            this.setTagIntArray(Tag.RowsPerStrip, new int[]{n3});
        }
        if (bl2) {
            this.setTagInt(Tag.NewSubFileType, 2);
        }
        if (Tiff.a("Orientation") != null) {
            this.setTagInt(Tag.Orientation, 1);
        }
        this.setTagIntArray(Tag.StripByteCounts, new int[]{this.d.size()});
        object2 = new int[]{0};
        this.setTagIntArray(Tag.StripOffsets, (int[])object2);
        object = new OutputStream((int[])object2){
            final /* synthetic */ int[] val$stripoffs;
            {
                this.val$stripoffs = nArray;
            }

            public void write(int n2) {
                this.val$stripoffs[0] = this.val$stripoffs[0] + 1;
            }

            public void write(byte[] byArray) {
                this.val$stripoffs[0] = this.val$stripoffs[0] + byArray.length;
            }

            public void write(byte[] byArray, int n2, int n3) {
                this.val$stripoffs[0] = this.val$stripoffs[0] + n3;
            }
        };
        TiffImage.a(new b((OutputStream)object), 0, this.e);
        Object object5 = object2;
        object5[0] = object5[0] + b2.a();
        TiffImage.a(b2, bl ? this.d.size() : 0, this.e);
        this.d.writeTo(b2);
        while (true) {
            if ((b2.a() & 3) == 0) {
                b2.flush();
                return;
            }
            b2.write(0);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(b b2, int n2, Map map) throws IOException {
        int n3 = b2.a();
        b2.a(map.size());
        int n4 = b2.a() + map.size() * 12 + 4 + 3 & 0xFFFFFFFC;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        Iterator iterator = map.entrySet().iterator();
        while (true) {
            int n5;
            b b3;
            int n6;
            Tag tag;
            block28: {
                int n7;
                c_[] c_Array;
                block30: {
                    block26: {
                        Map.Entry entry;
                        block29: {
                            block27: {
                                if (!iterator.hasNext()) break block26;
                                entry = iterator.next();
                                tag = (Tag)entry.getKey();
                                n6 = tag.b();
                                if ((tag == Tag.ImageWidth || tag == Tag.ImageLength) && ((int[])entry.getValue())[0] < Short.MAX_VALUE) {
                                    n6 = 3;
                                }
                                byteArrayOutputStream2.reset();
                                b3 = new b(byteArrayOutputStream2){

                                    public void close() {
                                    }
                                };
                                if (n6 != 2) break block27;
                                c_Array = (String)entry.getValue();
                                n5 = c_Array.length() + 1;
                                b3.a((String)c_Array);
                                break block28;
                            }
                            if (n6 != 5) break block29;
                            c_Array = (c_[])entry.getValue();
                            n5 = c_Array.length;
                            for (n7 = 0; n7 < n5; ++n7) {
                                b3.a(c_Array[n7].a, c_Array[n7].b);
                            }
                            break block28;
                        }
                        c_Array = entry.getValue();
                        n5 = Array.getLength(c_Array);
                        break block30;
                    }
                    int n8 = n2 == 0 ? 0 : (b2.a() + 4 + byteArrayOutputStream.size() + 3 & 0xFFFFFFFC) + n2 + 3 & 0xFFFFFFFC;
                    b2.b(n8);
                    while (true) {
                        if ((b2.a() - n3 & 3) == 0) {
                            byteArrayOutputStream.writeTo(b2);
                            return;
                        }
                        b2.write(0);
                    }
                }
                for (n7 = 0; n7 < n5; ++n7) {
                    int n9 = Array.getInt(c_Array, n7);
                    if (c_Array.getClass().getComponentType() == Byte.TYPE) {
                        n9 &= 0xFF;
                    }
                    if (n6 == 1) {
                        b3.write(n9);
                        continue;
                    }
                    if (n6 == 3) {
                        b3.a(n9);
                        continue;
                    }
                    if (n6 == 4) {
                        b3.b(n9);
                        continue;
                    }
                    if (n6 != 7) continue;
                    b3.write(n9);
                }
            }
            b2.a(tag.a());
            b2.a(n6);
            b2.b(n5);
            if (byteArrayOutputStream2.size() < 5) {
                while (byteArrayOutputStream2.size() != 4) {
                    byteArrayOutputStream2.write(0);
                }
                byteArrayOutputStream2.writeTo(b2);
            } else {
                b2.b(n4 + byteArrayOutputStream.size());
                byteArrayOutputStream2.writeTo(byteArrayOutputStream);
                while ((byteArrayOutputStream.size() & 3) != 0) {
                    byteArrayOutputStream.write(0);
                }
            }
            b3.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TiffImage(Tiff tiff, int n2) throws IOException {
        this.a = tiff;
        this.c = null;
        this.d = null;
        tiff.d.a(n2);
        int n3 = tiff.d.c();
        this.e = new TreeMap();
        boolean bl = Tiff.a.isDebug("TIFF");
        StringBuffer stringBuffer = null;
        int n4 = 0;
        while (true) {
            block61: {
                if (n4 >= n3) {
                    this.f = tiff.d.d();
                    return;
                }
                int n5 = tiff.d.c();
                int n6 = tiff.d.c();
                int n7 = tiff.d.d();
                Tag tag = Tag.a(n5, n6);
                if (tag == Tag.XMPMetaData || tag == Tag.Photoshop) {
                    n6 = 7;
                }
                if (bl) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append(n4 + "/" + n3 + ": off=" + tiff.d.a() + " TAG=" + tag + ": type=" + n6 + " len=" + n7);
                }
                long l2 = tiff.d.a();
                try {
                    block64: {
                        int[] nArray;
                        int n8;
                        block63: {
                            block62: {
                                if (n6 == 2) {
                                    if (n7 > 4) {
                                        tiff.d.a(tiff.d.d());
                                    }
                                    char[] cArray = new char[n7 - 1];
                                    for (n8 = 0; n8 < n7 - 1; ++n8) {
                                        cArray[n8] = (char)tiff.d.b();
                                    }
                                    this.a(tag, new String(cArray));
                                    if (bl) {
                                        stringBuffer.append(" val=" + new String(cArray));
                                        Tiff.a.debug("TIFF", stringBuffer.toString());
                                    }
                                    tiff.d.a(l2 + 4L);
                                    break block61;
                                }
                                if (n6 == 7) {
                                    byte[] byArray = new byte[n7];
                                    if (n7 > 4) {
                                        n8 = tiff.d.d();
                                        tiff.d.a(n8);
                                    }
                                    tiff.d.a(byArray, 0, byArray.length);
                                    this.a(tag, byArray);
                                    if (bl) {
                                        stringBuffer.append("Read " + n7 + " bytes");
                                        Tiff.a.debug("TIFF", stringBuffer.toString());
                                    }
                                    tiff.d.a(l2 + 4L);
                                    break block61;
                                }
                                if (n7 > 4 && (n6 == 1 || n6 == 5) || n7 > 2 && (n6 == 8 || n6 == 3) || n7 > 1 && n6 != 1 && n6 != 5 && n6 != 8 && n6 != 3 || n6 == 12 || n6 == 10 || n6 == 5) {
                                    int n9 = tiff.d.d();
                                    tiff.d.a(n9);
                                }
                                if (n6 == 5 || n6 == 10 || n6 == 11 || n6 == 12) break block62;
                                nArray = new int[n7];
                                break block63;
                            }
                            double[] dArray = new double[n7];
                            for (n8 = 0; n8 < n7; ++n8) {
                                if (n6 == 5) {
                                    dArray[n8] = tiff.d.h();
                                    continue;
                                }
                                if (n6 == 10) {
                                    dArray[n8] = tiff.d.i();
                                    continue;
                                }
                                if (n6 == 11) {
                                    dArray[n8] = tiff.d.j();
                                    continue;
                                }
                                if (n6 != 12) continue;
                                dArray[n8] = tiff.d.k();
                            }
                            this.a(tag, dArray);
                            if (bl) {
                                stringBuffer.append(" val=" + dArray[0]);
                                Tiff.a.debug("TIFF", stringBuffer.toString());
                            }
                            break block64;
                        }
                        for (n8 = 0; n8 < n7; ++n8) {
                            if (n6 == 1) {
                                nArray[n8] = tiff.d.b();
                                continue;
                            }
                            if (n6 == 3) {
                                nArray[n8] = tiff.d.c();
                                continue;
                            }
                            if (n6 == 4) {
                                nArray[n8] = tiff.d.d();
                                continue;
                            }
                            if (n6 == 6) {
                                nArray[n8] = tiff.d.e();
                                continue;
                            }
                            if (n6 == 8) {
                                nArray[n8] = tiff.d.f();
                                continue;
                            }
                            if (n6 != 9) continue;
                            nArray[n8] = tiff.d.g();
                        }
                        this.a(tag, nArray);
                        if (bl) {
                            stringBuffer.append(" val=" + nArray[0]);
                            Tiff.a.debug("TIFF", stringBuffer.toString());
                        }
                    }
                    tiff.d.a(l2 + 4L);
                }
                catch (Exception exception) {
                    Tiff.a.warning("TIFF", "Skipping corrupt tag " + tag, exception);
                    tiff.d.a(l2 + 4L);
                }
            }
            ++n4;
        }
    }

    int a() {
        return this.f;
    }

    public Iterator getTags() {
        return this.e.keySet().iterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.e.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Tag tag = (Tag)entry.getKey();
            int n2 = tag.b();
            Object object = entry.getValue();
            if (object.getClass().isArray()) {
                int n3 = Array.getLength(object);
                if (n3 == 0) {
                    object = "[]";
                } else if (n3 == 1) {
                    object = Array.get(object, 0);
                } else {
                    String string = "";
                    for (int i2 = 0; i2 < Math.min(n3, 4); ++i2) {
                        string = string + Array.get(object, i2) + ",";
                    }
                    if (n3 > 4) {
                        string = string + "...";
                        if (n3 > 6) {
                            string = string + Array.get(object, n3 - 2) + "," + Array.get(object, n3 - 1);
                        }
                    } else {
                        string = string.substring(0, string.length() - 1);
                    }
                    object = "[" + string + "]";
                }
            } else if (object instanceof String) {
                object = "\"" + object + "\"";
            }
            if (tag == Tag.Compression) {
                object = Tag.a(this.getTagInt(tag));
            }
            if (tag == Tag.PhotometricInterpretation) {
                object = Tag.b(this.getTagInt(tag));
            }
            stringBuffer.append(tag + "=" + object + "\t");
        }
        return "{" + stringBuffer.toString().substring(0, stringBuffer.length() - 1) + "}";
    }

    public void removeTag(Tag tag) {
        this.e.remove(tag);
    }

    public boolean containsTag(Tag tag) {
        return this.e.containsKey(tag);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTagInt(Tag tag) {
        int[] nArray = (int[])this.e.get(tag);
        if (nArray == null) return 0;
        if (nArray.length == 0) return 0;
        int n2 = nArray[0];
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public double getTagDouble(Tag tag) {
        double[] dArray = (double[])this.e.get(tag);
        if (dArray == null) return 0.0;
        if (dArray.length == 0) return 0.0;
        double d2 = dArray[0];
        return d2;
    }

    public String getTagString(Tag tag) {
        return (String)this.e.get(tag);
    }

    public byte[] getTagByteArray(Tag tag) {
        Object v2;
        block5: {
            v2 = this.e.get(tag);
            if (v2 == null || v2.getClass().getComponentType() != Integer.TYPE) break block5;
            int[] nArray = (int[])v2;
            byte[] byArray = new byte[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                byArray[i2] = (byte)nArray[i2];
            }
            return byArray;
        }
        return (byte[])v2;
    }

    public int[] getTagIntArray(Tag tag) {
        return (int[])this.e.get(tag);
    }

    public double[] getTagDoubleArray(Tag tag) {
        return (double[])this.e.get(tag);
    }

    public void setTagInt(Tag tag, int n2) {
        block3: {
            block2: {
                if (tag != Tag.BlackThreshold) break block2;
                this.g = n2;
                break block3;
            }
            this.setTagIntArray(tag, new int[]{n2});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setTagIntArray(Tag tag, int[] nArray) {
        if (tag.b() != 2 && tag.b() != 5) {
            this.a(tag, nArray);
            return;
        }
        throw new ClassCastException();
    }

    public void setTagByteArray(Tag tag, byte[] byArray) {
        if (tag.b() != 1) {
            throw new ClassCastException();
        }
        this.a(tag, byArray);
    }

    public void setTagRational(Tag tag, int n2, int n3) {
        if (tag.b() != 5) {
            throw new ClassCastException();
        }
        this.a(tag, new c_[]{new c_(n2, n3)});
    }

    public void setTagString(Tag tag, String string) {
        if (tag.b() != 2) {
            throw new ClassCastException();
        }
        this.a(tag, string);
    }

    private void a(Tag tag, Object object) {
        this.e.put(tag, object);
    }

    public void setResolution(int n2, int n3) {
        this.setTagRational(Tag.XResolution, n2, 1);
        this.setTagRational(Tag.YResolution, n3, 1);
    }

    public int getCompressionType() {
        return this.getTagInt(Tag.Compression);
    }

    public double getXResolution() {
        double d2 = this.getTagDouble(Tag.XResolution);
        double d3 = this.getTagInt(Tag.ResolutionUnit) == 3 ? 2.54 : 1.0;
        return d2 * d3;
    }

    public double getYResolution() {
        double d2 = this.getTagDouble(Tag.YResolution);
        double d3 = this.getTagInt(Tag.ResolutionUnit) == 3 ? 2.54 : 1.0;
        return d2 * d3;
    }

    public int getWidth() {
        return this.getTagInt(Tag.ImageWidth);
    }

    public int getHeight() {
        return this.getTagInt(Tag.ImageLength);
    }

    public int getNumComponents() {
        int n2 = this.getTagInt(Tag.SamplesPerPixel);
        int n3 = n2 == 0 ? 1 : n2;
        return n3;
    }

    public int getBitsPerComponent() {
        int n2 = this.getTagInt(Tag.BitsPerSample);
        int n3 = n2 == 0 ? 1 : n2;
        return n3;
    }

    public int getPhotoMetric() {
        return this.getTagInt(Tag.PhotometricInterpretation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTranslucent() {
        if (this.containsTag(Tag.ExtraSamples)) return true;
        if (this.getNumComponents() != 4) return false;
        if (this.getPhotoMetric() != 2) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getColorMap() {
        int[] nArray = this.getTagIntArray(Tag.ColorMap);
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        byte[] byArray = new byte[nArray.length];
        int n2 = byArray.length / 3;
        int i2 = 0;
        while (i2 < byArray.length) {
            byArray[i2 * 3 % byArray.length + i2 / n2] = (byte)(nArray[i2] >> 8);
            ++i2;
        }
        return byArray;
    }

    public byte[] getXMPMetaData() {
        if (this.containsTag(Tag.XMPMetaData)) {
            return this.getTagByteArray(Tag.XMPMetaData);
        }
        return null;
    }

    public ICC_ColorSpace getColorSpace() {
        if (this.containsTag(Tag.ICCProfile)) {
            byte[] byArray = this.getTagByteArray(Tag.ICCProfile);
            try {
                ICC_Profile iCC_Profile = ICC_Profile.getInstance(byArray);
                ICC_ColorSpace iCC_ColorSpace = new ICC_ColorSpace(iCC_Profile);
                return iCC_ColorSpace;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isJFIF() {
        if (this.getTagInt(Tag.JPEGInterchangeFormat) == 0) return false;
        if (this.getTagInt(Tag.Compression) != 6) {
            if (this.getTagInt(Tag.Compression) != 7) return false;
        }
        if (this.getTagIntArray(Tag.StripOffsets).length != 1) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeSamplesTo(OutputStream outputStream, boolean bl, boolean bl2) throws IOException {
        if (!bl && !bl2) {
            return;
        }
        InputStream inputStream = bl ? this.getYCbCrToRGBImageInputStream(bl2) : this.getImageInputStream(bl, bl2);
        int n3 = 0;
        byte[] byArray = new byte[8192];
        while (true) {
            int n2;
            if ((n2 = inputStream.read(byArray)) < 0) {
                inputStream.close();
                return;
            }
            outputStream.write(byArray, 0, n2);
            n3 += n2;
        }
    }

    public void writeUncompressedSamplesTo(OutputStream outputStream) throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        InputStream inputStream = this.getUncompressedImageInputStream();
        while ((n2 = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n2);
        }
    }

    public InputStream getImageInputStream(boolean bl, boolean bl2) throws IOException {
        return this.b().a(bl, bl2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getUncompressedImageInputStream() throws IOException {
        if (this.isJFIF()) {
            int n2 = this.getTagInt(Tag.JPEGInterchangeFormat);
            int n3 = this.getTagInt(Tag.JPEGInterchangeFormatLength);
            if (n3 == 0) {
                int n4 = this.getTagInt(Tag.StripOffsets);
                n3 = this.getTagInt(Tag.StripByteCounts);
                n3 -= n2 - n4;
            }
            return this.a.d.l().createSubStream(n2, n3);
        }
        int[] nArray = this.getTagIntArray(Tag.StripOffsets);
        int[] nArray2 = this.getTagIntArray(Tag.StripByteCounts);
        if (nArray != null && nArray.length == 1) {
            return this.a.d.l().createSubStream(nArray[0], nArray2[0]);
        }
        throw new IOException("Not a single stream - cannot call this method");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private d b() throws IOException {
        int n2;
        if (this.b != null) return this.b;
        int[] nArray = this.getTagIntArray(Tag.BitsPerSample);
        int n3 = nArray == null ? 1 : nArray[0];
        for (n2 = 1; nArray != null && n2 < nArray.length; ++n2) {
            if (nArray[n2] == n3) continue;
            throw new IOException("Can't use variable number of bits/component");
        }
        if (n3 != 1 && n3 != 2 && n3 != 4 && n3 != 8) {
            throw new IOException("Can't handle " + n3 + "-bit images - must be 1, 2, 4 or 8");
        }
        n2 = this.getTagInt(Tag.Compression);
        switch (n2) {
            case 1: {
                this.b = new i(this);
                return this.b;
            }
            case 5: {
                this.b = new h(this);
                return this.b;
            }
            case 32773: {
                this.b = new j(this);
                return this.b;
            }
            case 8: 
            case 32964: {
                this.b = new f(this);
                return this.b;
            }
            case 2: {
                this.b = new e(this, true, false, false);
                return this.b;
            }
            case 3: {
                if ((this.getTagInt(Tag.T4Options) & 2) != 0) {
                    throw new IOException("Group 3/Uncompressed images not supported");
                }
                this.b = new e(this, false, (this.getTagInt(Tag.T4Options) & 1) != 0, false);
                return this.b;
            }
            case 4: {
                if ((this.getTagInt(Tag.T6Options) & 2) != 0) {
                    throw new IOException("Group 4/Uncompressed images not supported");
                }
                this.b = new e(this, false, true, true);
                return this.b;
            }
            case 7: {
                this.b = new g(this);
                return this.b;
            }
            case 6: {
                if (!this.isJFIF()) throw new IOException("Old-style JPEG without JPEGInterchangeFormat tag not supported");
                this.b = new g(this);
                return this.b;
            }
        }
        throw new IOException("Unsupported compression algorithm \"" + Tag.a(n2) + "\"");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage getImage(boolean bl) throws IOException {
        SampleModel sampleModel;
        ColorModel colorModel;
        int n2;
        int n3;
        if (this.getBitsPerComponent() != 1 && this.getBitsPerComponent() != 8) {
            throw new IllegalStateException("Only 1 and 8 bit images supported by this method");
        }
        int n9 = this.getNumComponents();
        int n8 = n9 - ((bl &= this.isTranslucent()) ? 1 : 0);
        int n7 = this.getBitsPerComponent();
        int n6 = this.getWidth();
        int n5 = this.getHeight();
        int n10 = this.getPhotoMetric();
        int n4 = (n6 * n9 * n7 + 7) / 8;
        ColorSpace colorSpace = this.getColorSpace();
        byte[] byArray2 = this.getColorMap();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n4 * n5);
        this.writeSamplesTo(byteArrayOutputStream, true, bl);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (n10 == 0) {
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byArray[i2] = ~byArray[i2];
            }
            n10 = 1;
        }
        if (bl && byArray2 != null) {
            byte[] byArray3 = new byte[n6 * n5 * 4];
            for (int i3 = 0; i3 < n5; ++i3) {
                for (n3 = 0; n3 < n6; ++n3) {
                    n2 = byArray[(i3 * n6 + n3) * 2] & 0xFF;
                    byArray3[(i3 * n6 + n3) * 4] = byArray2[n2 * 3];
                    byArray3[(i3 * n6 + n3) * 4 + 1] = byArray2[n2 * 3 + 1];
                    byArray3[(i3 * n6 + n3) * 4 + 2] = byArray2[n2 * 3 + 2];
                    byArray3[(i3 * n6 + n3) * 4 + 3] = byArray[(i3 * n6 + n3) * 2 + 1];
                }
            }
            byArray2 = null;
            n10 = 2;
            n8 = 3;
            n9 = 4;
            n4 = n9 * n6;
            byArray = byArray3;
        }
        if (colorSpace == null) {
            if (n8 == 1) {
                colorSpace = ColorSpace.getInstance(1003);
            } else if (n8 == 3) {
                colorSpace = n10 == 6 ? ColorSpace.getInstance(1002) : Color.red.getColorSpace();
            } else if (n8 == 4) {
                try {
                    colorSpace = (ColorSpace)Class.forName("org.faceless.pdf2.CMYKColorSpace").getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                }
                catch (Throwable throwable) {
                    colorSpace = org.faceless.tiff.a.getInstance();
                }
            }
        }
        if (colorSpace == null) {
            throw new IOException("Can't find " + n8 + " component colorspace");
        }
        int[] nArray = new int[n9];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = n7;
        }
        if (n7 == 1) {
            byte[] byArray4 = new byte[]{0, -1};
            colorModel = new IndexColorModel(1, 2, byArray4, byArray4, byArray4);
        } else {
            colorModel = byArray2 != null ? new IndexColorModel(8, byArray2.length / 3, byArray2, 0, false) : new ComponentColorModel(colorSpace, nArray, bl, false, bl ? 3 : 1, 0);
        }
        if (colorModel instanceof IndexColorModel) {
            sampleModel = new MultiPixelPackedSampleModel(0, n6, n5, n7, n4, 0);
        } else {
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = n2;
            }
            sampleModel = new PixelInterleavedSampleModel(0, n6, n5, n9, n4, nArray);
        }
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBufferByte, null);
        return new BufferedImage(colorModel, writableRaster, false, new Hashtable());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getYCbCrToRGBImageInputStream(boolean bl) throws IOException {
        double[] dArray;
        if (this.getPhotoMetric() != 6) {
            return this.getImageInputStream(true, bl);
        }
        if (this.containsTag(Tag.YCbCrCoefficients)) {
            dArray = this.getTagDoubleArray(Tag.YCbCrCoefficients);
        } else {
            double[] dArray2 = new double[3];
            dArray2[0] = 0.299;
            dArray2[1] = 0.587;
            dArray = dArray2;
            dArray2[2] = 0.114;
        }
        double[] dArray3 = dArray;
        return new c(this.getImageInputStream(true, bl), bl, dArray3);
    }

    public String getClipPath() {
        try {
            byte[] byArray = this.getTagByteArray(Tag.ClipPath);
            if (byArray != null) {
                return this.a(byArray);
            }
            byArray = this.getTagByteArray(Tag.Photoshop);
            if (byArray != null) {
                return this.b(byArray);
            }
            return null;
        }
        catch (Exception exception) {
            Tiff.a.warning("TIFF", "Unable to extract clip path from TIFF", exception);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String a(byte[] byArray) {
        double d2 = this.getTagDouble(Tag.XClipPathUnits);
        double d3 = this.getTagDouble(Tag.YClipPathUnits);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        block40: while (n2 < byArray.length) {
            int n3 = byArray[n2++] & 0xFF;
            int n4 = byArray[n2++] & 0xFF;
            int n5 = ++n2;
            ++n2;
            int n6 = byArray[n5] & 0xFF;
            switch (n3) {
                case 1: {
                    break;
                }
                case 2: {
                    stringBuffer.append(" h ");
                    break;
                }
                case 3: {
                    int n7;
                    int n8 = n4 == 6 ? byArray[n2++] : (n7 = n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                    int n9 = n4 == 6 ? byArray[n2++] : (n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                    n7 = (int)((double)n7 * d2);
                    n9 = (int)((double)n9 * d3);
                    stringBuffer.append(new Float((double)n7 * d2) + " " + new Float((double)n9 * d3) + " m ");
                    break;
                }
                case 4: {
                    int n7;
                    int n10 = n4 == 6 ? byArray[n2++] : (n7 = n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                    int n9 = n4 == 6 ? byArray[n2++] : (n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                    stringBuffer.append(new Float((double)n7 * d2) + " " + new Float((double)n9 * d3) + " l ");
                    break;
                }
                case 8: {
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n7;
                    int n15 = n4 == 6 ? byArray[n2++] : (n14 = n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                    int n16 = n4 == 6 ? byArray[n2++] : (n13 = n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                    int n17 = n4 == 6 ? byArray[n2++] : (n12 = n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                    int n18 = n4 == 6 ? byArray[n2++] : (n11 = n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                    int n19 = n4 == 6 ? byArray[n2++] : (n7 = n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                    int n9 = n4 == 6 ? byArray[n2++] : (n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                    stringBuffer.append(new Float((double)n14 * d2) + " " + new Float((double)n13 * d3) + " " + new Float((double)n12 * d2) + " " + new Float((double)n11 * d3) + " " + new Float((double)n7 * d2) + " " + new Float((double)n9 * d3) + " c ");
                    break;
                }
                case 9: {
                    int n9;
                    int n7;
                    int n20 = n2 + n6;
                    while (n2 < n20) {
                        int n21 = n4 == 6 ? byArray[n2++] : (n7 = n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                        n9 = n4 == 6 ? byArray[n2++] : (n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF));
                        stringBuffer.append(new Float((double)n7 * d2) + " " + new Float((double)n9 * d3) + " l ");
                    }
                    continue block40;
                }
                case 10: {
                    int n20 = n2 + n6;
                    int n7 = 0;
                    int n9 = 0;
                    while (n2 < n20) {
                        stringBuffer.append(new Float((double)(n7 += n4 == 6 ? byArray[n2++] : (n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF))) * d2) + " " + new Float((double)(n9 += n4 == 6 ? byArray[n2++] : (n4 == 7 ? (byArray[n2++] << 8) + (byArray[n2++] & 0xFF) : (byArray[n2++] << 24) + ((byArray[n2++] & 0xFF) << 16) + ((byArray[n2++] & 0xFF) << 8) + (byArray[n2++] & 0xFF))) * d3) + " l ");
                    }
                    continue block40;
                }
            }
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String b(byte[] byArray) {
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n2 = 0;
            String string = null;
            while (true) {
                if (n2 >= byArray.length) {
                    return (String)hashMap.get(string);
                }
                if (byArray[n2] != 56 || byArray[n2 + 1] != 66 || byArray[n2 + 2] != 73 || byArray[n2 + 3] != 77) {
                    throw new IllegalArgumentException("Not 8BIM at " + n2);
                }
                int n3 = ((byArray[n2 + 4] & 0xFF) << 8) + (byArray[n2 + 5] & 0xFF);
                String string2 = new String(byArray, n2 + 7, byArray[n2 + 6] & 0xFF, "ISO-8859-1");
                n2 += 7 + string2.length();
                n2 = n2 + 1 & 0xFFFFFFFE;
                int n4 = ((byArray[n2] & 0xFF) << 24) + ((byArray[n2 + 1] & 0xFF) << 16) + ((byArray[n2 + 2] & 0xFF) << 8) + ((byArray[n2 + 3] & 0xFF) << 0);
                n2 += 4;
                if (n3 < 2000 || n3 >= 2999) {
                    if (n3 == 2999) {
                        string = new String(byArray, n2 + 1, byArray[n2] & 0xFF, "ISO-8859-1");
                    }
                } else {
                    boolean bl = true;
                    boolean bl2 = false;
                    byte[] byArray2 = new byte[26];
                    float[] fArray = new float[6];
                    String string3 = "";
                    StringBuffer stringBuffer = new StringBuffer();
                    NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
                    DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
                    decimalFormat.applyPattern("#0.0000");
                    for (int i2 = 0; i2 < n4; i2 += 26) {
                        System.arraycopy(byArray, n2 + i2, byArray2, 0, 26);
                        int n5 = ((byArray2[0] & 0xFF) << 8) + (byArray2[1] & 0xFF);
                        for (int i3 = 0; i3 < 6; ++i3) {
                            fArray[i3] = (float)byArray2[i3 * 4 + 2] + (float)(((byArray2[i3 * 4 + 3] & 0xFF) << 16) + ((byArray2[i3 * 4 + 4] & 0xFF) << 8) + (byArray2[i3 * 4 + 5] & 0xFF)) / 1.6777216E7f;
                            if (i3 % 2 != 0) continue;
                            fArray[i3] = 1.0f - fArray[i3];
                        }
                        if (n5 == 1 || n5 == 2 || n5 == 4 || n5 == 5) {
                            if (bl) {
                                if (bl2) {
                                    stringBuffer.append("h ");
                                }
                                stringBuffer.append(decimalFormat.format(fArray[3]) + " " + decimalFormat.format(fArray[2]) + " m ");
                                bl = false;
                                bl2 = n5 == 1 || n5 == 2;
                            } else {
                                stringBuffer.append(string3 + decimalFormat.format(fArray[1]) + " " + decimalFormat.format(fArray[0]) + " " + decimalFormat.format(fArray[3]) + " " + decimalFormat.format(fArray[2]) + " c ");
                            }
                            string3 = decimalFormat.format(fArray[5]) + " " + decimalFormat.format(fArray[4]) + " ";
                            continue;
                        }
                        bl = true;
                    }
                    stringBuffer.append("h");
                    hashMap.put(string2, stringBuffer.toString());
                    string = string2;
                }
                n2 += n4;
                n2 = n2 + 1 & 0xFFFFFFFE;
            }
        }
        catch (IOException iOException) {
            throw new Error("No ISO-8859-1 conversion");
        }
    }

    private static class c_ {
        int a;
        int b;

        c_(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }
    }
}

