/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.faceless.util.DamageSensing;

public class ARC4InputStream
extends FilterInputStream
implements DamageSensing {
    private int[] a;
    private int b;
    private int c;

    public ARC4InputStream(InputStream inputStream, byte[] byArray) {
        this(inputStream, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ARC4InputStream(InputStream inputStream, byte[] byArray, int n2, int n3) {
        super(inputStream);
        int n4;
        if (n3 < 1) throw new IllegalArgumentException("number of bytes must be between 1 and 32");
        if (n3 > 32) {
            throw new IllegalArgumentException("number of bytes must be between 1 and 32");
        }
        this.a = new int[256];
        this.c = 0;
        this.b = 0;
        for (n4 = 0; n4 < this.a.length; ++n4) {
            this.a[n4] = n4;
        }
        n4 = 0;
        int n5 = 0;
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            n5 = ((byArray[n2 + n4] & 0xFF) + this.a[i2] + n5) % 256;
            int n6 = this.a[i2];
            this.a[i2] = this.a[n5];
            this.a[n5] = n6;
            n4 = (n4 + 1) % n3;
        }
    }

    public int read() throws IOException {
        int n2 = super.read();
        if (n2 < 0) {
            return n2;
        }
        int[] nArray = this.a;
        this.b = this.b + 1 & 0xFF;
        this.c = nArray[this.b] + this.c & 0xFF;
        int n3 = nArray[this.b];
        nArray[this.b] = nArray[this.c];
        nArray[this.c] = n3;
        return (n2 ^ nArray[nArray[this.b] + nArray[this.c] & 0xFF]) & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        boolean bl = false;
        int i2 = 0;
        while (i2 < n3) {
            int n4 = this.read();
            if (n4 < 0) {
                int n5;
                if (i2 == 0) {
                    n5 = n4;
                    return n5;
                }
                n5 = i2;
                return n5;
            }
            byArray[n2 + i2] = (byte)n4;
            ++i2;
        }
        return n3;
    }

    public boolean markSupported() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDamaged() {
        if (!(this.in instanceof DamageSensing)) return false;
        if (!((DamageSensing)((Object)this.in)).isDamaged()) return false;
        return true;
    }
}

