/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ARC4OutputStream
extends FilterOutputStream {
    private int[] a = new int[256];
    private int b;
    private int c;

    public ARC4OutputStream(OutputStream outputStream, byte[] byArray) {
        this(outputStream, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    public ARC4OutputStream(OutputStream outputStream, byte[] byArray, int n2, int n3) {
        super(outputStream);
        if (byArray != null) {
            this.reset(outputStream, byArray, n2, n3);
        }
    }

    public void reset(OutputStream outputStream, byte[] byArray) {
        this.reset(outputStream, byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reset(OutputStream outputStream, byte[] byArray, int n2, int n3) {
        int n4;
        if (outputStream != null || this.out == null) {
            this.out = outputStream;
        }
        if (byArray == null || n3 < 1 || n3 > 32) {
            throw new IllegalArgumentException("number of bytes must be between 1 and 32");
        }
        this.c = 0;
        this.b = 0;
        for (n4 = 0; n4 < this.a.length; ++n4) {
            this.a[n4] = n4;
        }
        n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.a.length) {
            n5 = ((byArray[n2 + n4] & 0xFF) + this.a[n6] + n5) % 256;
            int n7 = this.a[n6];
            this.a[n6] = this.a[n5];
            this.a[n5] = n7;
            n4 = (n4 + 1) % n3;
            ++n6;
        }
        return;
    }

    public void write(int n2) throws IOException {
        int[] nArray = this.a;
        this.b = this.b + 1 & 0xFF;
        this.c = nArray[this.b] + this.c & 0xFF;
        int n3 = nArray[this.b];
        nArray[this.b] = nArray[this.c];
        nArray[this.c] = n3;
        this.out.write(n2 ^ nArray[nArray[this.b] + nArray[this.c] & 0xFF]);
    }

    public void write(byte[] byArray) throws IOException {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.write(byArray[i2]);
        }
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            this.write(byArray[i2]);
        }
    }

    public void flush() {
    }
}

