/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.faceless.util.BackedInputStream;

public final class ByteBuffer
implements Comparable,
Serializable {
    private static final long serialVersionUID = -3751419000753168560L;
    private final byte[] a;
    private final int b;
    private final int c;
    private transient int d;

    public ByteBuffer(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteBuffer(byte[] byArray, int n2, int n3) {
        this.a = byArray;
        this.b = n2;
        this.c = n3;
    }

    public ByteBuffer(String string) {
        this.b = 0;
        this.c = string.length();
        this.a = new byte[this.c];
        for (int i2 = 0; i2 < this.c; ++i2) {
            this.a[i2] = (byte)string.charAt(i2);
        }
    }

    public ByteBuffer(ByteBuffer byteBuffer) {
        this.c = byteBuffer.c;
        this.a = new byte[byteBuffer.c];
        this.b = 0;
        System.arraycopy(byteBuffer.a, byteBuffer.b, this.a, 0, this.c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer sever() {
        if (this.b == 0 && this.c == this.a.length) {
            return this;
        }
        return new ByteBuffer(this.toByteArray());
    }

    public int hashCode() {
        int n2 = this.d;
        if (n2 == 0) {
            int n3 = this.b;
            byte[] byArray = this.a;
            int n4 = this.c;
            for (int i2 = 0; i2 < n4; ++i2) {
                n2 = 31 * n2 + byArray[n3++];
            }
            this.d = n2;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        ByteBuffer byteBuffer;
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof ByteBuffer) {
            byteBuffer = (ByteBuffer)object;
            if (byteBuffer.a == this.a && byteBuffer.b == this.b && byteBuffer.c == this.c) {
                return true;
            }
            if (byteBuffer.c != this.c) {
                return false;
            }
        } else {
            if (object instanceof String) {
                return this.equalsString((String)object);
            }
            return false;
        }
        int n2 = 0;
        while (n2 < this.c) {
            if (this.a[this.b + n2] != byteBuffer.a[byteBuffer.b + n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equalsString(String string) {
        if (string.length() != this.c) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.c) {
            if (string.charAt(n2) != (this.a[this.b + n2] & 0xFF)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean startsWith(String string) {
        if (string.length() > this.c) {
            return false;
        }
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) != (this.a[this.b + n2] & 0xFF)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int compareTo(Object object) {
        if (object instanceof ByteBuffer) {
            return this.toString().compareTo(object.toString());
        }
        throw new ClassCastException(object.getClass().toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer substring(int n2) {
        if (n2 >= 0 && n2 <= this.c) {
            return new ByteBuffer(this.a, this.b + n2, this.c - n2);
        }
        throw new StringIndexOutOfBoundsException(n2);
    }

    public BackedInputStream getBackedInputStream() {
        return BackedInputStream.getInstance(this.a, this.b, this.c);
    }

    public ByteBuffer substring(int n2, int n3) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n3 > this.c) {
            throw new StringIndexOutOfBoundsException(n3);
        }
        if (n2 > n3) {
            throw new StringIndexOutOfBoundsException(n2 + ">" + n3);
        }
        return new ByteBuffer(this.a, this.b + n2, n3 - n2);
    }

    public byte[] getUnderlyingByteArray() {
        return this.a;
    }

    public int getUnderlyingOffset() {
        return this.b;
    }

    public int length() {
        return this.c;
    }

    public String toString() {
        char[] cArray = new char[this.c];
        for (int i2 = 0; i2 < this.c; ++i2) {
            cArray[i2] = (char)(this.a[this.b + i2] & 0xFF);
        }
        return new String(cArray);
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.c];
        System.arraycopy(this.a, this.b, byArray, 0, this.c);
        return byArray;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.a, this.b, this.c);
    }

    public boolean substringEquals(String string, int n2) {
        block3: {
            if (string == null || string.length() != this.c - n2) break block3;
            int n3 = 0;
            while (n2 < this.c) {
                if ((this.a[this.b + n2++] & 0xFF) == string.charAt(n3++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char charAt(int n2) {
        if (n2 >= 0 && n2 < this.c) {
            return (char)(this.a[this.b + n2] & 0xFF);
        }
        throw new StringIndexOutOfBoundsException(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int indexOf(char c2) {
        byte by = (byte)c2;
        int n2 = 0;
        while (n2 < this.c) {
            if (this.a[this.b + n2] == by) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int parseInt() {
        int n2;
        boolean bl = false;
        int n3 = 0;
        int n22 = 0;
        if (this.a[0] == 45) {
            if (this.c == 1) {
                throw new NumberFormatException("-");
            }
            bl = true;
            ++n22;
        }
        while (n22 < this.c) {
            byte by = this.a[this.b + n22];
            if (by < 48) throw new NumberFormatException(this.toString());
            if (by > 57) {
                throw new NumberFormatException(this.toString());
            }
            int n4 = n3;
            if ((n3 = n3 * 10 + (by - 48)) < n4) {
                throw new NumberFormatException("Overflow: " + this.toString());
            }
            ++n22;
        }
        if (bl) {
            n2 = -n3;
            return n2;
        }
        n2 = n3;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long parseLong() {
        long l2;
        boolean bl = false;
        long l22 = 0L;
        int n2 = 0;
        if (this.a[this.b] == 45) {
            if (this.c == 1) {
                throw new NumberFormatException("-");
            }
            bl = true;
            ++n2;
        }
        while (n2 < this.c) {
            byte by = this.a[this.b + n2];
            if (by < 48) throw new NumberFormatException(this.toString());
            if (by > 57) {
                throw new NumberFormatException(this.toString());
            }
            long l3 = l22;
            if ((l22 = l22 * 10L + (long)(by - 48)) < l3) {
                throw new NumberFormatException("Overflow: " + this.toString());
            }
            ++n2;
        }
        if (bl) {
            l2 = -l22;
            return l2;
        }
        l2 = l22;
        return l2;
    }

    public float parseFloat() {
        return this.parseFloat(true, 10);
    }

    public float parseFloat(boolean bl) {
        return this.parseFloat(bl, 10);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float parseFloat(boolean bl, int n2) {
        int n3;
        int n4;
        int n5 = this.c;
        long l2 = 0L;
        if (n5 == 0) {
            if (bl) {
                throw new NumberFormatException(this.toString());
            }
            return Float.NaN;
        }
        int n6 = this.a[this.b] & 0xFF;
        if (n6 == 45 || n6 == 43) {
            if (n5 == 1) {
                if (bl) {
                    throw new NumberFormatException(this.toString());
                }
                return Float.NaN;
            }
            n4 = n6 == 45 ? -1 : 1;
            n3 = 1;
            n6 = this.a[this.b + 1] & 0xFF;
        } else {
            n4 = 1;
            n3 = 0;
        }
        if (n6 >= 48 && n6 <= 57) {
            l2 = n6 - 48;
            while (++n3 < n5 && (n6 = this.a[this.b + n3] & 0xFF) >= 48 && n6 <= 57) {
                l2 = l2 * 10L + (long)n6 - 48L;
            }
        }
        if (n3 < n5) {
            if (n6 != 46) {
                if (bl) {
                    throw new NumberFormatException(this.toString());
                }
                return Float.NaN;
            }
            int n7 = 0;
            while (++n3 < n5 && (n6 = this.a[this.b + n3] & 0xFF) >= 48 && n6 <= 57) {
                if (n7 == n2) {
                    if (n6 >= 53) {
                        ++l2;
                    }
                } else if (n7 < n2) {
                    l2 = l2 * 10L + (long)n6 - 48L;
                    n4 *= 10;
                }
                ++n7;
            }
            if (n3 != n5) {
                if (bl) {
                    throw new NumberFormatException(this.toString());
                }
                return Float.NaN;
            }
        }
        return (float)((double)l2 / (double)n4);
    }

    public double parseDouble() {
        return Double.parseDouble(this.toString());
    }

    public String dump() {
        return ByteBuffer.debug(this.a, this.b, this.c);
    }

    public static final String debug(byte[] byArray) {
        return ByteBuffer.debug(byArray, 0, byArray.length);
    }

    public static final String debug(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer(n3 * 2);
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = Integer.toHexString(byArray[n2 + i2] & 0xFF);
            if (string.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String debugText(byte[] byArray, int n2, int n3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        int i2 = 0;
        while (true) {
            if (i2 >= n3) {
                stringBuffer.append("\"");
                return stringBuffer.toString();
            }
            char c2 = (char)byArray[n2 + i2];
            if (c2 == '\\') {
                stringBuffer.append("\\\\");
            } else if (c2 >= ' ' && c2 <= '\u007f') {
                stringBuffer.append(c2);
            } else if (c2 == '\n') {
                stringBuffer.append("\\n");
            } else if (c2 == '\r') {
                stringBuffer.append("\\r");
            } else if (c2 == '\u0000') {
                stringBuffer.append("\\0");
            } else {
                String string = Integer.toHexString(c2);
                if (string.length() < 2) {
                    string = "0" + string;
                }
                stringBuffer.append("\\x" + string);
            }
            ++i2;
        }
    }
}

