/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class CountingOutputStream
extends BufferedOutputStream {
    protected MessageDigest digest;
    protected volatile long streamcount;
    protected static final /* synthetic */ Object streamcount$lock;

    public CountingOutputStream(OutputStream outputStream) {
        this(outputStream, 8192);
    }

    public CountingOutputStream(OutputStream outputStream, int n2) {
        super(outputStream, n2);
    }

    public void setMessageDigest(MessageDigest messageDigest) throws IOException {
        this.flush();
        this.digest = messageDigest;
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void write(String string) throws IOException {
        int n2 = string.length();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            int n3 = i2;
            byte by = (byte)(c2 > '\u00ff' ? 63 : (byte)c2);
            byArray[n3] = by;
        }
        this.write(byArray, 0, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n2) throws IOException {
        long l2;
        super.write(n2);
        if (this.digest != null) {
            this.digest.update((byte)n2);
        }
        Object object = streamcount$lock;
        synchronized (object) {
            l2 = this.streamcount;
        }
        Object object2 = streamcount$lock;
        synchronized (object2) {
            this.streamcount = l2 + 1L;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void close() throws IOException {
        this.flush();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        long l2;
        super.write(byArray, n2, n3);
        if (this.digest != null) {
            this.digest.update(byArray, n2, n3);
        }
        Object object = streamcount$lock;
        synchronized (object) {
            l2 = this.streamcount;
        }
        Object object2 = streamcount$lock;
        synchronized (object2) {
            this.streamcount = l2 + (long)n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tell() {
        long l2;
        Object object = streamcount$lock;
        synchronized (object) {
            l2 = this.streamcount;
        }
        return l2;
    }

    public void flushBuffer() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        super.flush();
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void setOutputStream(OutputStream outputStream) throws IOException {
        this.flush();
        this.out = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementPosition(long l2) {
        long l3;
        Object object = streamcount$lock;
        synchronized (object) {
            l3 = this.streamcount;
        }
        Object object2 = streamcount$lock;
        synchronized (object2) {
            this.streamcount = l3 + l2;
        }
    }

    static {
        streamcount$lock = new Object();
    }
}

