/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.IOException;
import java.io.InputStream;
import org.faceless.util.BitStreamInputStream;
import org.faceless.util.ByteQueueInputStream;
import org.faceless.util.ResettableFilterInputStream;
import org.faceless.util.SparseArray;

public final class LZWInputStream
extends ByteQueueInputStream
implements ResettableFilterInputStream {
    public static final byte VARIATION_NORMAL = 0;
    public static final byte VARIATION_TIFF = 1;
    public static final byte VARIATION_GIF = 2;
    private final int d;
    private final int e;
    private final int f;
    private final int g;
    private final int h;
    private final SparseArray i;
    private int j;
    private int k;
    private int l;
    private int m;
    private BitStreamInputStream n;
    private byte[] o;
    private byte[] p;
    private boolean q;

    public LZWInputStream(InputStream inputStream, int n2, byte by) {
        this(inputStream, n2, by, 4096);
    }

    public LZWInputStream(InputStream inputStream, int n2, byte by, int n3) {
        super(inputStream, n3);
        this.h = n2;
        this.g = by == 1 ? 2 : 1;
        this.d = 1 << n2 - 1;
        this.e = this.d + 1;
        this.f = this.d + 1;
        this.n = new BitStreamInputStream(inputStream, by == 2);
        this.i = new SparseArray();
        this.n.setBitFieldSize(n2);
        this.m = n2;
        this.j = this.a();
        this.q = true;
    }

    public void reset(InputStream inputStream) {
        super.reset(inputStream);
        this.i.clear();
        this.n = new BitStreamInputStream(inputStream);
        this.n.setBitFieldSize(this.h);
        this.m = this.h;
        this.j = this.a();
        this.q = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fillQueue(int n2) throws IOException {
        if (this.q) {
            this.l = this.k = this.n.readBitField();
            this.q = false;
        }
        while (n2 > 0) {
            int n3 = this.n.readBitField();
            if (n3 < 0) return;
            if (n3 == this.e) {
                return;
            }
            if (n3 == this.d) {
                this.m = this.h;
                this.n.setBitFieldSize(this.m);
                this.j = this.a();
                if (this.g != 2) continue;
                this.i.put(this.j, this.o);
                ++this.j;
                n3 = this.n.readBitField();
                if (n3 == this.e) return;
                if (n3 < 0) {
                    return;
                }
                byte[] byArray = (byte[])this.i.get(n3);
                if (byArray == null) {
                    return;
                }
                this.push(byArray, 0, byArray.length);
                n2 -= byArray.length;
                this.k = n3;
                this.l = byArray[0];
                continue;
            }
            this.o = (byte[])this.i.get(n3);
            if (this.i.get(this.k) != null) {
                this.p = (byte[])this.i.get(this.k);
            }
            if (this.o == null && this.p == null) {
                throw new IOException("Corrupt stream: Token and PrevToken both null");
            }
            if (this.o == null) {
                this.o = new byte[this.p.length + 1];
                System.arraycopy(this.p, 0, this.o, 0, this.p.length);
                this.o[this.o.length - 1] = (byte)this.l;
            }
            this.push(this.o, 0, this.o.length);
            n2 -= this.o.length;
            this.l = this.o[0];
            if (this.p != null) {
                this.o = new byte[this.p.length + 1];
                System.arraycopy(this.p, 0, this.o, 0, this.p.length);
                this.o[this.o.length - 1] = (byte)this.l;
            }
            this.i.put(this.j++, this.o);
            if (this.m < 12 && this.i.size() == (1 << this.m) - this.g) {
                this.n.setBitFieldSize(++this.m);
            }
            this.k = n3;
        }
    }

    private int a() {
        this.i.clear();
        for (int i2 = 0; i2 < this.d; ++i2) {
            this.i.put(i2, new byte[]{(byte)i2});
        }
        return this.f;
    }
}

