/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.faceless.util.ByteBuffer;

public final class SeekableByteArrayOutputStream
extends OutputStream {
    private int a;
    private int b;
    private int c;
    private byte[] d;
    private final boolean e;

    public SeekableByteArrayOutputStream() {
        this(512);
    }

    public SeekableByteArrayOutputStream(int n2) {
        this.d = new byte[n2];
        this.a = 0;
        this.b = n2;
        this.e = true;
    }

    public SeekableByteArrayOutputStream(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public SeekableByteArrayOutputStream(byte[] byArray, int n2, int n3) {
        this.d = byArray;
        this.a = n2;
        this.b = n3;
        this.e = false;
    }

    private void a(int n2) throws ArrayIndexOutOfBoundsException {
        if (!this.e) {
            throw new ArrayIndexOutOfBoundsException("End of buffer reached");
        }
        n2 = Math.max(n2, this.b + (this.b >> 1));
        byte[] byArray = new byte[n2];
        System.arraycopy(this.d, 0, byArray, 0, this.c);
        this.d = byArray;
        this.b = byArray.length;
        this.a = 0;
    }

    public void write(int n2) {
        if (this.c == this.b) {
            this.a(this.c + 1);
        }
        this.d[this.a + this.c++] = (byte)n2;
    }

    public void writeLong(long l2) {
        this.write((int)(l2 >> 56));
        this.write((int)(l2 >> 48));
        this.write((int)(l2 >> 40));
        this.write((int)(l2 >> 32));
        this.write((int)(l2 >> 24));
        this.write((int)(l2 >> 16));
        this.write((int)(l2 >> 8));
        this.write((int)(l2 >> 0));
    }

    public void writeInt(int n2) {
        this.write(n2 >> 24);
        this.write(n2 >> 16);
        this.write(n2 >> 8);
        this.write(n2);
    }

    public void writeShort(int n2) {
        this.write(n2 >> 8);
        this.write(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(byte[] byArray, int n2, int n3) {
        if (n2 < 0 || n2 + n3 > byArray.length || n3 < 0) {
            throw new IndexOutOfBoundsException("offset " + n2 + " and length " + n3 + " outside range 0-" + byArray.length);
        }
        if (n3 > 0) {
            int n4 = this.c + n3;
            if (n4 > this.b) {
                this.a(n4);
            }
            System.arraycopy(byArray, n2, this.d, this.a + this.c, n3);
            this.c = n4;
        }
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[8192];
        int n2 = inputStream.read(byArray);
        while (n2 >= 0) {
            this.write(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.d, this.a, this.c);
    }

    public void reset() {
        this.c = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setLength(int n2) {
        if (n2 <= this.c && n2 >= 0) {
            this.c = n2;
            return;
        }
        throw new IllegalArgumentException("Length 0 <= " + n2 + " <= " + this.c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getUnderlyingByteArray() {
        if (this.a == 0 && this.c == this.b) {
            return this.d;
        }
        byte[] byArray = new byte[this.c];
        System.arraycopy(this.d, 0, byArray, 0, this.c);
        return byArray;
    }

    public int size() {
        return this.c;
    }

    public String toString() {
        return new String(this.d, 0, this.c);
    }

    public void close() {
    }

    public ByteBuffer getAsByteBuffer() {
        return new ByteBuffer(this.d, 0, this.c);
    }
}

