/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.faceless.util.asn1.ASN1Boolean;
import org.faceless.util.asn1.ASN1Enumerated;
import org.faceless.util.asn1.ASN1Integer;
import org.faceless.util.asn1.ASN1Object;
import org.faceless.util.asn1.ASN1Oid;
import org.faceless.util.asn1.ASN1Sequence;
import org.faceless.util.asn1.ASN1Set;
import org.faceless.util.asn1.ASN1String;
import org.faceless.util.asn1.ASN1TaggedObject;

public class ASN1InputStream
extends FilterInputStream {
    private int a;
    private boolean b;

    public ASN1InputStream(byte[] byArray) {
        super(new ByteArrayInputStream(byArray));
    }

    public ASN1InputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int tell() {
        return this.a;
    }

    public int read() throws IOException {
        int n2 = super.read();
        if (n2 >= 0) {
            ++this.a;
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = super.read(byArray, n2, n3);
        if (n4 >= 0) {
            this.a += n4;
        }
        return n4;
    }

    public int readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        for (n4 = 0; n4 < n3 && (n5 = this.read(byArray, n2 + n4, n3 - n4)) >= 0; n4 += n5) {
        }
        return n4;
    }

    int a() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ASN1Object readObject() throws IOException {
        int n2;
        boolean bl;
        if (this.b) {
            return null;
        }
        int n3 = this.a();
        boolean bl2 = (n3 & 0xC0) == 128;
        boolean bl3 = bl = (n3 & 0x20) == 32;
        if ((n3 & 0x1F) == 31) {
            n2 = this.a();
            n3 = 0;
            while ((n2 & 0x80) != 0) {
                n3 = (n3 << 7) + (n2 & 0x7F);
                n2 = this.a();
            }
            n3 = (n3 << 7) + (n2 & 0x7F);
        } else {
            n3 &= 0x1F;
        }
        n2 = this.a();
        if (n2 == 128) {
            n2 = -1;
        } else if ((n2 & 0x80) != 0) {
            int n4 = n2 & 0x7F;
            n2 = 0;
            for (int i2 = 0; i2 < n4; ++i2) {
                n2 = (n2 << 8) + this.a();
            }
            if (n4 > 4) throw new IOException("Length > 2^31 not supported (ll=" + n4 + ")");
            if (n2 < 0) {
                throw new IOException("Length > 2^31 not supported (ll=" + n4 + ")");
            }
        }
        ASN1Object aSN1Object = null;
        if (bl2) {
            if (bl) {
                return ASN1TaggedObject.a(this, n2, n3);
            }
            aSN1Object = ASN1String.a(this, n2, 4);
            return new ASN1TaggedObject(n3, false, aSN1Object);
        }
        switch (n3) {
            case 0: {
                this.b = true;
                return null;
            }
            case 5: {
                return ASN1Object.NULL;
            }
            case 1: {
                return ASN1Boolean.a(this, n2);
            }
            case 2: {
                return ASN1Integer.a(this, n2);
            }
            case 10: {
                return ASN1Enumerated.b(this, n2);
            }
            case 6: 
            case 13: {
                return ASN1Oid.a(this, n2, n3);
            }
            case 3: 
            case 4: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: {
                return ASN1String.a(this, n2, n3);
            }
            case 16: {
                return ASN1Sequence.a(this, n2);
            }
            case 17: {
                return ASN1Set.a(this, n2);
            }
        }
        throw new IOException("Unknown type " + n3);
    }
}

