/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.faceless.util.asn1.ASN1InputStream;
import org.faceless.util.asn1.ASN1Object;

public class ASN1Oid
extends ASN1Object {
    private static final long serialVersionUID = -8391450785045990808L;
    private final int[] a;
    private final String b;
    public static final ASN1Oid RSAENCRYPTION = new ASN1Oid("1.2.840.113549.1.1.1", "rsaEncryption");
    public static final ASN1Oid SHA1WITHRSAENCRYPTION = new ASN1Oid("1.2.840.113549.1.1.5", "sha1WithRSAEncryption");
    public static final ASN1Oid DES_EDE3_CBC = new ASN1Oid("1.2.840.113549.3.7", "des_EDE3_CBC");
    public static final ASN1Oid MD2 = new ASN1Oid("1.2.840.113549.2.2", "md2");
    public static final ASN1Oid MD5 = new ASN1Oid("1.2.840.113549.2.5", "md5");
    public static final ASN1Oid DATA = new ASN1Oid("1.2.840.113549.1.7.1", "data");
    public static final ASN1Oid SIGNEDDATA = new ASN1Oid("1.2.840.113549.1.7.2", "signedData");
    public static final ASN1Oid ENVELOPEDDATA = new ASN1Oid("1.2.840.113549.1.7.3", "envelopedData");
    public static final ASN1Oid PKCS_9_AT_EMAILADDRESS = new ASN1Oid("1.2.840.113549.1.9.1", "pkcs_9_at_emailAddress");
    public static final ASN1Oid PKCS_9_AT_CONTENTTYPE = new ASN1Oid("1.2.840.113549.1.9.3", "pkcs_9_at_contentType");
    public static final ASN1Oid PKCS_9_AT_MESSAGEDIGEST = new ASN1Oid("1.2.840.113549.1.9.4", "pkcs_9_at_messageDigest");
    public static final ASN1Oid ID_SIGNINGTIME = new ASN1Oid("1.2.840.113549.1.9.5", "id-signingTime");
    public static final ASN1Oid ID_COUNTERSIGNATURE = new ASN1Oid("1.2.840.113549.1.9.6", "id-countersignature");
    public static final ASN1Oid ID_CT_TSTINFO = new ASN1Oid("1.2.840.113549.1.9.16.1.4", "id_ct_TSTInfo");
    public static final ASN1Oid ID_AA_CONTENTHINT = new ASN1Oid("1.2.840.113549.1.9.16.2.4", "id-aa-contentHint");
    public static final ASN1Oid ID_AA_SIGNINGCERTIFICATE = new ASN1Oid("1.2.840.113549.1.9.16.2.12", "id-aa-signingCertificate");
    public static final ASN1Oid ID_AA_CONTENTIDENTIFIER = new ASN1Oid("1.2.840.113549.1.9.16.2.7", "id-aa-contentIdentifier");
    public static final ASN1Oid ID_AA_CONTENTREFERENCE = new ASN1Oid("1.2.840.113549.1.9.16.2.10", "id-aa-contentReference");
    public static final ASN1Oid ID_AA_SIGNATURETIMESTAMPTOKEN = new ASN1Oid("1.2.840.113549.1.9.16.2.14", "id-aa-signatureTimeStampToken");
    public static final ASN1Oid ID_AA_SIGNATUREPOLICYID = new ASN1Oid("1.2.840.113549.1.9.16.2.15", "id-aa-ets-sigPolicyId");
    public static final ASN1Oid ID_AA_ETS_COMMITMENTTYPE = new ASN1Oid("1.2.840.113549.1.9.16.2.16", "id-aa-ets-commitmentType");
    public static final ASN1Oid ID_AA_ETS_SIGNERATTR = new ASN1Oid("1.2.840.113549.1.9.16.2.18", "id-aa-ets-signerAttr");
    public static final ASN1Oid ID_AA_ETS_CONTENTTIMESTAMP = new ASN1Oid("1.2.840.113549.1.9.16.2.20", "id-aa-ets-contentTimeStamp");
    public static final ASN1Oid ID_AA_SIGNINGCERTIFICATEV2 = new ASN1Oid("1.2.840.113549.1.9.16.2.47", "id-aa-signingCertificateV2");
    public static final ASN1Oid COMMONNAME = new ASN1Oid("2.5.4.3", "commonName");
    public static final ASN1Oid COUNTRYNAME = new ASN1Oid("2.5.4.6", "countryName");
    public static final ASN1Oid LOCALITYNAME = new ASN1Oid("2.5.4.7", "localityName");
    public static final ASN1Oid STATEORPROVINCENAME = new ASN1Oid("2.5.4.8", "stateOrProvinceName");
    public static final ASN1Oid STREETADDRESS = new ASN1Oid("2.5.4.9", "streetAddress");
    public static final ASN1Oid ORGANIZATION = new ASN1Oid("2.5.4.10", "organization");
    public static final ASN1Oid ORGANIZATIONALUNITNAME = new ASN1Oid("2.5.4.11", "orgnanizationalUnitName");
    public static final ASN1Oid ID_SHA1 = new ASN1Oid("1.3.14.3.2.26", "id_SHA1");
    public static final ASN1Oid RIPEMD160 = new ASN1Oid("1.3.36.3.2.1", "ripemd160");
    public static final ASN1Oid ID_KP_TIMESTAMPING = new ASN1Oid("1.3.6.1.5.5.7.3.8", "id_kp_timeStamping");
    public static final ASN1Oid ID_DSA = new ASN1Oid("1.2.840.10040.4.1", "id_dsa");
    public static final ASN1Oid ID_ECDSA_WITH_SHA1 = new ASN1Oid("1.2.840.10045.4.1", "ecdsa-with-SHA1");
    public static final ASN1Oid ID_ECDSAWITHSHA256 = new ASN1Oid("1.2.840.10045.4.3.2", "ecdsaWithSHA256");
    public static final ASN1Oid ID_ECDSAWITHSHA384 = new ASN1Oid("1.2.840.10045.4.3.3", "ecdsaWithSHA384");
    public static final ASN1Oid ID_ECDSAWITHSHA512 = new ASN1Oid("1.2.840.10045.4.3.4", "ecdsaWithSHA512");
    public static final ASN1Oid ID_SHA256 = new ASN1Oid("2.16.840.1.101.3.4.2.1", "id_sha256");
    public static final ASN1Oid ID_SHA384 = new ASN1Oid("2.16.840.1.101.3.4.2.2", "id_sha384");
    public static final ASN1Oid ID_SHA512 = new ASN1Oid("2.16.840.1.101.3.4.2.3", "id_sha512");
    public static final ASN1Oid ADOBE_TIMESTAMPSERVICE = new ASN1Oid("1.2.840.113583.1.1.9.1", "adobe_timestampservice");
    public static final ASN1Oid ADOBE_ARCHIVEREVINFO = new ASN1Oid("1.2.840.113583.1.1.9.2", "adobe_archiverevinfo");

    public ASN1Oid(int[] nArray) {
        this.a = (int[])nArray.clone();
        this.b = null;
    }

    public ASN1Oid(String string) {
        this(string, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ASN1Oid(String string, String string2) {
        int n2;
        if (string == null || string.length() == 0) {
            String string3;
            StringBuffer stringBuffer = new StringBuffer().append("Illegal OID ");
            if (string == null) {
                string3 = "null";
                throw new IllegalArgumentException(stringBuffer.append(string3).toString());
            }
            string3 = "\"\"";
            throw new IllegalArgumentException(stringBuffer.append(string3).toString());
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) != '.') continue;
            ++n3;
        }
        this.a = new int[n3 + 1];
        n3 = 0;
        n2 = 0;
        while (true) {
            if (n2 >= string.length()) {
                this.a[n5] = n4;
                this.b = string2;
                return;
            }
            char c2 = string.charAt(n2);
            if (c2 == '.' && n2 - n3 > 0 && n2 != string.length() - 1) {
                this.a[n5++] = n4;
                n4 = 0;
                n3 = n2 + 1;
            } else {
                if (c2 < '0') throw new IllegalArgumentException("Illegal OID \"" + string + "\"");
                if (c2 > '9') throw new IllegalArgumentException("Illegal OID \"" + string + "\"");
                n4 = n4 * 10 + c2 - 48;
            }
            ++n2;
        }
    }

    public int getType() {
        int n2 = this.a[0] < 3 ? 6 : 13;
        return n2;
    }

    int b() {
        int n2 = 0;
        int n3 = 0;
        if (this.a[0] < 3) {
            n3 = 1;
            n2 = 2;
        }
        for (int i2 = n2; i2 < this.a.length; ++i2) {
            int n4 = this.a[i2];
            if (n4 < 128) {
                ++n3;
                continue;
            }
            if (n4 < 16384) {
                n3 += 2;
                continue;
            }
            if (n4 < 0x1FFFFF) {
                n3 += 3;
                continue;
            }
            n3 += 4;
        }
        return n3;
    }

    public int hashCode() {
        int n2 = 1;
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            n2 = 31 * n2 + this.a[i2];
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void a(OutputStream outputStream) throws IOException {
        int n2 = 0;
        if (this.a[0] < 3) {
            outputStream.write(this.a[0] * 40 + this.a[1]);
            n2 = 2;
        }
        int i2 = n2;
        while (i2 < this.a.length) {
            int n3 = this.a[i2];
            if (n3 > 127) {
                if (n3 > 16383) {
                    if (n3 > 0x1FFFFF) {
                        outputStream.write(n3 >> 21 & 0x7F | 0x80);
                    }
                    outputStream.write(n3 >> 14 & 0x7F | 0x80);
                }
                outputStream.write(n3 >> 7 & 0x7F | 0x80);
            }
            outputStream.write(n3 & 0x7F);
            ++i2;
        }
        return;
    }

    static ASN1Object a(ASN1InputStream aSN1InputStream, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int[] nArray = new int[n2 + 1];
        int n6 = 0;
        if (n3 == 6) {
            n5 = aSN1InputStream.a();
            nArray[0] = n5 / 40;
            nArray[1] = n5 % 40;
            n6 = 1;
            n4 = 2;
        } else {
            n4 = 0;
        }
        while (n6 < n2) {
            n5 = aSN1InputStream.a();
            ++n6;
            while (true) {
                if (n6 >= n2 || (n5 & 0x80) != 128) break;
                nArray[n4] = (nArray[n4] << 7) + (n5 & 0x7F);
                n5 = aSN1InputStream.a();
                ++n6;
            }
            if ((n5 & 0x80) == 128) {
                throw new EOFException();
            }
            nArray[n4] = (nArray[n4] << 7) + (n5 & 0x7F);
            ++n4;
        }
        int[] nArray2 = new int[n4];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        return new ASN1Oid(nArray2);
    }

    public int[] get() {
        return (int[])this.a.clone();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String toNumericString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.a.length) {
            if (n2 != 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(Integer.toString(this.a[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = this.b == null ? this.toNumericString() : this.b;
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (object instanceof ASN1Oid) {
            return Arrays.equals(this.a, ((ASN1Oid)object).a);
        }
        if (!(object instanceof String)) return false;
        if (object.equals(this.b)) return true;
        if (object.equals(this.toNumericString())) return true;
        return false;
    }
}

