/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.asn1;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.faceless.util.asn1.ASN1InputStream;
import org.faceless.util.asn1.ASN1Object;
import org.faceless.util.asn1.ASN1Sequence;
import org.faceless.util.asn1.ASN1TaggedObject;

public class ASN1Set
extends ASN1Object {
    private static final long serialVersionUID = -2459432545526583867L;
    protected final List values;

    public ASN1Set() {
        this(new ArrayList());
    }

    public ASN1Set(ASN1Object aSN1Object) {
        this.values = new ArrayList(1);
        this.values.add(aSN1Object);
    }

    public ASN1Set(ASN1Object[] aSN1ObjectArray) {
        this.values = new ArrayList(aSN1ObjectArray.length);
        this.values.addAll(Arrays.asList(aSN1ObjectArray));
    }

    public ASN1Set(List list) {
        this.values = list;
    }

    public int getType() {
        return 17;
    }

    boolean a() {
        return true;
    }

    public static ASN1Set cast(ASN1TaggedObject aSN1TaggedObject) {
        if (aSN1TaggedObject == null) {
            return null;
        }
        ASN1Object aSN1Object = aSN1TaggedObject.get();
        if (aSN1TaggedObject.isExplicit()) {
            return new ASN1Set(aSN1Object);
        }
        if (aSN1Object instanceof ASN1Set) {
            return (ASN1Set)aSN1Object;
        }
        if (aSN1Object instanceof ASN1Sequence) {
            return new ASN1Set(((ASN1Sequence)aSN1Object).all());
        }
        throw new ClassCastException(aSN1Object.getClass().toString());
    }

    int b() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.values.size(); ++i2) {
            ASN1Object aSN1Object = this.get(i2);
            n2 += aSN1Object.c();
        }
        return n2;
    }

    void a(OutputStream outputStream) throws IOException {
        for (int i2 = 0; i2 < this.values.size(); ++i2) {
            ASN1Object aSN1Object = (ASN1Object)this.values.get(i2);
            aSN1Object.write(outputStream);
        }
    }

    static ASN1Object a(ASN1InputStream aSN1InputStream, int n2) throws IOException {
        ASN1Object aSN1Object;
        ASN1Set aSN1Set = new ASN1Set();
        int n3 = aSN1InputStream.tell();
        while (aSN1InputStream.tell() - n3 < n2 && (aSN1Object = aSN1InputStream.readObject()) != null) {
            aSN1Set.values.add(aSN1Object);
        }
        return aSN1Set;
    }

    List d() {
        return this.values;
    }

    public int size() {
        return this.values.size();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ASN1Object get(int n2) {
        if (n2 >= 0 && n2 < this.values.size()) {
            return (ASN1Object)this.values.get(n2);
        }
        throw new IllegalArgumentException("ASN1Set: " + n2 + " outside range 0.." + (this.values.size() - 1));
    }

    public Collection all() {
        return Collections.unmodifiableCollection(this.values);
    }

    public String toString() {
        String string = this.values.toString();
        string = "{" + string.substring(1, string.length() - 1) + "}";
        return string;
    }
}

