/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.asn1;

import org.faceless.util.asn1.ASN1Integer;
import org.faceless.util.asn1.ASN1Object;
import org.faceless.util.asn1.ASN1Oid;
import org.faceless.util.asn1.ASN1Sequence;
import org.faceless.util.asn1.ASN1Set;
import org.faceless.util.asn1.ASN1String;
import org.faceless.util.asn1.ASN1TaggedObject;
import org.faceless.util.asn1.RecipientInfo;

public class EnvelopedData
extends ASN1Sequence {
    private static final long serialVersionUID = 769164076699254292L;

    static EnvelopedData a(ASN1Object aSN1Object) {
        EnvelopedData envelopedData = aSN1Object instanceof EnvelopedData ? (EnvelopedData)aSN1Object : new EnvelopedData(aSN1Object);
        return envelopedData;
    }

    private EnvelopedData(ASN1Object aSN1Object) {
        super(((ASN1Sequence)aSN1Object).values);
    }

    public EnvelopedData(ASN1Oid aSN1Oid, ASN1Oid aSN1Oid2, ASN1Object aSN1Object, byte[] byArray, RecipientInfo[] recipientInfoArray) {
        this.add(new ASN1Integer(0L));
        this.add(new ASN1Set(recipientInfoArray));
        this.add(new ASN1Sequence(new ASN1Object[]{aSN1Oid, new ASN1Sequence(aSN1Oid2, aSN1Object == null ? NULL : aSN1Object), new ASN1TaggedObject(0, false, new ASN1String(byArray))}));
    }

    public int getVersion() {
        return ((ASN1Integer)this.get(0)).intValue();
    }

    public RecipientInfo getRecipientInfo(int n2) {
        return RecipientInfo.a(this.getSet(1).get(n2));
    }

    public int getNumRecipients() {
        return this.getSet(1).size();
    }

    public ASN1Oid getContentType() {
        return (ASN1Oid)this.getSequence(2).get(0);
    }

    public ASN1Oid getEncryptionAlgorithm() {
        return (ASN1Oid)this.getSequence(2).getSequence(1).get(0);
    }

    public byte[] getEncryptionAlgorithmParams() {
        ASN1Object aSN1Object = this.getSequence(2).getSequence(1).get(1);
        if (aSN1Object == NULL) {
            return null;
        }
        if (aSN1Object instanceof ASN1String) {
            return ((ASN1String)aSN1Object).getBytes();
        }
        return aSN1Object.getEncoded();
    }

    public byte[] getEncryptedContent() {
        ASN1String aSN1String = (ASN1String)this.getSequence(2).getTaggedObject(0).get();
        byte[] byArray = aSN1String == null ? null : aSN1String.getBytes();
        return byArray;
    }

    public String toString() {
        try {
            return "{envelopedData: version=" + this.getVersion() + " type=" + this.getContentType() + " algo=" + this.getEncryptionAlgorithm() + " content+" + this.getEncryptedContent().length + " recipients=" + this.getNumRecipients() + "=" + this.getRecipientInfo(0) + "}";
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

