/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.asn1;

import java.io.IOException;
import java.math.BigInteger;
import javax.security.auth.x500.X500Principal;
import org.faceless.util.asn1.ASN1InputStream;
import org.faceless.util.asn1.ASN1Integer;
import org.faceless.util.asn1.ASN1Object;
import org.faceless.util.asn1.ASN1Oid;
import org.faceless.util.asn1.ASN1Sequence;
import org.faceless.util.asn1.ASN1String;

public class RecipientInfo
extends ASN1Sequence {
    private static final long serialVersionUID = -4062647776928025826L;

    static RecipientInfo a(ASN1Object aSN1Object) {
        RecipientInfo recipientInfo = aSN1Object instanceof RecipientInfo ? (RecipientInfo)aSN1Object : new RecipientInfo(aSN1Object);
        return recipientInfo;
    }

    private RecipientInfo(ASN1Object aSN1Object) {
        super(((ASN1Sequence)aSN1Object).values);
    }

    public RecipientInfo(X500Principal x500Principal, BigInteger bigInteger, ASN1Oid aSN1Oid, byte[] byArray) {
        int n2 = 0;
        this.add(new ASN1Integer(n2));
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(x500Principal.getEncoded());
            aSN1Sequence.add(aSN1InputStream.readObject());
            aSN1InputStream.close();
            aSN1Sequence.add(new ASN1Integer(bigInteger));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.add(aSN1Sequence);
        this.add(new ASN1Sequence(aSN1Oid, NULL));
        this.add(new ASN1String(byArray));
    }

    public int getVersion() {
        return ((ASN1Integer)this.get(0)).intValue();
    }

    public X500Principal getIssuer() {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)this.get(1);
        return new X500Principal(aSN1Sequence.get(0).getEncoded());
    }

    public BigInteger getSerialNumber() {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)this.get(1);
        return ((ASN1Integer)aSN1Sequence.get(1)).get();
    }

    public ASN1Oid getKeyEncryptionAlgorithm() {
        return (ASN1Oid)((ASN1Sequence)this.get(2)).get(0);
    }

    public byte[] getEncryptedKey() {
        return ((ASN1String)this.get(3)).getBytes();
    }

    public String toString() {
        return "{recipientInfo: version=" + this.getVersion() + " is={" + this.getIssuer() + "} sn=" + this.getSerialNumber() + " da=" + this.getKeyEncryptionAlgorithm() + " dig=" + this.getEncryptedKey().length + "}";
    }
}

