/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.asn1;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.faceless.util.asn1.ASN1InputStream;
import org.faceless.util.asn1.ASN1Integer;
import org.faceless.util.asn1.ASN1Object;
import org.faceless.util.asn1.ASN1Oid;
import org.faceless.util.asn1.ASN1Sequence;
import org.faceless.util.asn1.ASN1Set;
import org.faceless.util.asn1.ASN1String;
import org.faceless.util.asn1.ASN1TaggedObject;
import org.faceless.util.asn1.AttributeSet;

public class SignerInfo
extends ASN1Sequence {
    private static final long serialVersionUID = -6569962261387863425L;

    static SignerInfo a(ASN1Object aSN1Object) {
        SignerInfo signerInfo = aSN1Object instanceof SignerInfo ? (SignerInfo)aSN1Object : new SignerInfo(aSN1Object);
        return signerInfo;
    }

    private SignerInfo(ASN1Object aSN1Object) {
        super(((ASN1Sequence)aSN1Object).values);
    }

    public SignerInfo(X500Principal x500Principal, BigInteger bigInteger, ASN1Oid aSN1Oid, AttributeSet attributeSet, ASN1Oid aSN1Oid2, byte[] byArray, AttributeSet attributeSet2) {
        int n2 = 1;
        this.add(new ASN1Integer(n2));
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(x500Principal.getEncoded());
            aSN1Sequence.add(aSN1InputStream.readObject());
            aSN1InputStream.close();
            aSN1Sequence.add(new ASN1Integer(bigInteger));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.add(aSN1Sequence);
        this.add(new ASN1Sequence(aSN1Oid, NULL));
        if (attributeSet != null) {
            this.add(new ASN1TaggedObject(0, false, attributeSet));
        }
        this.add(new ASN1Sequence(aSN1Oid2, NULL));
        this.add(new ASN1String(byArray));
        if (attributeSet2 != null) {
            this.add(new ASN1TaggedObject(1, false, attributeSet2));
        }
    }

    public int getVersion() {
        return ((ASN1Integer)this.get(0)).intValue();
    }

    public X500Principal getIssuer() {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)this.get(1);
        return new X500Principal(aSN1Sequence.get(0).getEncoded());
    }

    public BigInteger getSerialNumber() {
        ASN1Sequence aSN1Sequence = (ASN1Sequence)this.get(1);
        return ((ASN1Integer)aSN1Sequence.get(1)).get();
    }

    public ASN1Oid getDigestAlgorithm() {
        return (ASN1Oid)((ASN1Sequence)this.get(2)).get(0);
    }

    public ASN1Oid getDigestEncryptionAlgorithm() {
        ASN1Object aSN1Object = this.get(3);
        if (aSN1Object instanceof ASN1TaggedObject) {
            aSN1Object = this.get(4);
        }
        return (ASN1Oid)((ASN1Sequence)aSN1Object).get(0);
    }

    public byte[] getEncryptedDigest() {
        ASN1Object aSN1Object = this.get(4);
        if (!(aSN1Object instanceof ASN1String)) {
            aSN1Object = this.get(5);
        }
        return ((ASN1String)aSN1Object).getBytes();
    }

    public AttributeSet getAuthenticatedAttributes() {
        ASN1Set aSN1Set = this.getTaggedObject(0).getImplicitSet();
        AttributeSet attributeSet = aSN1Set == null ? null : AttributeSet.a(aSN1Set);
        return attributeSet;
    }

    public AttributeSet getUnauthenticatedAttributes() {
        ASN1Set aSN1Set = this.getTaggedObject(1).getImplicitSet();
        AttributeSet attributeSet = aSN1Set == null ? null : AttributeSet.a(aSN1Set);
        return attributeSet;
    }

    public String toString() {
        return "{signerInfo: version=" + this.getVersion() + " is={" + this.getIssuer() + "} sn=" + this.getSerialNumber() + " da=" + this.getDigestAlgorithm() + " dea=" + this.getDigestEncryptionAlgorithm() + " dig=" + this.getEncryptedDigest().length + " a=" + this.getAuthenticatedAttributes() + " ua=" + this.getUnauthenticatedAttributes() + "}";
    }

    public MessageDigest getMessageDigest(Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            return MessageDigest.getInstance(SignerInfo.a(this.getDigestAlgorithm()));
        }
        return MessageDigest.getInstance(SignerInfo.a(this.getDigestAlgorithm()), provider);
    }

    public Signature getSignature(Provider provider) throws NoSuchAlgorithmException {
        String string = SignerInfo.a(this.getDigestAlgorithm(), this.getDigestEncryptionAlgorithm());
        if (provider == null) {
            return Signature.getInstance(string);
        }
        return Signature.getInstance(string, provider);
    }

    private static String a(ASN1Oid aSN1Oid, ASN1Oid aSN1Oid2) {
        String string;
        String string2 = SignerInfo.a(aSN1Oid);
        if (aSN1Oid2.equals(ASN1Oid.RSAENCRYPTION)) {
            string = "RSA";
        } else if (aSN1Oid2.equals(ASN1Oid.SHA1WITHRSAENCRYPTION)) {
            string = "RSA";
        } else if (aSN1Oid2.equals(ASN1Oid.ID_DSA)) {
            string = "DSA";
        } else {
            throw new IllegalArgumentException("Unknown encryption algorithm \"" + aSN1Oid2 + "\"");
        }
        if ("SHA-256".equals(string2)) {
            string2 = "SHA256";
        } else if ("SHA-384".equals(string2)) {
            string2 = "SHA384";
        } else if ("SHA-512".equals(string2)) {
            string2 = "SHA512";
        }
        return string2 + "with" + string;
    }

    private static String a(ASN1Oid aSN1Oid) {
        if (aSN1Oid.equals(ASN1Oid.MD5)) {
            return "MD5";
        }
        if (aSN1Oid.equals(ASN1Oid.MD2)) {
            return "MD2";
        }
        if (aSN1Oid.equals(ASN1Oid.ID_SHA1)) {
            return "SHA1";
        }
        if (aSN1Oid.equals(ASN1Oid.ID_SHA256)) {
            return "SHA-256";
        }
        if (aSN1Oid.equals(ASN1Oid.RIPEMD160)) {
            return "RIPEMD160";
        }
        if (aSN1Oid.equals(ASN1Oid.ID_SHA384)) {
            return "SHA-384";
        }
        if (aSN1Oid.equals(ASN1Oid.ID_SHA512)) {
            return "SHA-512";
        }
        throw new IllegalArgumentException("Unknown digest algorithm \"" + aSN1Oid + "\"");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verify(X509Certificate x509Certificate, byte[] byArray, Provider provider) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        Signature signature = this.getSignature(provider);
        if (!x509Certificate.getIssuerX500Principal().equals(this.getIssuer())) throw new CertificateException("Certificate does not match SignerInfo");
        if (!x509Certificate.getSerialNumber().equals(this.getSerialNumber())) {
            throw new CertificateException("Certificate does not match SignerInfo");
        }
        signature.initVerify(x509Certificate.getPublicKey());
        AttributeSet attributeSet = this.getAuthenticatedAttributes();
        if (attributeSet != null) {
            signature.update(attributeSet.getEncoded());
            return signature.verify(this.getEncryptedDigest());
        }
        signature.update(byArray);
        return signature.verify(this.getEncryptedDigest());
    }
}

