/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.asn1;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.faceless.util.asn1.ASN1Boolean;
import org.faceless.util.asn1.ASN1Integer;
import org.faceless.util.asn1.ASN1Oid;
import org.faceless.util.asn1.ASN1Sequence;
import org.faceless.util.asn1.ASN1Set;
import org.faceless.util.asn1.ASN1String;
import org.faceless.util.asn1.ASN1TaggedObject;

public class TimeStampRequest
extends ASN1Sequence {
    private static final long serialVersionUID = 8364219285511636190L;

    public TimeStampRequest(ASN1Oid aSN1Oid, byte[] byArray) {
        this(aSN1Oid, byArray, null, new BigInteger(64, new SecureRandom()), true, null);
    }

    public TimeStampRequest(ASN1Oid aSN1Oid, byte[] byArray, ASN1Oid aSN1Oid2, BigInteger bigInteger, boolean bl, ASN1Set aSN1Set) {
        this.add(new ASN1Integer(1L));
        this.add(new ASN1Sequence(new ASN1Sequence(aSN1Oid, NULL), new ASN1String(byArray)));
        if (aSN1Oid2 != null) {
            this.add(aSN1Oid2);
        }
        if (bigInteger != null) {
            this.add(new ASN1Integer(bigInteger));
        }
        if (bl) {
            this.add(ASN1Boolean.TRUE);
        }
        if (aSN1Set != null) {
            this.add(new ASN1TaggedObject(0, false, aSN1Set));
        }
    }

    public ASN1Oid getAlgorithm() {
        return (ASN1Oid)this.getSequence(1).getSequence(0).get(0);
    }

    public byte[] getDigest() {
        return ((ASN1String)this.getSequence(1).get(1)).getBytes();
    }

    public ASN1Oid getPolicy() {
        for (int i2 = 2; i2 < this.size(); ++i2) {
            if (!(this.get(i2) instanceof ASN1Oid)) continue;
            return (ASN1Oid)this.get(i2);
        }
        return null;
    }

    public BigInteger getNonce() {
        for (int i2 = 2; i2 < this.size(); ++i2) {
            if (!(this.get(i2) instanceof ASN1Integer)) continue;
            return ((ASN1Integer)this.get(i2)).get();
        }
        return null;
    }
}

