/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.jpedaljbig2.decoders;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.faceless.util.jpedaljbig2.JBIG2Exception;
import org.faceless.util.jpedaljbig2.decoders.ArithmeticDecoder;
import org.faceless.util.jpedaljbig2.decoders.HuffmanDecoder;
import org.faceless.util.jpedaljbig2.decoders.MMRDecoder;
import org.faceless.util.jpedaljbig2.image.JBIG2Bitmap;
import org.faceless.util.jpedaljbig2.io.StreamReader;
import org.faceless.util.jpedaljbig2.segment.Segment;
import org.faceless.util.jpedaljbig2.segment.SegmentHeader;
import org.faceless.util.jpedaljbig2.segment.extensions.ExtensionSegment;
import org.faceless.util.jpedaljbig2.segment.pageinformation.PageInformationSegment;
import org.faceless.util.jpedaljbig2.segment.pattern.PatternDictionarySegment;
import org.faceless.util.jpedaljbig2.segment.region.generic.GenericRegionSegment;
import org.faceless.util.jpedaljbig2.segment.region.halftone.HalftoneRegionSegment;
import org.faceless.util.jpedaljbig2.segment.region.refinement.RefinementRegionSegment;
import org.faceless.util.jpedaljbig2.segment.region.text.TextRegionSegment;
import org.faceless.util.jpedaljbig2.segment.stripes.EndOfStripeSegment;
import org.faceless.util.jpedaljbig2.segment.symboldictionary.SymbolDictionarySegment;
import org.faceless.util.jpedaljbig2.util.BinaryOperation;

public class JBIG2StreamDecoder {
    private StreamReader a;
    private boolean b;
    private boolean c;
    private int d = -1;
    private List e = new ArrayList();
    private List f = new ArrayList();
    private byte[] g;
    private ArithmeticDecoder h;
    private HuffmanDecoder i;
    private MMRDecoder j;
    public static boolean debug = false;

    public void movePointer(int n2) {
        this.a.movePointer(n2);
    }

    public void setGlobalData(byte[] byArray) {
        this.g = byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decodeJBIG2(byte[] byArray) throws IOException, JBIG2Exception {
        this.a = new StreamReader(byArray);
        this.a();
        boolean bl = this.e();
        if (debug) {
            System.out.println("validFile = " + bl);
        }
        if (!bl) {
            this.b = true;
            this.c = false;
            this.d = 1;
            if (this.g != null) {
                this.a = new StreamReader(this.g);
                this.i = new HuffmanDecoder(this.a);
                this.j = new MMRDecoder(this.a);
                this.h = new ArithmeticDecoder(this.a);
                this.b();
                this.a = new StreamReader(byArray);
            } else {
                this.a.movePointer(-8);
            }
        } else {
            if (debug) {
                System.out.println("==== File Header ====");
            }
            this.d();
            if (debug) {
                System.out.println("randomAccessOrganisation = " + this.c);
                System.out.println("noOfPagesKnown = " + this.b);
            }
            if (this.b) {
                this.d = this.c();
                if (debug) {
                    System.out.println("noOfPages = " + this.d);
                }
            }
        }
        this.i = new HuffmanDecoder(this.a);
        this.j = new MMRDecoder(this.a);
        this.h = new ArithmeticDecoder(this.a);
        this.b();
    }

    public HuffmanDecoder getHuffmanDecoder() {
        return this.i;
    }

    public MMRDecoder getMMRDecoder() {
        return this.j;
    }

    public ArithmeticDecoder getArithmeticDecoder() {
        return this.h;
    }

    private void a() {
        this.b = false;
        this.c = false;
        this.d = -1;
        this.e.clear();
        this.f.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void b() throws IOException, JBIG2Exception {
        Segment segment;
        Object object;
        if (debug) {
            System.out.println("==== Segments ====");
        }
        boolean bl = false;
        block48: while (!this.a.isFinished() && !bl) {
            object = new SegmentHeader();
            if (debug) {
                System.out.println("==== Segment Header ====");
            }
            this.a((SegmentHeader)object);
            segment = null;
            int n2 = ((SegmentHeader)object).getSegmentType();
            int[] nArray = ((SegmentHeader)object).getReferredToSegments();
            int n3 = ((SegmentHeader)object).getReferredToSegmentCount();
            switch (n2) {
                case 0: {
                    if (debug) {
                        System.out.println("==== Segment Symbol Dictionary ====");
                    }
                    segment = new SymbolDictionarySegment(this);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 4: {
                    if (debug) {
                        System.out.println("==== Intermediate Text Region ====");
                    }
                    segment = new TextRegionSegment(this, false);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 6: {
                    if (debug) {
                        System.out.println("==== Immediate Text Region ====");
                    }
                    segment = new TextRegionSegment(this, true);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 7: {
                    if (debug) {
                        System.out.println("==== Immediate Lossless Text Region ====");
                    }
                    segment = new TextRegionSegment(this, true);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 16: {
                    if (debug) {
                        System.out.println("==== Pattern Dictionary ====");
                    }
                    segment = new PatternDictionarySegment(this);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 20: {
                    if (debug) {
                        System.out.println("==== Intermediate Halftone Region ====");
                    }
                    segment = new HalftoneRegionSegment(this, false);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 22: {
                    if (debug) {
                        System.out.println("==== Immediate Halftone Region ====");
                    }
                    segment = new HalftoneRegionSegment(this, true);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 23: {
                    if (debug) {
                        System.out.println("==== Immediate Lossless Halftone Region ====");
                    }
                    segment = new HalftoneRegionSegment(this, true);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 36: {
                    if (debug) {
                        System.out.println("==== Intermediate Generic Region ====");
                    }
                    segment = new GenericRegionSegment(this, false);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 38: {
                    if (debug) {
                        System.out.println("==== Immediate Generic Region ====");
                    }
                    segment = new GenericRegionSegment(this, true);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 39: {
                    if (debug) {
                        System.out.println("==== Immediate Lossless Generic Region ====");
                    }
                    segment = new GenericRegionSegment(this, true);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 40: {
                    if (debug) {
                        System.out.println("==== Intermediate Generic Refinement Region ====");
                    }
                    segment = new RefinementRegionSegment(this, false, nArray, n3);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 42: {
                    if (debug) {
                        System.out.println("==== Immediate Generic Refinement Region ====");
                    }
                    segment = new RefinementRegionSegment(this, true, nArray, n3);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 43: {
                    if (debug) {
                        System.out.println("==== Immediate lossless Generic Refinement Region ====");
                    }
                    segment = new RefinementRegionSegment(this, true, nArray, n3);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 48: {
                    if (debug) {
                        System.out.println("==== Page Information Dictionary ====");
                    }
                    segment = new PageInformationSegment(this);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 49: {
                    continue block48;
                }
                case 50: {
                    if (debug) {
                        System.out.println("==== End of Stripes ====");
                    }
                    segment = new EndOfStripeSegment(this);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                case 51: {
                    if (debug) {
                        System.out.println("==== End of File ====");
                    }
                    bl = true;
                    continue block48;
                }
                case 52: {
                    if (!debug) break;
                    System.out.println("PROFILES UNIMPLEMENTED");
                    break;
                }
                case 53: {
                    if (!debug) break;
                    System.out.println("TABLES UNIMPLEMENTED");
                    break;
                }
                case 62: {
                    if (debug) {
                        System.out.println("==== Extensions ====");
                    }
                    segment = new ExtensionSegment(this);
                    segment.setSegmentHeader((SegmentHeader)object);
                    break;
                }
                default: {
                    System.out.println("Unknown Segment type in JBIG2 stream");
                }
            }
            if (!this.c) {
                segment.readSegment();
            }
            this.e.add(segment);
        }
        if (this.c) {
            object = this.e.iterator();
            while (object.hasNext()) {
                segment = (Segment)object.next();
                segment.readSegment();
            }
        }
    }

    public PageInformationSegment findPageSegement(int n2) {
        Iterator iterator = this.e.iterator();
        while (iterator.hasNext()) {
            Segment segment = (Segment)iterator.next();
            SegmentHeader segmentHeader = segment.getSegmentHeader();
            if (segmentHeader.getSegmentType() != 48 || segmentHeader.getPageAssociation() != n2) continue;
            return (PageInformationSegment)segment;
        }
        return null;
    }

    public Segment findSegment(int n2) {
        Iterator iterator = this.e.iterator();
        while (iterator.hasNext()) {
            Segment segment = (Segment)iterator.next();
            if (segment.getSegmentHeader().getSegmentNumber() != n2) continue;
            return segment;
        }
        return null;
    }

    private void a(SegmentHeader segmentHeader) throws IOException, JBIG2Exception {
        this.c(segmentHeader);
        this.d(segmentHeader);
        this.e(segmentHeader);
        this.f(segmentHeader);
        this.b(segmentHeader);
        if (segmentHeader.getSegmentType() != 51) {
            this.g(segmentHeader);
        }
    }

    private void b(SegmentHeader segmentHeader) throws IOException {
        int n2;
        boolean bl = segmentHeader.isPageAssociationSizeSet();
        if (bl) {
            short[] sArray = new short[4];
            this.a.readByte(sArray);
            n2 = BinaryOperation.getInt32(sArray);
        } else {
            n2 = this.a.readByte();
        }
        segmentHeader.setPageAssociation(n2);
        if (debug) {
            System.out.println("pageAssociation = " + n2);
        }
    }

    private void c(SegmentHeader segmentHeader) throws IOException {
        short[] sArray = new short[4];
        this.a.readByte(sArray);
        int n2 = BinaryOperation.getInt32(sArray);
        if (debug) {
            System.out.println("SegmentNumber = " + n2);
        }
        segmentHeader.setSegmentNumber(n2);
    }

    private void d(SegmentHeader segmentHeader) throws IOException {
        short s2 = this.a.readByte();
        segmentHeader.setSegmentHeaderFlags(s2);
    }

    private void e(SegmentHeader segmentHeader) throws IOException, JBIG2Exception {
        short s2 = this.a.readByte();
        int n2 = (s2 & 0xE0) >> 5;
        short[] sArray = null;
        short s3 = (short)(s2 & 0x1F);
        if (n2 <= 4) {
            sArray = new short[]{s3};
        } else if (n2 == 7) {
            int n3;
            short[] sArray2 = new short[4];
            sArray2[0] = s3;
            for (n3 = 1; n3 < 4; ++n3) {
                sArray2[n3] = this.a.readByte();
            }
            n2 = BinaryOperation.getInt32(sArray2);
            n3 = (int)Math.ceil(4.0 + (double)(n2 + 1) / 8.0);
            int n4 = n3 - 4;
            sArray = new short[n4];
            this.a.readByte(sArray);
        } else {
            throw new JBIG2Exception("Error, 3 bit Segment count field = " + n2);
        }
        segmentHeader.setReferredToSegmentCount(n2);
        if (debug) {
            System.out.println("referredToSegmentCount = " + n2);
        }
        segmentHeader.setRententionFlags(sArray);
        if (debug) {
            System.out.print("retentionFlags = ");
        }
        if (debug) {
            for (int i2 = 0; i2 < sArray.length; ++i2) {
                System.out.print(sArray[i2] + " ");
            }
            System.out.println("");
        }
    }

    private void f(SegmentHeader segmentHeader) throws IOException {
        int n2;
        int n3 = segmentHeader.getReferredToSegmentCount();
        int[] nArray = new int[n3];
        int n4 = segmentHeader.getSegmentNumber();
        if (n4 <= 256) {
            for (int i2 = 0; i2 < n3; ++i2) {
                nArray[i2] = this.a.readByte();
            }
        }
        if (n4 <= 65536) {
            short[] sArray = new short[2];
            for (n2 = 0; n2 < n3; ++n2) {
                this.a.readByte(sArray);
                nArray[n2] = BinaryOperation.getInt16(sArray);
            }
        }
        short[] sArray = new short[4];
        for (n2 = 0; n2 < n3; ++n2) {
            this.a.readByte(sArray);
            nArray[n2] = BinaryOperation.getInt32(sArray);
        }
        segmentHeader.setReferredToSegments(nArray);
        if (debug) {
            System.out.print("referredToSegments = ");
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                System.out.print(nArray[i3] + " ");
            }
            System.out.println("");
        }
    }

    private int c() throws IOException {
        short[] sArray = new short[4];
        this.a.readByte(sArray);
        return BinaryOperation.getInt32(sArray);
    }

    private void g(SegmentHeader segmentHeader) throws IOException {
        short[] sArray = new short[4];
        this.a.readByte(sArray);
        int n2 = BinaryOperation.getInt32(sArray);
        segmentHeader.setDataLength(n2);
        if (debug) {
            System.out.println("dateLength = " + n2);
        }
    }

    private void d() throws IOException {
        short s2 = this.a.readByte();
        if ((s2 & 0xFC) != 0) {
            System.out.println("Warning, reserved bits (2-7) of file header flags are not zero " + s2);
        }
        int n2 = s2 & 1;
        boolean bl = n2 == 0;
        this.c = bl;
        int n3 = s2 & 2;
        boolean bl2 = n3 == 0;
        this.b = bl2;
    }

    private boolean e() throws IOException {
        short[] sArray = new short[]{151, 74, 66, 50, 13, 10, 26, 10};
        short[] sArray2 = new short[8];
        this.a.readByte(sArray2);
        return Arrays.equals(sArray, sArray2);
    }

    public int readBits(int n2) throws IOException {
        return this.a.readBits(n2);
    }

    public int readBit() throws IOException {
        return this.a.readBit();
    }

    public void readByte(short[] sArray) throws IOException {
        this.a.readByte(sArray);
    }

    public void consumeRemainingBits() throws IOException {
        this.a.consumeRemainingBits();
    }

    public short readByte() throws IOException {
        return this.a.readByte();
    }

    public void appendBitmap(JBIG2Bitmap jBIG2Bitmap) {
        this.f.add(jBIG2Bitmap);
    }

    public JBIG2Bitmap findBitmap(int n2) {
        Iterator iterator = this.f.iterator();
        while (iterator.hasNext()) {
            JBIG2Bitmap jBIG2Bitmap = (JBIG2Bitmap)iterator.next();
            if (jBIG2Bitmap.getBitmapNumber() != n2) continue;
            return jBIG2Bitmap;
        }
        return null;
    }

    public JBIG2Bitmap getPageAsJBIG2Bitmap(int n2) {
        JBIG2Bitmap jBIG2Bitmap = this.findPageSegement(1).getPageBitmap();
        return jBIG2Bitmap;
    }

    public boolean isNumberOfPagesKnown() {
        return this.b;
    }

    public int getNumberOfPages() {
        return this.d;
    }

    public boolean isRandomAccessOrganisationUsed() {
        return this.c;
    }

    public List getAllSegments() {
        return this.e;
    }
}

