/*
 * Decompiled with CFR 0.152.
 */
package org.faceless.util.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.faceless.retrotranslator.net.sf.retrotranslator.runtime.java.lang.ThreadLocal_;

public class PatternFormatter
extends Formatter {
    private static final String[] a = new String[]{"FINEST", "FINER", "FINE", "CONFIG", "INFO", "WARNING", "SEVERE"};
    private Map b;
    private Map c;
    private String d = "%d %p: %m %x";
    private final long e = System.currentTimeMillis();

    public PatternFormatter() {
        LogManager logManager = LogManager.getLogManager();
        this.d = "%d %p: %m %x";
        this.c = Collections.synchronizedMap(new HashMap());
        String string = logManager.getProperty(this.getClass().getName() + ".format");
        if (string != null && string.trim().length() > 0) {
            this.setFormat(null, string);
        }
        for (int i2 = 0; i2 < a.length; ++i2) {
            string = logManager.getProperty(this.getClass().getName() + "." + a[i2] + ".format");
            if (string == null || string.trim().length() <= 0) continue;
            this.setFormat(a[i2], string);
        }
    }

    public PatternFormatter(String string) {
        this();
        this.setFormat(null, string);
    }

    public synchronized void setFormat(String string, String string2) {
        if (string == null) {
            this.d = string2;
        } else {
            if (this.b == null) {
                this.b = new HashMap();
            }
            this.b.put(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String format(LogRecord logRecord) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        PatternFormatter patternFormatter = this;
        // MONITORENTER : patternFormatter
        if (this.b != null) {
            string = (String)this.b.get(logRecord.getLevel().getName());
        }
        // MONITOREXIT : patternFormatter
        if (string == null) {
            string = this.d;
        }
        int n2 = 0;
        block48: while (true) {
            char c2;
            if (n2 >= string.length()) {
                printWriter.close();
                return stringWriter.toString().trim() + "\n";
            }
            if ((c2 = string.charAt(n2++)) == '\\' && n2 < this.d.length() - 1) {
                c2 = string.charAt(n2++);
                switch (c2) {
                    case 'r': {
                        printWriter.write(13);
                        break;
                    }
                    case 'n': {
                        printWriter.write(10);
                        break;
                    }
                    case 't': {
                        printWriter.write(9);
                        break;
                    }
                    case '\\': {
                        printWriter.write(92);
                        continue block48;
                    }
                }
                continue;
            }
            if (c2 == '%' && n2 < string.length()) {
                int n3;
                c2 = string.charAt(n2++);
                while ((c2 == '-' || c2 == '.' || Character.isDigit(c2)) && n2 < string.length()) {
                    stringBuffer.append(c2);
                    c2 = string.charAt(n2++);
                }
                String string2 = null;
                if (n2 < string.length() && string.charAt(n2) == '{') {
                    int n4 = n2 + 1;
                    for (n3 = n4 + 1; n3 < string.length() && string.charAt(n3) != '}'; ++n3) {
                    }
                    if (n3 != string.length()) {
                        string2 = string.substring(n4, n3);
                        n2 = n3 + 1;
                    }
                }
                switch (c2) {
                    case 'c': {
                        int n5;
                        String string3 = logRecord.getLoggerName();
                        if (string3 != null && string2 != null) {
                            try {
                                n3 = Integer.parseInt(string2);
                                int n6 = string3.length();
                                for (n5 = 0; n5 < n3 && n6 >= 0; ++n5) {
                                    n6 = string3.lastIndexOf(".", n6 - 1);
                                }
                                if (n6 != -1) {
                                    string3 = string3.substring(n6 + 1);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        printWriter.print(string3);
                        break;
                    }
                    case 'd': {
                        ThreadLocal_ threadLocal_;
                        if (string2 == null) {
                            string2 = "dd-MMM-yyyy HH:mm:ss";
                        }
                        if ((threadLocal_ = (ThreadLocal_)this.c.get(string2)) == null) {
                            final String string4 = string2;
                            threadLocal_ = new ThreadLocal_(){

                                protected synchronized Object initialValue() {
                                    return new SimpleDateFormat(string4);
                                }
                            };
                            this.c.put(string2, threadLocal_);
                        }
                        DateFormat dateFormat = (DateFormat)threadLocal_.get();
                        printWriter.print(dateFormat.format(new Date(logRecord.getMillis())));
                        break;
                    }
                    case 'C': {
                        int n5;
                        String string5 = logRecord.getSourceClassName();
                        if (string5 == null) break;
                        if (string2 != null) {
                            try {
                                n5 = Integer.parseInt(string2);
                                int n7 = string5.length();
                                for (int i2 = 0; i2 < n5 && n7 >= 0; ++i2) {
                                    n7 = string5.lastIndexOf(".", n7 - 1);
                                }
                                if (n7 != -1) {
                                    string5 = string5.substring(n7 + 1);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        printWriter.print(string5);
                        break;
                    }
                    case 'M': {
                        if (logRecord.getSourceMethodName() == null) break;
                        printWriter.print(logRecord.getSourceMethodName());
                        break;
                    }
                    case 'm': {
                        printWriter.print(this.formatMessage(logRecord));
                        break;
                    }
                    case 'n': {
                        printWriter.print("\n");
                        break;
                    }
                    case 'p': {
                        printWriter.print(logRecord.getLevel().getName());
                        break;
                    }
                    case 'r': {
                        printWriter.print(System.currentTimeMillis() - this.e);
                        break;
                    }
                    case 't': {
                        printWriter.print(logRecord.getThreadID());
                        break;
                    }
                    case 'x': {
                        if (logRecord.getThrown() == null) break;
                        if ("notrace".equals(string2)) {
                            printWriter.print(logRecord.getThrown());
                            break;
                        }
                        logRecord.getThrown().printStackTrace(printWriter);
                        break;
                    }
                    case '%': {
                        printWriter.print("%");
                        break;
                    }
                    case 'i': {
                        printWriter.print(logRecord.getSequenceNumber());
                        break;
                    }
                    case 'P': {
                        Object[] objectArray = logRecord.getParameters();
                        try {
                            if (string2 != null) {
                                int n8 = Integer.parseInt(string2);
                                if (objectArray == null || objectArray.length <= n8) break;
                                printWriter.print(objectArray[n8]);
                                break;
                            }
                            if (objectArray == null) {
                                printWriter.print((String)null);
                                break;
                            }
                            printWriter.print(Arrays.asList(objectArray));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        break;
                    }
                }
                stringBuffer.setLength(0);
                continue;
            }
            printWriter.write(c2);
        }
    }
}

