// $Id: SampleTransformer.java 10482 2009-07-10 09:53:38Z chris $

import org.faceless.report.*;
import org.faceless.pdf2.*;
import org.xml.sax.*;
import org.xml.sax.helpers.*;
import java.io.*;
import java.util.*;

// This very simple example shows how you could use the Report Generator as
// the last step in a sequence of transformations.
//
// Here we use a simple XMLFilter to dynamically rename tags - the example
// below changes every <html> to a <pdf>. More complex transformations could
// use XSLT to do this - users of Apache Xalan can look at the
// "UserXMLFilters" example supplied with that package to see how.
//
// To use this example, take any of the samples from the "samples" directory,
// change the <pdf> tags to <html>, and then call this program with the
// modified file as an argument, e.g "java SampleTransformer HelloWorld.xml".
// The output will be sent to "transformed.pdf".
//
// Don't forget to set the "readerclass" variable to the name of your
// XMLReader implementation
//
//
public class SampleTransformer
{
    static final String readerclass = "org.apache.crimson.parser.XMLReaderImpl";
//  static final String readerclass = "org.apache.xerces.parsers.SAXParser";

    public static void main(String[] args) throws SAXException, IOException
    {
	// Create a new reader and it's filter, and set the filter to
	// remap the <html> tag to <pdf>
	//
	XMLReader reader = XMLReaderFactory.createXMLReader(readerclass);
	TagRemapFilter filter = new TagRemapFilter(reader);
	filter.setRemap("html", "pdf");

	// Transform and parse the InputSource
	//
	ReportParser parser = ReportParser.getInstance();
	PDF pdf = parser.parse(filter, new InputSource(args[0]));

	// Write the completed PDF to a file
	//
	pdf.render(new FileOutputStream("transformed.pdf"));
    }


    /**
     * A simple XML Filter which allows tags to be remapped on-the-fly
     * Note although this is fairly functional as it is, it's just an
     * example - it hasn't been tested on all SAX parsers and doesn't
     * handle namespaces.
     */
    public static class TagRemapFilter extends XMLFilterImpl
    {
	private Map remap;

	/**
	 * Create a new TagRemapFilter.
	 * @param parent the XMLReader to use as this filters parent
	 */
	public TagRemapFilter(XMLReader parent)
	{
	    super(parent);
	    remap = new HashMap();
	}

	/**
	 * Set a remapping from one tag to another
	 * @param from the tag to rename
	 * @param to what to rename it to
	 */
	public void setRemap(String from, String to)
	{
	    remap.put(from, to);
	}

        public void startElement(String uri, String local, String qname, Attributes atts)
	    throws SAXException
	{
	    System.err.println(uri+","+local+","+qname);
	    String to;
	    to = (String)remap.get(local); if (to!=null) local=to;
	    to = (String)remap.get(qname); if (to!=null) qname=to;
	    super.startElement(uri, local, qname, atts);
	}

	public void endElement(String uri, String local, String qname)
	    throws SAXException
	{
	    String to;
	    to = (String)remap.get(local); if (to!=null) local=to;
	    to = (String)remap.get(qname); if (to!=null) qname=to;
	    super.endElement(uri, local, qname);
	}
    }
}
