<?xml version="1.0"?>
<%@page language="java" contentType="text/xml;charset=UTF-8"%>
<!DOCTYPE pdf PUBLIC "-//big.faceless.org//report" "report-1.1.dtd">

<!-- 

$Id: bigtable.jsp,v 1.4 2002-10-22 17:02:00 mike Exp $

Here's an example showing some interesting features

1. The "onLoad" attribute of the <pdf> tag. This allows an
   action to be performed when the document is first opened - in
   this case, zooming to the first page

2. Page footers. We use the "footer" attribute of the <body> tag
   to create footers which appear automatically on every page. To
   make things even more interesting, we have different footers
   for left and right pages, by using the pseudo-attribute "left"
   and "right" on the body tag to set the footer to two different
   macros respectively.

3. We use the <pagenumber/> and <totalpages/> tags to display the
   current page number in the footer.

-->

<pdf onLoad="#page1?zoom=fit">

<head>

<style type="text/css">
  body	  		{ footer-height:20; }
  body:left 		{ footer:leftfooter; }
  body:right 		{ footer:rightfooter; }
  .footerclass		{ width:100%; border-top:2; font-size:10pt; font-family:Helvetica}

  table.fancy thead tr			{ background-color:#D0D0D0; font-style:italic; border-top:1; border-bottom:1; }
  table.fancy thead td			{ padding:3; padding-right:1in; }
  table.fancy thead td:first-child	{ border-left:1; }
  table.fancy thead td:last-child	{ border-right:1; }
</style>

<!-- create two macros which are referenced as the "footer" attributes on
     the BODY element. We use a different footer for even and odd numbered
     pages - note the difference in alignment.
 -->
<macrolist>
  <macro id="leftfooter">
    <div class="footerclass">
    <p align="right">- Page <pagenumber/> of <totalpages/> -</p>
    </div>
  </macro>
  <macro id="rightfooter">
    <div class="footerclass">
    <p align="left">- Page <pagenumber/> of <totalpages/> -</p>
    </div>
  </macro>
</macrolist>

</head>

<body>
  <table class="fancy">
    <thead id="thead">
      <tr><td>Name</td><td>Value</td></tr>
    </thead>
    <% for (int i=0, tot=0;i<300;i++) { %>
      <tr><td><%=i%></td><td><%=tot+=i%></td></tr>
    <% } %>
  </table>
</body>

</pdf>
