// $Id: doc.js 15973 2012-07-02 13:05:23Z mike $

// Convert from Java String to JavaScript string (otherwise length is a method, not a property)
function __fixstring(x) {
    return x==null ? "" : ""+x;
}

// Convert from deletePages({nPage: 1, nAfter:2}) to regular arguments
// Usage: if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "nPage", "nAfter");
function __fixcall(/*...*/) {
    var that = arguments[0];
    var func = arguments[1];
    var struct = arguments[2];
    var newargs = []
    for (var i=3;i<arguments.length;i++) {
        newargs[newargs.length] = struct[arguments[i]];
    }
    return func.apply(that, newargs);
}

if (app.__engine=="rhino") {
    var that = this;
    this.info = {};     // No facility to handle general Strings in Rhino.
    this.info.__defineGetter__("Author", function() { return __fixstring(that.__pdf.getInfo("Author")); });
    this.info.__defineGetter__("Title", function() { return __fixstring(that.__pdf.getInfo("Title")); });
    this.info.__defineGetter__("Keywords", function() { return __fixstring(that.__pdf.getInfo("Keywords")); });
    this.info.__defineGetter__("Subject", function() { return __fixstring(that.__pdf.getInfo("Subject")); });
    this.info.__defineGetter__("Creator", function() { return __fixstring(that.__pdf.getInfo("Creator")); });
    this.info.__defineGetter__("Producer", function() { return __fixstring(that.__pdf.getInfo("Producer")); });
    this.info.__defineGetter__("Trapped", function() { return __fixstring(that.__pdf.getInfo("Trapped")); });
    this.info.__defineSetter__("Author", function(x) { that.__pdf.setInfo("Author", x); });
    this.info.__defineSetter__("Title", function(x) { that.__pdf.getInfo("Title", x); });
    this.info.__defineSetter__("Keywords", function(x) { that.__pdf.getInfo("Keywords", x); });
    this.info.__defineSetter__("Subject", function(x) { that.__pdf.getInfo("Subject", x); });
    this.info.__defineSetter__("Creator", function(x) { that.__pdf.getInfo("Creator", x); });
    this.info.__defineSetter__("Trapped", function(x) { that.__pdf.getInfo("Trapped", x); });

    this.__defineGetter__("author", function() { return this.info.Author; });
    this.__defineGetter__("creator", function() { return this.info.Creator; });
    this.__defineGetter__("dirty", function() { return app.__bfo.getDocumentPanel(this.__pdf).isDirty() });
    this.__defineGetter__("keywords", function() { return this.info.Keywords; });
    this.__defineGetter__("layout", function() { return __fixstring(this.__pdf.getOption("pagelayout")); });
    this.__defineGetter__("producer", function() { return this.info.Producer; });
    this.__defineGetter__("subject", function() { return this.info.Subject; });
    this.__defineGetter__("title", function() { return this.info.Title; });

    this.__defineGetter__("mouseX", function() { return app.__bfo.getLastMousePosition(this.__pdf).getX(); });
    this.__defineGetter__("mouseY", function() { return app.__bfo.getLastMousePosition(this.__pdf).getY(); });
    this.__defineGetter__("numPages", function() { return this.__pdf.getNumberOfPages(); });
    this.__defineGetter__("numFields", function() { return this.__pdf.getForm().getElements().size(); });
    this.__defineGetter__("pageNum", function() { return app.__bfo.getDocumentPanel(this.__pdf).getPageNumber(); });
    this.__defineGetter__("zoom", function() { return app.__bfo.getDocumentPanel(this.__pdf).getZoom() * 100.0; });
    
    this.__defineSetter__("author", function(x) { this.info.Author = x; });
    this.__defineSetter__("creator", function(x) { this.info.Creator = x; });
    this.__defineGetter__("dirty", function(x) { app.__bfo.getDocumentPanel(this.__pdf).setDirty(x) });
    this.__defineSetter__("keywords", function(x) { this.info.Keywords = x; });
    this.__defineSetter__("layout", function(x) { this.info.Layout = x; });
    this.__defineSetter__("subject", function(x) { this.info.Subject = x; });
    this.__defineSetter__("title", function(x) { this.info.Title = x; });

    this.__defineSetter__("pageNum", function(x) { app.__bfo.getDocumentPanel(this.__pdf).setPageNumber(x); });
    this.__defineSetter__("zoom", function(x) { app.__bfo.getDocumentPanel(this.__pdf).setZoom(x / 100.0); });
} else if (app.__engine=="mustang") {
    this.info = new JSAdapter() {
        __get__ : function(key) {
            for (var i = this.__pdf.getInfo().entrySet().iterator();i.hasNext();) {
                var k = i.next();
                if (k.getKey().equalsIgnoreCase(key)) return ""+k.getValue();
            }
            return null;
        },
        __put__ : function(key, value) {
            for (var i = this.__pdf.getInfo().keySet().iterator();i.hasNext();) {
                var k = i.next();
                if (k.equalsIgnoreCase(key)) {
                    key = k;
                    break;
                }
            }
            this.__pdf.setInfo(key, value);
        },
        __has__ : function(key) {
            for (var i = this.__pdf.getInfo().keySet().iterator();i.hasNext();) {
                var k = i.next();
                if (k.equalsIgnoreCase(key)) return true;
            }
            return false;
        },
        __delete__ : function(key) {
            for (var i = this.__pdf.getInfo().keySet().iterator();i.hasNext();) {
                var k = i.next();
                if (k.equalsIgnoreCase(key)) {
                    this.__pdf.setInfo(key, null);
                    break;
                }
            }
        },
        __getIds__ : function() {
            var result = [];
            for (var i = this.__pdf.getInfo().keySet().iterator();i.hasNext();) {
                result.push(i.next());
            }
            return result;
        },
    };
    // Owing to Mustang JavaScript being rotten to the core, we can't use a
    // JSAdapter for the Document object. So any properties we would normally
    // control that way are managed in JSMustangParser.DocumentBindings.
}

this.util = app.util;
this.console = app.console;
this.color = app.color;
this.border = { s: "solid", b: "beveled", d: "dashed", i: "inset", u: "underline" };
this.display = { visible: 0, hidden: 1, noPrint: 2, noView: 3 };
this.__fields = new Array();

this.addField = function(cName, cFieldType, nPageNum, oCoords) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "cName", "cFieldType", "nPageNum", "oCoords");
    var field;
    switch(cFieldType) {
      case "text": { field = new Packages.org.faceless.pdf2.FormText(); break; }
      case "button": { field = new Packages.org.faceless.pdf2.FormButton(); break; }
      case "combobox": { field = new Packages.org.faceless.pdf2.FormChoice(Packages.org.faceless.pdf2.FormChoice.TYPE_COMBO); break; }
      case "listbox": { field = new Packages.org.faceless.pdf2.FormChoice(Packages.org.faceless.pdf2.FormChoice.TYPE_SINGLE); break; }
      case "checkbox": { field = new Packages.org.faceless.pdf2.FormCheckbox(); break; }
      case "radiobutton": { field = new Packages.org.faceless.pdf2.FormRadiobutton(); break; }
      case "signature": { field = new Packages.org.faceless.pdf2.FormSignature(); break; }
      default: throw "Illegal field type "+cFieldType;
    }
    field.addAnnotation(this.__pdf.getPage(nPageNum), oCoords[0], oCoords[1], oCoords[2], oCoords[3]);
    this.__pdf.getForm().getElements().put(cName, field);
    return this.getField(cName);
};

this.getNthFieldName = function(nIndex) {
    var j = 0;
    var fieldNames = new Packages.java.util.ArrayList(this.__pdf.getForm().getElements().keySet());
    Packages.java.util.Collections.sort(fieldNames);
    for (var i = fieldNames.iterator();i.hasNext();j++) {
        var s = i.next();
        if (j == nIndex) {
           return __fixstring(s);
        }
    }
    return null;
};

this.toString = function() {
    return "[object Doc]";
}

this.saveAs = function(cPath, cConvID, cFS, bCopy, bOverwrite) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "cPath", "cConvID", "cFS", "bCopy", "bOverwrite");
    var exporter;
    if (cConvID && cConvID.toLowerCase()=="com.adobe.acrobat.tiff") {
        exporter = app.__bfo.getViewer().getFeature("TIFFExporter");
    } else if (cConvID && cConvID.toLowerCase()=="com.adobe.acrobat.plain-text") {
        exporter = app.__bfo.getViewer().getFeature("TextExporter");
    }
    if (exporter == undefined) {
        exporter = app.__bfo.getViewer().getFeature("PDFExporter");
    }
    if (exporter) {
        var save = app.__bfo.getViewer().getFeature("Save");
        if (save) {
            save.save(new Packages.org.faceless.pdf2.viewer2.ViewerEvent(app.__bfo.getViewer(), app.__bfo.getDocumentPanel(this.__pdf)), exporter, cPath, true, bOverwrite ? true : false);
        }
    }
};

this.closeDoc = function() {
    app.__bfo.getViewer().closeDocumentPanel(app.__bfo.getDocumentPanel(this.__pdf));
};

this.getPageBox = function(cBox, nPage) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "cBox", "nPage");
    if (nPage == undefined) nPage = 0;
    var page = this.__pdf.getPage(nPage);
    var box = page.getBox(cBox);
    return [box[0], box[1], box[2], box[3]];
};

this.getPageRotation = function(nPage) {
    if (nPage == undefined) nPage = 0;
    return this.__pdf.getPage(nPage).getPageOrientation();
};

this.gotoNamedDest = function(cName) {
    var action = this.__pdf.getNamedActions().get(cName);
    if (action!=null) app.__bfo.getDocumentPanel(this.__pdf).runAction(action);
}

this.getPrintParams = function() {
    return {
        __type: "printParams",
        constants: {
            bookletBindings: {
                Left: "Left",
                Right: "Right",
                LeftTall: "LeftTall",
                RightTall: "RightTall",
            },
            bookletDuplexMode: {
                BothSides: "BothSides",
                FrontSideOnly: "FrontSideOnly",
                BackSideOnly: "BackSideOnly",
            },
            colorOverrides: {
                auto: "auto",
                gray: "gray",
                mono: "mono",
            },
            fontPolicies: {
                everyPage: "everyPage",
                jobStart: "jobStart",
                pageRange: "pageRange",
            },
            handling: {
                none: "none",
                fit: "fit",
                shrink: "shrink",
                tileAll: "tileAll",
                tileLarge: "tileLarge",
                nUp: "nUp",
                booklet: "booklet",
            },
            interactionLevel: {
                automatic: "automatic",
                full: "full",
                silent: "silent",
            },
            nUpPageOrders: {
                Horizontal: "Horizontal",
                HorizontalReversed: "HorizontalReversed",
                Vertical: "Vertical",
            },
            printContents: {
                doc: "doc",
                docAndComments: "docAndComments",
                formFieldsOnly: "formFieldsOnly",
                noAnnotations: "noAnnotations",         // non-standard, for compat
            },
            flagValues: {
                applyOverPrint: "applyOverPrint",
                applySoftProofSettings: "applySoftProofSettings",
                applyWorkingColorSpaces: "applyWorkingColorSpaces",
                emitHalftones: "emitHalfTones",
                emitPostScriptXObjects: "emitPostScriptXObjects",
                emitFormsAsPSForms: "emitFormsAsPSForms",
                maxJP2KRes: "maxJP2KRes",
                setPageSize: "setPageSize",
                suppressBG: "suppressBG",
                suppressCenter: "suppresCenter",
                suppressCJKFontSubset: "suppressCJKFontSubset",
                suppressCJKFontSubst: "suppressCJKFontSubset",  // From docs, but probably incorrect
                suppressCropClip: "suppressCropClip",
                suppressRotate: "suppressRotate",
                suppressTransfer: "suppressTransfer",
                suppressUCR: "suppressUCR",
                useTrapAnnots: "useTrapAnnots",
                usePrintersMarks: "usePrinterMarks",    // From docs, but probably incorrect
                usePrinterMarks: "usePrinterMarks",
            },
            rasterFlagValues: {
                textToOutline: "textToOutline",
                strokesToOutline: "strokesToOutline",
                allowComplexClip: "allowComplexClip",
                preserveOverprint: "preserveOverprint",
            },
            subsets: {
               all: "all",
               even: "even",
               odd: "odd",
            },
            tileMarks: {
                none: "none",
                west: "west",
                east: "east",
            },
            usages: {
                auto: "auto",
                use: "use",
                noUse: "noUse",
            },
        },
        toString: function() {
            return "[object PrintParams]";
        },
    };
}

// Because stupid, stupid Mustang defines print on every evaluation, we jump entirely unnecessary hoop.
this.__print = function(bUI, nStart, nEnd, bSilent, bShrinkToFit, bPrintAsImage, bReverse, bAnnotations, printParams) {
    if (arguments.length==1) {
        // For some reason, arguments here is 2D array in Mustang. Not sure why but this works
        if (arguments[0][0] && arguments[0][0].__type == "printParams") {
            printParams = arguments[0][0];
        } else if (arguments[0].__type == "printParams") {      // What I'd expect to see, but I'm not
            printParams = arguments[0];
        } else {
            return __fixcall(this, arguments.callee, arguments[0], "bUI", "nStart", "nEnd", "bSilent", "bShrinkToFit", "bPrintAsImage", "bReverse", "bAnnotations", "printParams");
        }
    }

    if (!printParams || printParams.__type != "printParams") { // If printParams not passed in, create it from legacy atts
        printParams = this.getPrintParams();
        if (bUI===false && bSilent===true) {
            printParams.interactive = printParams.constants.interactionLevel.silent;
        } else if (bUI===false) {
            printParams.interactive = printParams.constants.interactionLevel.automatic;
        } else {
            printParams.interactive = printParams.constants.interactionLevel.full;
        }
        if (nStart != null && bUI!==false) {
            printParams.firstPage = nStart;
        }
        if (nEnd != null && bUI!==false) {
            printParams.lastPage = nEnd;
        }
        printParams.printAsImage = bPrintAsImage===true;
        printParams.printContent = bAnnotations===false ? printParams.constants.printContents.doc : printParams.constants.printContents.noAnnotations;
        printParams.reversePages = bReverse===true;
        printParams.pageHandling = bShrinkToFit===true ? printParams.constants.handling.shrink : printParams.constants.handling.none;
    }

    // Convert printParams to PrintRequestAttributeSet
    var map = new Packages.javax.print.attribute.HashPrintRequestAttributeSet();
    if (printParams.colorOverride == printParams.constants.colorOverrides.mono) {
        map.add(javax.print.attribute.standard.Chromaticity.MONOCHROME);
    } else if (printParams.colorOverride == printParams.constants.colorOverrides.gray) {
        map.add(javax.print.attribute.standard.Chromaticity.MONOCHROME);
    }
    if (printParams.firstPage) {
        if (printParams.lastPage) {
            map.add(new Packages.javax.print.attribute.standard.PageRanges(printParams.firstPage+1, printParams.lastPage+1));
        } else {
            map.add(new Packages.javax.print.attribute.standard.PageRanges(printParams.firstPage+1, this.__pdf.getNumberOfPages()));
        }
    } else if (printParams.lastPage) {
        map.add(new Packages.javax.print.attribute.standard.PageRanges(1, printParams.lastPage+1));
    }
    if (printParams.fileName) {
        // Does not work, security exception
        map.add(new Packages.javax.print.attribute.standard.Destination((new Packages.java.io.File(printParams.fileName)).toURI()));
    }
    app.__bfo.getDocumentPanel(this.__pdf).print(null, map);
}

this.print = function() { this.__print(arguments) }

this.removeField = function(cName) {
    var field = this.__pdf.getForm().getElements().get(cName);
    if (field!=null) {
        for (var i=0;i<field.getAnnotations().size();i++) {
            var annot = field.getAnnotation(i);
            var page = annot.getPage();
            annot.setPage(null);
        }
        this.__pdf.getForm().getElements().remove(cName);
    }
}

this.resetForm = function(aFields) {
    var fields = this.__pdf.getForm().getElements();
    for (var i = fields.entrySet().iterator();i.hasNext();) {
        var e = i.next();
        var reset = aFields==null;
        for (var j=0;!reset && j<aFields.length;j++) {
            var name = aFields[j];
            reset = e.getKey()==name || e.getKey().startsWith(name+".");
        }
        if (reset) {
            var field = e.getValue();
            if (field.setValue && field.getDefaultValue) {
                field.setValue(field.getDefaultValue());
            }
        }
    }
}

this.getPageLabel = function(nPage) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "nPage");
    return __fixstring(this.__pdf.getPageLabel(nPage));
}

this.setPageLabels = function(nPage, aLabel) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "nPage", "aLabel");
    if (aLabel && aLabel.length == 3) {
        cStyle = aLabel[0];
        cPrefix = aLabel[1];
        nStart = aLabel[2];
        if (!cStyle.match(/^[DAaRr]$/)) {
            cStyle = 'x';
        }
        this.__pdf.setPageLabel(nPage, nStart, cPrefix, cStyle);
    } else {
        this.__pdf.setPageLabel(nPage, 1, '', 'x');
    }
}

this.scroll = function(nX, nY) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "nX", "nY");
    var page = app.__bfo.getDocumentPanel(this.__pdf).getViewport().getPage();
    app.__bfo.getDocumentPanel(this.__pdf).getViewport().ensureVisible(page, nX, nY);
}

this.movePage = function(nPage, nAfter) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "nPage", "nAfter");
    var pagelist = this.__pdf.getPages();
    if (nPage == undefined) nPage = 0;
    if (nAfter == undefined) nAfter = pagelist.size() - 1;
    pagelist.add(nAfter + 1, pagelist.get(nPage));
};

this.deletePages = function(nStart, nEnd) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "nStart", "nEnd");
    if (nStart == undefined) nStart = 0;
    if (nEnd == undefined) nEnd = nStart;
    this.__pdf.getPages().subList(nStart, nEnd+1).clear();
};

function getField(fieldname) {
    if (this.__fields[fieldname]==null) {
        var pdffield = this.__pdf.getForm().getElement(fieldname);
        var annotnum = -1;
        var result;
        if (pdffield==null && (result=fieldname.match(/\.([0-9]+)$/))) {
            annotnum = result[1];
            var field = fieldname.replace(/\.[0-9]+$/, "");
            pdffield = this.__pdf.getForm().getElement(field);
        }
        if (pdffield!=null) {
           this.__fields[fieldname] = app.__createField(pdffield, fieldname, annotnum, this);
        }
    }
    return this.__fields[fieldname];
}

this.getTemplate = function(templatename) {
    var template = this.__pdf.getPage(templatename);
    if (template!=null) {
        return {
            hidden : template.getPageNumber()==0,           // Technically should be RO
            name : templatename,                            // Technically should be RO
            spawn : function(nPage, bRename, bOverlay, oXObject) {
                var newpage = new Packages.org.faceless.pdf2.PDFPage(template);
                if (bRename) {
                    var annots = newpage.getAnnotations();
                    for (var i=0;i<annots.size();i++) {
                        var annot = annots.get(i);
                        if (annot instanceof Packages.org.faceless.pdf2.WidgetAnnotation) {
                            var oldfield = annot.getField();
                            var form = oldfield.getForm();
                            var oldname = oldfield.getForm().getName(oldfield);
                            var newname = "P"+nPage+"."+templatename+"."+oldname;
                            var newfield = form.getElement(newname);
                            if (newfield==null) {
                                newfield = oldfield.duplicate();
                                form.addElement(newname, newfield);
                            }
                            newfield.getAnnotations().add(annot);
                        }
                    }
                }
                if (bOverlay) {
                    template.getPDF().getPages().set(nPage, newpage);
                } else {
                    template.getPDF().getPages().add(nPage, newpage);
                }
            },
            toString: function() {
                return "[object Template]";
            },
        };
    }
}

this.importAnFDF = function(cPath) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "cPath");
    if (cPath != null) {
        var action = Packages.org.faceless.pdf2.PDFAction.formImportData(cPath);
        app.__bfo.getDocumentPanel(this.__pdf).runAction(action);
    }
}

this.importAnXFDF = function(cPath) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "cPath");
    if (cPath != null) {
        var action = Packages.org.faceless.pdf2.PDFAction.formImportData(cPath);
        app.__bfo.getDocumentPanel(this.__pdf).runAction(action);
    }
}

this.exportAsXFDFStr = function(bAllFields, bNoPassword, aFields, bAnnotations, cHRef) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "bAllFields", "bNoPassword", "aFields", "bAnnotations", "cHRef");
    var fields = new Packages.java.util.ArrayList();
    if (aFields != null) {
        for (var i = 0; i < aFields.length; i++) {
            var f = this.getField(aFields[i]);
            if (f != null) {
                fields.add(f.__element);
            }
        }
    }
    var fdf = new Packages.org.faceless.pdf2.FDF(this.__pdf);
    fdf.setFields(fields);
    fdf.setFile(cHRef);
    var doc = fdf.getXFDF();
    var sink = new Packages.java.io.StringWriter();
    var tr = Packages.javax.xml.transform.TransformerFactory.newInstance().newTransformer();
    tr.transform(new Packages.javax.xml.transform.dom.DOMSource(doc), new Packages.javax.xml.transform.stream.StreamResult(sink));
    var out = __fixstring(sink.toString());
    return out;
}


this.submitForm = function(cURL, bFDF, bEmpty, aFields, bGet, bAnnotations, bXML, bIncrChanges, bPDF, bCanonical, bExclNonUserAnnots, bExclFKey, cPassword, bEmbedForm, oJavaScript, cSubmitAs, bInclNMKey, aPackets, cCharset, oXML, cPermID, cInstID, cUsageRights) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "cURL", "bFDF", "bEmpty", "aFields", "bGet", "bAnnotations", "bXML", "bIncrChanges", "bPDF", "bCanonical", "bExclNonUserAnnots", "bExclFKey", "cPassword", "bEmbedForm", "oJavaScript", "cSubmitAs", "bInclNMKey", "aPackets", "cCharset", "oXML", "cPermID", "cInstID", "cUsageRights");
    if (bPDF===true && !cSubmitAs) cSubmitAs = "PDF";
    if (bXML===true && !cSubmitAs) cSubmitAs = "XML";
    if (bFDF===true && !cSubmitAs) cSubmitAs = "FDF";
    if (cSubmitAs == undefined) cSubmitAs = "FDF";
    if (cSubmitAs == "HTML" && bGet) {
        cSubmitAs = "HTMLGET";
    }

    var handler = app.__bfo.getViewer().getFeature("FormSubmitActionHandler");
    if (handler) {
        var docpanel = app.__bfo.getDocumentPanel(this.__pdf);
        var uri = cURL;
        var annotflags = bAnnotations ? bExclNonUserAnnots ? handler.USERANNOTATIONS : handler.ALLANNOTATIONS : handler.NOANNOTATIONS;
        var flags = 0;
        flags |= bEmpty ? handler.FLAG_EMPTYFIELDS : 0;
        flags |= bIncrChanges ? handler.FLAG_INCREMENTAL : 0;
        flags |= bCanonical ? handler.FLAG_CANONICALDATES : 0;
        flags |= bExclFKey ? 0 : handler.FLAG_FKEY;
        flags |= bEmbedForm ? handler.FLAG_EMBEDFORM : 0;
        flags |= bInclNMKey ? handler.FLAG_NMKEY : 0;
        if (aFields == undefined) {
            aFields = null;
        }
        handler.submit(docpanel, cURL, cSubmitAs, aFields, annotflags, flags);
    }
}

this.setAction = function(cTrigger, cScript) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "cTrigger", "cScript");
    var action = !cScript ? null : Packages.org.faceless.pdf2.PDFAction.formJavaScript(cScript);
    if (cTrigger == "WillClose") {
        this.__pdf.setAction(Packages.org.faceless.pdf2.Event.CLOSE, action);
    } else if (cTrigger == "WillSave") {
        this.__pdf.setAction(Packages.org.faceless.pdf2.Event.PRE_SAVE, action);
    } else if (cTrigger == "DidSave") {
        this.__pdf.setAction(Packages.org.faceless.pdf2.Event.POST_SAVE, action);
    } else if (cTrigger == "WillPrint") {
        this.__pdf.setAction(Packages.org.faceless.pdf2.Event.PRE_PRINT, action);
    } else if (cTrigger == "DidPrint") {
        this.__pdf.setAction(Packages.org.faceless.pdf2.Event.POST_PRINT, action);
    }
}

this.setPageAction = function(nPage, cTrigger, cScript) {
    if (arguments.length==1 && typeof(arguments[0])=="object") return __fixcall(this, arguments.callee, arguments[0], "nPage", "cTrigger", "cScript");
    var action = !cScript ? null : Packages.org.faceless.pdf2.PDFAction.formJavaScript(cScript);
    if (nPage >= 0 && nPage < this.__pdf.getNumberOfPages()) {
        if (cTrigger == "Open") {
            this.__pdf.getPage(nPage).setAction(Packages.org.faceless.pdf2.Event.OPEN, action);
        } else if (cTrigger == "Close") {
            this.__pdf.getPage(nPage).setAction(Packages.org.faceless.pdf2.Event.CLOSE, action);
        }
    }
}


//----------------------------------------------------------------------------------

this.AFDigitsRegExp = new RegExp();
this.AFDigitsRegExp.compile("\\d+");

this.AFSpecial_Format = function(psf) {
    app.__bfo.AFSpecial_Format(event.__javaevent, psf);
}
this.AFNumber_Format = function(nDec, sepStyle, negStyle, currStyle, strCurrency, bCurrencyPrepend) {
    app.__bfo.AFNumber_Format(event.__javaevent, nDec, sepStyle, negStyle, currStyle, strCurrency, bCurrencyPrepend);
}

this.AFPercent_Format = function(nDec, sepStyle) {
    app.__bfo.AFPercent_Format(event.__javaevent, nDec, sepStyle);
}

this.AFDate_FormatEx = function(cFormat) {
    app.__bfo.AFDate_FormatEx(event.__javaevent, cFormat);
}

this.AFDate_Format = function(pdf) {
    app.__bfo.AFDate_Format(event.__javaevent, pdf);
}

this.AFDate_KeystrokeEx = function(cFormat) {
    app.__bfo.AFDate_KeystrokeEx(event.__javaevent, cFormat);
    if (!event.rc) {
        if (event.willCommit) {
            app.alert("Invalid date/time: please ensure that the date/time exists. Field ["+event.targetName+"] should match format "+cFormat);
        } else {
            app.beep();
        }
    }
}

this.AFSpecial_Keystroke = function(psf) {
    app.__bfo.AFSpecial_Keystroke(event.__javaevent, psf);
    if (!event.rc) {
        if (event.willCommit) {
            app.alert("Invalid "+(psf<2?"ZIP code":psf==2?"phone number":"SSN")+" for field ["+event.targetName+"]");
        } else {
            app.beep();
        }
    }
}

this.AFRange_Validate = function(bGreaterThan, nGreaterThan, bLessThan, nLessThan) {
    if (event.value != "") {
        var out = "";
        if (bGreaterThan && bLessThan && (event.value < nGreaterThan || event.value > nLessThan)) {
            out = util.printf("Failed %d <= %s <= %d", nLessThan, event.value, nGreaterThan);
        } else if (bGreaterThan && event.value < nGreaterThan) {
            out = "Failed "+event.value+" <= "+nGreaterThan;
        } else if (bLessThan && event.value > nLessThan) {
            out = "Failed "+event.value+" >= "+nLessThan;
        }
        if (out != "") {
            app.alert(out);
            event.rc = false;
        }
    }
}

this.AFSimple_Calculate = function(cFunction, cFields) {
    var nFields = 0;
    var nValue = cFunction=="PRD" ? 1.0 : 0.0;

    // Field name separator is one or more spaces followed by a comma, 
    // followed by one or more spaces.
    // or an array of field names
    var aFields = AFMakeArrayFromList(cFields);

    for (var i=0;i<aFields.length;i++) {
        var f = this.getField(aFields[i]);
        var a = f.getArray();

        for (var j=0;j<a.length;j++) {
            var nTemp = AFMakeNumber(a[j].value); 
            if (i==0 && j==0 && (cFunction=="MIN" || cFunction=="MAX")) {
                nValue = nTemp;
            }
            if (cFunction=="AVG" || cFunction=="SUM") {
                nValue += nTemp;
            } else if (cFunction=="PRD") {
                nValue *= nTemp;
            } else if (cFunction=="MIN") {
                if (nTemp<nValue) nValue=nTemp;
            } else if (cFunction=="MAX") {
                if (nTemp>nValue) nValue=nTemp;
            }
            nFields++;
        }
    }
    if (cFunction == "AVG" && nFields > 0) {
        nValue /= nFields;
    }

    if (cFunction=="AVG" || cFunction=="SUM" || cFunction=="PRD") {
        nValue = nValue.toFixed(6) * 1.0; 
    }
    event.value = nValue;
}

this.AFMergeChange = function(event) {
    if (event.willCommit) {
        return event.value;
    } else {
        return (event.selStart >= 0 ? event.value.substring(0, event.selStart) : "") + event.change +(event.selEnd >= 0 && event.selEnd <= event.value.length ? event.value.substring(event.selEnd, event.value.length) : "");
    }
}

this.AFNumber_Keystroke = function(nDec, sepStyle, negStyle, currStyle, strCurrency, bCurrencyPrepend) {
    var value = AFMergeChange(event);
    if (value) {
        var re = sepStyle>1 ? /^[+-]?[0-9]*,?[0-9]*$/ : /^[+-]?[0-9]*\.?[0-9]*$/;
        if (!value.match(re)) {
            if (event.willCommit) {
                var cAlert = "Invalid value \""+value+"\"";
                if (event.target != null) {
                    cAlert += " [ " + event.target.name + " ]";
                }
                app.alert(cAlert);
            } else {
                app.beep();
            }
            event.rc = false;
        }
        if (event.willCommit && sepStyle > 1) { // convert from a string to a number 
            event.value = event.value.replace(/,/, ".");
        }
    }
}

this.AFPercent_Keystroke = function(nDec, sepStyle) {
    AFNumber_Keystroke(nDec, sepStyle, 0, 0, "", true);
}

this.AFMakeNumber = function(s) {
    var t = typeof(s);
    if (t == 'number')
        return s;
    if (t != 'string')
        s = String(s);
    var a = AFExtractNums(s);
    if (a) {
        var acc = a.join('.');
        if (s.indexOf('-.') >= 0)
            acc = '0.' + acc;
        return acc * (s.indexOf('-') >= 0 ? -1.0 : 1.0);
    } else
        return null;
}

this.AFExtractNums = function(s) {
    var a = new Array();
    var c0 = s.charAt(0);
    if (c0 == '.' || c0 == ',')
        s = '0' + s;
    while (AFDigitsRegExp.test(s)) {
        a.length++;
        a[a.length - 1] = RegExp.lastMatch;
        s = RegExp.rightContext;
    }
    return (a.length >= 1) ? a : null;
}

this.AFMakeArrayFromList = function(s) {
    var t = typeof(s);
    if (t == "string") {
        var r = new RegExp();
        r.compile(",[ ]?");
        return s.split(r);
    }
    return s;
}

function __destroy() {
    app.__delDoc(this);
}

app.__addDoc(this);
