

Option Strict Off
Option Explicit On


Friend Class frmMain


Inherits System.Windows.Forms.Form
	

Private bLoaded As Boolean
	

Private Sub frmMain_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
	
  On Error Resume Next
	
	' Fill cboBorderStyle
	With cboBorderStyle
		Call .Items.Add("clbNone")
		Call .Items.Add("clbThinRaisedLight")
		Call .Items.Add("clbThinRaisedDark")
		Call .Items.Add("clbThinSunkenLight")
		Call .Items.Add("clbThinSunkenDark")
		Call .Items.Add("clbRaised")
		Call .Items.Add("clbSunken")
		Call .Items.Add("clbEtched")
		Call .Items.Add("clbBump")
		.SelectedIndex = Calendar1.BorderStyle
	End With
	
	' Fill cboHdrCellStyle
	With cboHdrCellStyle
		Call .Items.Add("clcNone")
		Call .Items.Add("clcFlat")
		Call .Items.Add("clcRaised")
		Call .Items.Add("clcSunken")
		.SelectedIndex = Calendar1.HdrCellStyle
	End With
	
	' Fill cboHdrTxtAlign
	With cboHdrTxtAlign
		Call .Items.Add("claTopLeft")
		Call .Items.Add("claTopCenter")
		Call .Items.Add("claTopRight")
		Call .Items.Add("claMiddleLeft")
		Call .Items.Add("claMiddleCenter")
		Call .Items.Add("claMiddleRight")
		Call .Items.Add("claBottomLeft")
		Call .Items.Add("claBottomCenter")
		Call .Items.Add("claBottomRight")
		.SelectedIndex = Calendar1.HdrCellAlign
	End With
	
	' Fill cboHdrCellFormat
	With cboHdrCellFormat
		Call .Items.Add("clfOne")
		Call .Items.Add("clfTwo")
		Call .Items.Add("clfThree")
		Call .Items.Add("clfFull")
		.SelectedIndex = Calendar1.HdrCellFormat
	End With
	
	' Fill cboDayCellStyle
	With cboDayCellStyle
		Call .Items.Add("clcNone")
		Call .Items.Add("clcFlat")
		Call .Items.Add("clcRaised")
		Call .Items.Add("clcSunken")
		.SelectedIndex = Calendar1.DayCellStyle
	End With
	
	' Fill cboDayTxtAlign
	With cboDayTxtAlign
		Call .Items.Add("claTopLeft")
		Call .Items.Add("claTopCenter")
		Call .Items.Add("claTopRight")
		Call .Items.Add("claMiddleLeft")
		Call .Items.Add("claMiddleCenter")
		Call .Items.Add("claMiddleRight")
		Call .Items.Add("claBottomLeft")
		Call .Items.Add("claBottomCenter")
		Call .Items.Add("claBottomRight")
		.SelectedIndex = Calendar1.DayCellAlign
	End With
	
	' Fill cboStartWeek
	With cboStartWeek
		Call .Items.Add("clnSunday")
		Call .Items.Add("clnMonday")
		Call .Items.Add("clnTuesday")
		Call .Items.Add("clnWednesday")
		Call .Items.Add("clnThursday")
		Call .Items.Add("clnFriday")
		Call .Items.Add("clnSaturday")
		.SelectedIndex = (Calendar1.StartOfWeek - 1)
	End With
	
	' Fill cboColorSets
	With cboColorSets
		Call .Items.Add("Default")
		Call .Items.Add("WinXP")
		Call .Items.Add("Blue")
		Call .Items.Add("Green")
		.SelectedIndex = 0
	End With
	
	' Initialize controls
	chkEnabled.CheckState = System.Math.Abs(CInt(Calendar1.CtlEnabled))
	chkDualMode.CheckState = System.Math.Abs(CInt(Calendar1.DualMode))
	chkHeader.CheckState = System.Math.Abs(CInt(Calendar1.HasDaysHeader))
	chkHasPrevMonth.CheckState = System.Math.Abs(CInt(Calendar1.HasPrvMonth))
	chkHasNextMonth.CheckState = System.Math.Abs(CInt(Calendar1.HasNextMonth))
		
	bLoaded = True

End Sub












































' ####################### LOGGING #######################

' Events logging
Private Sub txtEvents_TextChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles txtEvents.TextChanged
	
  On Error Resume Next
	
  Dim iLength As Integer
		
	If Not bLoaded then Exit Sub

	iLength = Len(txtEvents.Text)
	
	' Clear the Textbox if its contents reaches 10000
	' characters to avoid "Out of memory" errors
	If iLength > 10000 Then txtEvents.Text = vbNullString
	
	' Force the txtEvents to show the last added line
	txtEvents.SelectionStart = iLength
	
End Sub

' Clears the logged events and the selected days from the list
Private Sub cmdClear_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdClear.Click
	
	txtEvents.Text = vbNullString
	Call lstSelDates.Items.Clear()
	
End Sub












































' ####################### PROPERTIES #######################

' Sets the border style, of the Calendar
Private Sub cboBorderStyle_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cboBorderStyle.SelectedIndexChanged
		
	If Not bLoaded then Exit Sub

	Calendar1.BorderStyle = cboBorderStyle.SelectedIndex
	
End Sub

' Sets the border style, of the Header cells
Private Sub cboHdrCellStyle_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cboHdrCellStyle.SelectedIndexChanged
		
	If Not bLoaded then Exit Sub

	Calendar1.HdrCellStyle = cboHdrCellStyle.SelectedIndex
	
End Sub

' Sets the alignment of the text, in the Header cells
Private Sub cboHdrTxtAlign_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cboHdrTxtAlign.SelectedIndexChanged
	
	If Not bLoaded then Exit Sub
	
	Calendar1.HdrCellAlign = cboHdrTxtAlign.SelectedIndex
	
End Sub

' Sets the format of the day names, in the Header cells
Private Sub cboHdrCellFormat_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cboHdrCellFormat.SelectedIndexChanged
		
	If Not bLoaded then Exit Sub

	Calendar1.HdrCellFormat = cboHdrCellFormat.SelectedIndex
	
End Sub

' Sets the border style, of the Day cells
Private Sub cboDayCellStyle_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cboDayCellStyle.SelectedIndexChanged
		
	If Not bLoaded then Exit Sub

	Calendar1.DayCellStyle = cboDayCellStyle.SelectedIndex
	
End Sub

' Sets the alignment of the text, in the Day cells
Private Sub cboDayTxtAlign_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cboDayTxtAlign.SelectedIndexChanged
		
	If Not bLoaded then Exit Sub

	Calendar1.DayCellAlign = cboDayTxtAlign.SelectedIndex
	
End Sub

' Sets the first day of the week
Private Sub cboStartWeek_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cboStartWeek.SelectedIndexChanged
		
	If Not bLoaded then Exit Sub

	Calendar1.StartOfWeek = (cboStartWeek.SelectedIndex + 1)
	
End Sub

' Sets the Calendar state
Private Sub chkEnabled_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles chkEnabled.CheckStateChanged
	
	If Not bLoaded then Exit Sub
	
	' Change the Calendar state
	Calendar1.CtlEnabled = (chkEnabled.CheckState And System.Windows.Forms.CheckState.Checked)
	
End Sub

' Toggles the Calendar's Dual mode
Private Sub chkDualMode_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles chkDualMode.CheckStateChanged
	
	If Not bLoaded then Exit Sub
	
	' Change the Dual mode
	Calendar1.DualMode = (chkDualMode.CheckState And System.Windows.Forms.CheckState.Checked)
	
	' Dual
	If chkDualMode.CheckState Then
		Calendar1.HdrCellFormat = ICCalendar.cldHeaderFormats.clfOne
		chkHasPrevMonth.CheckState = System.Windows.Forms.CheckState.Unchecked
		chkHasNextMonth.CheckState = System.Windows.Forms.CheckState.Unchecked
		' Single
		Else
		Calendar1.HdrCellFormat = ICCalendar.cldHeaderFormats.clfThree
		chkHasPrevMonth.CheckState = System.Windows.Forms.CheckState.Checked
		chkHasNextMonth.CheckState = System.Windows.Forms.CheckState.Checked
	End If
	
End Sub

' Toggles the Calendar's week Header
Private Sub chkHeader_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles chkHeader.CheckStateChanged
	
	If Not bLoaded then Exit Sub
	
	' Toggle the Header
	Calendar1.HasDaysHeader = (chkHeader.CheckState And System.Windows.Forms.CheckState.Checked)
	
End Sub

' Toggles the Calendar's previous month days
Private Sub chkHasPrevMonth_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles chkHasPrevMonth.CheckStateChanged
		
	If Not bLoaded then Exit Sub

	' Toggle the previous month
	Calendar1.HasPrvMonth = (chkHasPrevMonth.CheckState And System.Windows.Forms.CheckState.Checked)
	
End Sub

' Toggles the Calendar's next month days
Private Sub chkHasNextMonth_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles chkHasNextMonth.CheckStateChanged
	
	If Not bLoaded then Exit Sub
	
	' Toggle the next month
	Calendar1.HasNextMonth = (chkHasNextMonth.CheckState And System.Windows.Forms.CheckState.Checked)
	
End Sub

' Toggles the Calendar's select style
Private Sub chkMultiSelect_CheckStateChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles chkMultiSelect.CheckStateChanged
	
	If Not bLoaded then Exit Sub
	
	' Toggle the select style
	Calendar1.MultiSelect = (chkMultiSelect.CheckState And System.Windows.Forms.CheckState.Checked)
	
End Sub

' Displays the current period
Private Sub cmdShowToday_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdShowToday.Click
	
	Call Calendar1.ShowToday()
	
End Sub

' Clears all the selected days
Private Sub cmdClearSel_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdClearSel.Click
	
  Dim i As Integer
	
	' Clear selected days
	Call Calendar1.Clear()
	
	' Clear the list
	Call lstSelDates.Items.Clear()
	
	' Show any selected dates in the list
	For i = 1 To Calendar1.SelectedDays.Count
		Call lstSelDates.Items.Add(CStr(Calendar1.SelectedDays(i).SerialDate))
	Next i
	
End Sub

' Sets a color set
Private Sub cboColorSets_SelectedIndexChanged(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cboColorSets.SelectedIndexChanged
	
  On Error Resume Next
		
	If Not bLoaded then Exit Sub

	With Calendar1
		' Hide it
		.Visible = False
		Select Case cboColorSets.SelectedIndex
			' Default
			Case 0
				.CtlBackColor = System.Drawing.SystemColors.Control
				.CtlForeColor = System.Drawing.SystemColors.ControlText
				.ClrCurDateGradA = System.Drawing.SystemColors.ControlDark
				.ClrCurDateGradB = System.Drawing.SystemColors.ControlLightLight
				.ClrCurDateText = System.Drawing.SystemColors.HighlightText
				.ClrCurMonthGradA = System.Drawing.SystemColors.ControlLightLight
				.ClrCurMonthGradB = System.Drawing.SystemColors.Control
				.ClrCurMonthText = System.Drawing.SystemColors.ControlText
				.ClrCurMonthWkGradA = System.Drawing.SystemColors.ControlLightLight
				.ClrCurMonthWkGradB = System.Drawing.SystemColors.ControlDark
				.ClrCurMonthWkText = System.Drawing.SystemColors.ControlText
				.ClrHdrCellGradA = System.Drawing.SystemColors.ControlDark
				.ClrHdrCellGradB = System.Drawing.SystemColors.ControlLightLight
				.ClrHdrCellText = System.Drawing.SystemColors.Highlight
				.ClrNextMonthBack = System.Drawing.SystemColors.ControlLightLight
				.ClrNextMonthText = System.Drawing.SystemColors.ControlDark
				.ClrPrvMonthBack = System.Drawing.SystemColors.ControlLightLight
				.ClrPrvMonthText = System.Drawing.SystemColors.ControlDark
				.ClrSelDayBack = System.Drawing.SystemColors.Highlight
				.ClrSelDayText = System.Drawing.SystemColors.HighlightText
				
			' WinXP
			Case 1
				.CtlBackColor = System.Drawing.ColorTranslator.FromOle(&HDCEEF1)
				.CtlForeColor = System.Drawing.ColorTranslator.FromOle(&H800080)
				.ClrCurDateGradA = System.Drawing.ColorTranslator.FromOle(&H40C0)
				.ClrCurDateGradB = System.Drawing.ColorTranslator.FromOle(&HC0E0FF)
				.ClrCurDateText = System.Drawing.ColorTranslator.FromOle(&HFFFFFF)
				.ClrCurMonthGradA = System.Drawing.ColorTranslator.FromOle(&HFFFFFF)
				.ClrCurMonthGradB = System.Drawing.ColorTranslator.FromOle(&HC0C0C0)
				.ClrCurMonthText = System.Drawing.ColorTranslator.FromOle(&HFF0000)
				.ClrCurMonthWkGradA = System.Drawing.ColorTranslator.FromOle(&HFFFFFF)
				.ClrCurMonthWkGradB = System.Drawing.ColorTranslator.FromOle(&H808080)
				.ClrCurMonthWkText = System.Drawing.ColorTranslator.FromOle(&H8000)
				.ClrHdrCellGradA = System.Drawing.ColorTranslator.FromOle(&H1E3115)
				.ClrHdrCellGradB = System.Drawing.ColorTranslator.FromOle(&HD6DCD3)
				.ClrHdrCellText = System.Drawing.ColorTranslator.FromOle(&H80FFFF)
				.ClrNextMonthBack = System.Drawing.ColorTranslator.FromOle(&HDCEEF1)
				.ClrNextMonthText = System.Drawing.ColorTranslator.FromOle(&H8080)
				.ClrPrvMonthBack = System.Drawing.ColorTranslator.FromOle(&HDCEEF1)
				.ClrPrvMonthText = System.Drawing.ColorTranslator.FromOle(&H8080)
				.ClrSelDayBack = System.Drawing.ColorTranslator.FromOle(&H8000000D)
				.ClrSelDayText = System.Drawing.ColorTranslator.FromOle(&H8000000E)
				
			' Blue
			Case 2
				.CtlBackColor = System.Drawing.SystemColors.Control
				.CtlForeColor = System.Drawing.ColorTranslator.FromOle(&HFF0000)
				.ClrCurDateGradA = System.Drawing.ColorTranslator.FromOle(&H40C0)
				.ClrCurDateGradB = System.Drawing.ColorTranslator.FromOle(&HC0E0FF)
				.ClrCurDateText = System.Drawing.ColorTranslator.FromOle(&H8000000E)
				.ClrCurMonthGradA = System.Drawing.ColorTranslator.FromOle(&HFFFFC0)
				.ClrCurMonthGradB = System.Drawing.ColorTranslator.FromOle(&H400000)
				.ClrCurMonthText = System.Drawing.ColorTranslator.FromOle(&HFFFF)
				.ClrCurMonthWkGradA = System.Drawing.ColorTranslator.FromOle(&HC0C000)
				.ClrCurMonthWkGradB = System.Drawing.ColorTranslator.FromOle(&H400000)
				.ClrCurMonthWkText = System.Drawing.ColorTranslator.FromOle(&HFF00)
				.ClrHdrCellGradA = System.Drawing.ColorTranslator.FromOle(&H400040)
				.ClrHdrCellGradB = System.Drawing.ColorTranslator.FromOle(&HFFC0FF)
				.ClrHdrCellText = System.Drawing.ColorTranslator.FromOle(&HFFFF)
				.ClrNextMonthBack = System.Drawing.ColorTranslator.FromOle(&HDDD3D2)
				.ClrNextMonthText = System.Drawing.ColorTranslator.FromOle(&HFF8080)
				.ClrPrvMonthBack = System.Drawing.ColorTranslator.FromOle(&HDDD3D2)
				.ClrPrvMonthText = System.Drawing.ColorTranslator.FromOle(&HFF8080)
				.ClrSelDayBack = System.Drawing.ColorTranslator.FromOle(&H8000000D)
				.ClrSelDayText = System.Drawing.ColorTranslator.FromOle(&H8000000E)
				
			' Green
			Case 3
				.CtlBackColor = System.Drawing.SystemColors.Control
				.CtlForeColor = System.Drawing.ColorTranslator.FromOle(&HFF)
				.ClrCurDateGradA = System.Drawing.ColorTranslator.FromOle(&H800080)
				.ClrCurDateGradB = System.Drawing.ColorTranslator.FromOle(&HFF00FF)
				.ClrCurDateText = System.Drawing.ColorTranslator.FromOle(&HFFFF)
				.ClrCurMonthGradA = System.Drawing.ColorTranslator.FromOle(&HC0FFC0)
				.ClrCurMonthGradB = System.Drawing.ColorTranslator.FromOle(&H0)
				.ClrCurMonthText = System.Drawing.ColorTranslator.FromOle(&HFFFFC0)
				.ClrCurMonthWkGradA = System.Drawing.ColorTranslator.FromOle(&HC000)
				.ClrCurMonthWkGradB = System.Drawing.ColorTranslator.FromOle(&H0)
				.ClrCurMonthWkText = System.Drawing.ColorTranslator.FromOle(&HFF00)
				.ClrHdrCellGradA = System.Drawing.ColorTranslator.FromOle(&H80)
				.ClrHdrCellGradB = System.Drawing.ColorTranslator.FromOle(&H80C0FF)
				.ClrHdrCellText = System.Drawing.ColorTranslator.FromOle(&HFFFF)
				.ClrNextMonthBack = System.Drawing.ColorTranslator.FromOle(&H95AE9E)
				.ClrNextMonthText = System.Drawing.ColorTranslator.FromOle(&H8000)
				.ClrPrvMonthBack = System.Drawing.ColorTranslator.FromOle(&H95AE9E)
				.ClrPrvMonthText = System.Drawing.ColorTranslator.FromOle(&H8000)
				.ClrSelDayBack = System.Drawing.ColorTranslator.FromOle(&H8000000D)
				.ClrSelDayText = System.Drawing.ColorTranslator.FromOle(&H8000000E)
		End Select
		' Show it again
		.Visible = True
	End With
	
End Sub












































' ###################### EVENTS ######################


Private Sub Calendar1_DayMouseDown(ByVal eventSender As System.Object, ByVal eventArgs As AxICCalendar.__Calendar_DayMouseDownEvent) Handles Calendar1.DayMouseDown
	
  On Error Resume Next
	
	' Log the event
	If chkEvents.CheckState Then
		txtEvents.Text = txtEvents.Text & "MouseDown on " & eventArgs.oDay.SerialDate & "  (" & eventArgs.Button & ", " & eventArgs.Shift & ", " & eventArgs.X & ", " & eventArgs.Y & ")" & vbCrLf
	End If
	
End Sub

Private Sub Calendar1_DayMouseUp(ByVal eventSender As System.Object, ByVal eventArgs As AxICCalendar.__Calendar_DayMouseUpEvent) Handles Calendar1.DayMouseUp
	
  On Error Resume Next
	
  Dim i As Short
	
	' Log the event
	If chkEvents.CheckState Then
		' Clear the list
		lstSelDates.Items.Clear()
		txtEvents.Text = txtEvents.Text & "MouseUp on " & eventArgs.oDay.SerialDate & "  (" & eventArgs.Button & ", " & eventArgs.Shift & ", " & eventArgs.X & ", " & eventArgs.Y & ")" & vbCrLf
		' Show any selected dates in the list
		For i = 1 To Calendar1.SelectedDays.Count
			Call lstSelDates.Items.Add(CStr(Calendar1.SelectedDays(i).SerialDate))
		Next i
	End If
	
End Sub

Private Sub Calendar1_DayDblClick(ByVal eventSender As System.Object, ByVal eventArgs As AxICCalendar.__Calendar_DayDblClickEvent) Handles Calendar1.DayDblClick
	
  On Error Resume Next
	
	' Log the event
	If chkEvents.CheckState Then
		txtEvents.Text = txtEvents.Text & "DayDblClick  (" & eventArgs.oDay.SerialDate & ")" & vbCrLf
	End If
	
End Sub


End Class