/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.lucene;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.lucene.store.FSDirectory;
import org.carrot2.util.simplexml.ISimpleXmlWrapper;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;
import org.slf4j.LoggerFactory;

@Root(name="fsdirectory")
public final class FSDirectoryWrapper
implements ISimpleXmlWrapper<FSDirectory> {
    private FSDirectory value;
    @Element
    private String indexPath;

    public FSDirectory getValue() {
        return this.value;
    }

    public void setValue(FSDirectory fSDirectory) {
        this.value = fSDirectory;
    }

    @Persist
    void beforeSerialization() {
        this.indexPath = this.value.getDirectory().toAbsolutePath().toString();
    }

    @Commit
    void afterDeserialization() {
        try {
            this.value = FSDirectory.open((Path)Paths.get(this.indexPath, new String[0]));
        }
        catch (IOException iOException) {
            LoggerFactory.getLogger(FSDirectoryWrapper.class).warn("Could not deserialize index location.", (Throwable)iOException);
        }
    }
}

