/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.lucene;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.carrot2.core.Document;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IControllerContextListener;
import org.carrot2.core.IDocumentSource;
import org.carrot2.core.ProcessingComponentBase;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.CommonAttributes;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.lucene.FSDirectoryWrapper;
import org.carrot2.source.lucene.IFieldMapper;
import org.carrot2.source.lucene.SimpleFieldMapper;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.AttributeUtils;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.attribute.constraint.NotBlank;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable(prefix="LuceneDocumentSource", inherit={CommonAttributes.class})
public final class LuceneDocumentSource
extends ProcessingComponentBase
implements IDocumentSource {
    protected static final String INDEX_PROPERTIES = "Index properties";
    private static final Logger logger = LoggerFactory.getLogger(LuceneDocumentSource.class);
    @Processing
    @Input
    @Attribute(key="results", inherit=true)
    @IntRange(min=1)
    public int results = 100;
    @Processing
    @Output
    @Attribute(key="results-total", inherit=true)
    public long resultsTotal;
    @Processing
    @Output
    @Attribute(key="documents", inherit=true)
    @Internal
    public Collection<Document> documents;
    @Input
    @Attribute
    @Init
    @Processing
    @Required
    @Internal(configuration=true)
    @ImplementingClasses(classes={RAMDirectory.class, FSDirectory.class}, strict=false)
    @Label(value="Index directory")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Index properties")
    public Directory directory;
    @Input
    @Init
    @Processing
    @Required
    @Attribute
    @Internal(configuration=false)
    @ImplementingClasses(classes={}, strict=false)
    @Label(value="Analyzer")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Index properties")
    public Analyzer analyzer = new StandardAnalyzer();
    @Input
    @Init
    @Processing
    @Required
    @Attribute
    @Internal
    @ImplementingClasses(classes={SimpleFieldMapper.class}, strict=false)
    @Label(value="Field mapper")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Index field mapping")
    public IFieldMapper fieldMapper = new SimpleFieldMapper();
    @Input
    @Processing
    @Attribute(key="query", inherit=false)
    @Required
    @ImplementingClasses(classes={Query.class, String.class}, strict=false)
    @NotBlank
    @Label(value="Query")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Search query")
    public Object query;
    @Input
    @Processing
    @Attribute
    @Internal
    @Label(value="Keep Lucene documents")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Search result information")
    public boolean keepLuceneDocuments = false;
    public static final String LUCENE_DOCUMENT_FIELD = "luceneDocument";
    private IdentityHashMap<Directory, IndexSearcher> openIndexes;
    private IControllerContext context;
    private static final Document.IDocumentSerializationListener removeLuceneDocument;

    static {
        SimpleXmlWrappers.addWrapper(FSDirectory.class, FSDirectoryWrapper.class, (boolean)false);
        removeLuceneDocument = new Document.IDocumentSerializationListener(){

            public void beforeSerialization(Document document, Map<String, ?> map) {
                map.remove(LuceneDocumentSource.LUCENE_DOCUMENT_FIELD);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(IControllerContext iControllerContext) {
        super.init(iControllerContext);
        this.context = iControllerContext;
        IControllerContext iControllerContext2 = iControllerContext;
        synchronized (iControllerContext2) {
            String string = AttributeUtils.getKey(((Object)((Object)this)).getClass(), (String)"openIndexes");
            if (iControllerContext.getAttribute(string) == null) {
                iControllerContext.setAttribute(string, (Object)Maps.newIdentityHashMap());
                iControllerContext.addListener(new IControllerContextListener(){

                    public void beforeDisposal(IControllerContext iControllerContext) {
                        LuceneDocumentSource.this.closeAllIndexes();
                    }
                });
            }
            this.openIndexes = (IdentityHashMap)iControllerContext.getAttribute(string);
        }
    }

    public void process() throws ProcessingException {
        try {
            SearchEngineResponse searchEngineResponse = this.fetchSearchResponse();
            this.documents = searchEngineResponse.results;
            this.resultsTotal = searchEngineResponse.getResultsTotal();
        }
        catch (Exception exception) {
            throw (ProcessingException)ExceptionUtils.wrapAs(ProcessingException.class, (Throwable)exception);
        }
    }

    protected SearchEngineResponse fetchSearchResponse() throws Exception {
        Object object;
        SearchEngineResponse searchEngineResponse;
        if (this.directory == null) {
            throw new ProcessingException("Directory attribute must not be empty.");
        }
        if (this.query instanceof String) {
            searchEngineResponse = this.fieldMapper.getSearchFields();
            if (searchEngineResponse == null || ((SearchEngineResponse)searchEngineResponse).length == 0) {
                throw new ProcessingException("At least one search field must be given for a plain text query. Alternatively, use a Lucene Query object.");
            }
            object = (String)this.query;
            if (StringUtils.isEmpty((String)object)) {
                throw new ProcessingException("An instantiated Lucene Query object or a non-empty plain text query is required.");
            }
            this.query = ((SearchEngineResponse)searchEngineResponse).length == 1 ? new QueryParser((String)searchEngineResponse[0], this.analyzer).parse((String)object) : new MultiFieldQueryParser((String[])searchEngineResponse, this.analyzer).parse((String)object);
        }
        searchEngineResponse = new SearchEngineResponse();
        object = this.indexOpen(this.directory);
        TopDocs topDocs = object.search((Query)this.query, null, this.results);
        searchEngineResponse.metadata.put("resultsTotal", topDocs.totalHits);
        ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
        int n = topDocs.scoreDocs.length;
        int n2 = 0;
        while (n2 < n) {
            ScoreDoc scoreDoc = scoreDocArray[n2];
            Document document = new Document();
            org.apache.lucene.document.Document document2 = object.doc(scoreDoc.doc);
            document.setScore(Double.valueOf(scoreDoc.score));
            if (this.keepLuceneDocuments) {
                document.setField(LUCENE_DOCUMENT_FIELD, (Object)document2);
                document.addSerializationListener(removeLuceneDocument);
            }
            this.fieldMapper.map((Query)this.query, this.analyzer, document2, document);
            searchEngineResponse.results.add(document);
            ++n2;
        }
        return searchEngineResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAllIndexes() {
        IControllerContext iControllerContext = this.context;
        synchronized (iControllerContext) {
            for (IndexSearcher indexSearcher : this.openIndexes.values()) {
                try {
                    indexSearcher.getIndexReader().close();
                }
                catch (IOException iOException) {
                    logger.warn("Could not close search index: " + indexSearcher, (Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexSearcher indexOpen(Directory directory) throws ProcessingException {
        IControllerContext iControllerContext = this.context;
        synchronized (iControllerContext) {
            IndexSearcher indexSearcher = this.openIndexes.get(directory);
            if (indexSearcher == null) {
                try {
                    indexSearcher = new IndexSearcher((IndexReader)DirectoryReader.open((Directory)directory));
                    this.openIndexes.put(directory, indexSearcher);
                }
                catch (IOException iOException) {
                    throw (ProcessingException)ExceptionUtils.wrapAs(ProcessingException.class, (Throwable)iOException);
                }
            }
            return indexSearcher;
        }
    }
}

