/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.lucene.IFieldMapper;
import org.carrot2.source.lucene.PlainTextFormatter;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.constraint.ImplementingClasses;
import org.carrot2.util.attribute.constraint.IntRange;

@Bindable
public class SimpleFieldMapper
implements IFieldMapper {
    static final String INDEX_FIELD_MAPPING = "Index field mapping";
    static final String HIGHLIGHTER = "Highlighter";
    @Input
    @Attribute
    @Init
    @Processing
    @Internal(configuration=true)
    @Label(value="Document title field")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Index field mapping")
    public String titleField;
    @Input
    @Attribute
    @Init
    @Processing
    @Internal(configuration=true)
    @Label(value="Document content field")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Index field mapping")
    public String contentField;
    @Input
    @Attribute
    @Init
    @Processing
    @Internal(configuration=true)
    @Label(value="Document URL field")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Index field mapping")
    public String urlField;
    @Input
    @Attribute
    @Init
    @Processing
    @Internal(configuration=true)
    @Label(value="Search fields")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Index field mapping")
    public List<String> searchFields;
    @Input
    @Attribute
    @Init
    @Processing
    @ImplementingClasses(classes={PlainTextFormatter.class, SimpleHTMLFormatter.class}, strict=false)
    @Label(value="Formatter")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Highlighter")
    public Formatter formatter = new PlainTextFormatter();
    @Input
    @Attribute
    @Init
    @Processing
    @IntRange(min=1)
    @Label(value="Context fragments")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Highlighter")
    public int contextFragments = 3;
    @Input
    @Attribute
    @Init
    @Processing
    @Label(value="Join string")
    @Level(value=AttributeLevel.ADVANCED)
    @Group(value="Highlighter")
    public String fragmentJoin = "...";
    private Highlighter highlighter;
    private Query query;

    @Override
    public String[] getSearchFields() {
        if (this.searchFields == null || this.searchFields.size() == 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!StringUtils.isEmpty((String)this.titleField)) {
                arrayList.add(this.titleField);
            }
            if (!StringUtils.isEmpty((String)this.contentField)) {
                arrayList.add(this.contentField);
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return this.searchFields.toArray(new String[this.searchFields.size()]);
    }

    @Override
    public void map(Query query, Analyzer analyzer, org.apache.lucene.document.Document document, Document document2) {
        String string;
        if (query != this.query) {
            this.query = query;
            this.resetHighlighter();
        }
        if ((string = this.fieldValue(this.titleField, document)) != null) {
            document2.setField("title", (Object)string);
        }
        if ((string = this.fieldValue(this.urlField, document)) != null) {
            document2.setField("url", (Object)string);
        }
        if ((string = this.fieldValue(this.contentField, document)) != null) {
            try {
                Object[] objectArray;
                String string2 = this.highlighter != null ? ((objectArray = this.highlighter.getBestFragments(analyzer, this.contentField, string, this.contextFragments)).length > 0 ? StringUtils.join((Object[])objectArray, (String)this.fragmentJoin) : string) : string;
                document2.setField("snippet", (Object)string2);
            }
            catch (IOException iOException) {
                throw ExceptionUtils.wrapAsRuntimeException((Throwable)iOException);
            }
            catch (InvalidTokenOffsetsException invalidTokenOffsetsException) {
                throw ExceptionUtils.wrapAsRuntimeException((Throwable)invalidTokenOffsetsException);
            }
        }
    }

    private String fieldValue(String string, org.apache.lucene.document.Document document) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        StringBuilder stringBuilder = null;
        for (IndexableField indexableField : document.getFields()) {
            if (!indexableField.name().equals(string)) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(indexableField.stringValue());
        }
        return stringBuilder == null ? null : stringBuilder.toString();
    }

    private void resetHighlighter() {
        if (this.formatter != null) {
            this.highlighter = new Highlighter(this.formatter, (Scorer)new QueryScorer(this.query));
            this.highlighter.setEncoder((Encoder)new DefaultEncoder());
        } else {
            this.highlighter = null;
        }
    }
}

