/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.microsoft;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.carrot2.core.Document;
import org.carrot2.core.LanguageCode;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.CommonAttributes;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.microsoft.AdultOption;
import org.carrot2.source.microsoft.MarketOption;
import org.carrot2.source.microsoft.SourceType;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.NotBlank;
import org.carrot2.util.httpclient.HttpRedirectStrategy;
import org.carrot2.util.httpclient.HttpUtils;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.NamespaceList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bindable(prefix="Bing3DocumentSource", inherit={CommonAttributes.class})
public abstract class Bing3DocumentSource
extends MultipageSearchEngine {
    public static final String SYSPROP_BING3_API = "bing3.key";
    private static final String SERVICE_URI = "https://api.datamarket.azure.com/Bing/Search";
    private static final Logger logger = LoggerFactory.getLogger(Bing3DocumentSource.class);
    private List<Header> HTTP_HEADERS = Arrays.asList(new Header[0]);
    protected static final int MAX_CONCURRENT_THREADS = 10;
    private static final EnumMap<SourceType, String> TYPE_URI_SUFFIXES;
    private static final int BING_TIMEOUT;
    @Init
    @Processing
    @Input
    @Attribute
    @Label(value="Application API key")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Service")
    @Required
    @NotBlank
    public String appid = System.getProperty("bing3.key");
    @Input
    @Processing
    @Attribute
    @Label(value="Market")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Filtering")
    public MarketOption market = MarketOption.ENGLISH_UNITED_STATES;
    @Processing
    @Input
    @Attribute
    @Label(value="Safe search")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Filtering")
    public AdultOption adult;
    @Processing
    @Input
    @Attribute
    @Label(value="Latitude hint")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Filtering")
    public Double latitude;
    @Processing
    @Input
    @Attribute
    @Label(value="Longitude hint")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Filtering")
    public Double longitude;
    @Input
    @Processing
    @Attribute
    @Label(value="HTTP redirect strategy")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Service")
    @Internal
    public HttpRedirectStrategy redirectStrategy = HttpRedirectStrategy.NO_REDIRECTS;
    private final SourceType sourceType;

    static {
        BING_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(10L);
        TYPE_URI_SUFFIXES = Maps.newEnumMap(SourceType.class);
        TYPE_URI_SUFFIXES.put(SourceType.WEB, "/Web");
        TYPE_URI_SUFFIXES.put(SourceType.IMAGE, "/Image");
        TYPE_URI_SUFFIXES.put(SourceType.NEWS, "/News");
    }

    public Bing3DocumentSource(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    protected void process(MultipageSearchEngineMetadata multipageSearchEngineMetadata, ExecutorService executorService) throws ProcessingException {
        if (Strings.isNullOrEmpty((String)this.appid)) {
            throw new ProcessingException("Bing API requires a key. See " + Bing3DocumentSource.class.getSimpleName() + " class documentation.");
        }
        super.process(multipageSearchEngineMetadata, executorService);
    }

    protected final Callable<SearchEngineResponse> createFetcher(final MultipageSearchEngine.SearchRange searchRange) {
        return new MultipageSearchEngine.SearchEngineResponseCallable(this){

            public SearchEngineResponse search() throws Exception {
                return Bing3DocumentSource.this.doSearch(Bing3DocumentSource.this.query, searchRange.start, searchRange.results);
            }
        };
    }

    private final SearchEngineResponse doSearch(String string, int n, int n2) throws Exception {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new BasicNameValuePair("Query", Bing3DocumentSource.stringValue(string)));
        this.addIfNotEmpty(arrayList, "Adult", Bing3DocumentSource.stringValue((Object)this.adult));
        if (this.market != null) {
            this.addIfNotEmpty(arrayList, "Market", Bing3DocumentSource.stringValue(this.market.marketCode));
        }
        if (this.latitude != null) {
            arrayList.add(new BasicNameValuePair("Latitude", Double.toString(this.latitude)));
        }
        if (this.longitude != null) {
            arrayList.add(new BasicNameValuePair("Longitude", Double.toString(this.longitude)));
        }
        arrayList.add(new BasicNameValuePair("$skip", Integer.toString(n)));
        arrayList.add(new BasicNameValuePair("$top", Integer.toString(n2)));
        this.appendSourceParams(arrayList);
        String string2 = TYPE_URI_SUFFIXES.get((Object)this.sourceType);
        if (string2 == null) {
            throw new RuntimeException("Service suffix is null?: " + (Object)((Object)this.sourceType));
        }
        HttpUtils.Response response = null;
        int n3 = 3;
        while (n3 >= 0) {
            try {
                response = HttpUtils.doGET((String)(SERVICE_URI + string2), (Collection)arrayList, this.HTTP_HEADERS, (String)"", (String)this.appid, (int)BING_TIMEOUT, (RedirectStrategy)this.redirectStrategy.value());
                break;
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                if (n3 == 0) {
                    throw sSLPeerUnverifiedException;
                }
                logger.warn("Bing peer authentication failure, retries: " + n3);
                --n3;
            }
        }
        if (response.status == 200) {
            SearchEngineResponse searchEngineResponse = this.parseResponse(response.getPayloadAsStream());
            searchEngineResponse.metadata.put("compression", response.compression);
            if (logger.isDebugEnabled()) {
                logger.debug("Received, results: " + searchEngineResponse.results.size() + ", total: " + searchEngineResponse.getResultsTotal());
            }
            return searchEngineResponse;
        }
        String string3 = "Bing returned HTTP Error: " + response.status + ", HTTP payload: " + new String(response.payload, "iso8859-1");
        logger.warn(string3);
        if (response.status == 503 && string3.contains("Insufficient balance")) {
            throw new IOException("Bing API query limit depleted. See Carrot2 FAQ: http://project.carrot2.org/faq.html#bing");
        }
        throw new IOException(string3);
    }

    protected void addIfNotEmpty(ArrayList<NameValuePair> arrayList, String string, Object object) {
        String string2;
        if (object != null && !Strings.isNullOrEmpty((String)(string2 = object.toString()))) {
            arrayList.add((NameValuePair)new BasicNameValuePair(string, string2));
        }
    }

    public abstract void process() throws ProcessingException;

    protected void appendSourceParams(ArrayList<NameValuePair> arrayList) {
    }

    private SearchEngineResponse parseResponse(InputStream inputStream) throws Exception {
        LanguageCode languageCode;
        AtomFeed atomFeed = (AtomFeed)new Persister().read(AtomFeed.class, inputStream);
        SearchEngineResponse searchEngineResponse = new SearchEngineResponse();
        LanguageCode languageCode2 = languageCode = this.market != null ? this.market.toLanguageCode() : null;
        if (atomFeed.entries != null) {
            for (AtomEntry atomEntry : atomFeed.entries) {
                Document document;
                if (atomEntry == null || atomEntry.content == null || atomEntry.content.properties == null) continue;
                EntryProperties entryProperties = atomEntry.content.properties;
                switch (this.sourceType) {
                    case IMAGE: {
                        document = new Document(entryProperties.title, entryProperties.description, entryProperties.sourceUrl);
                        break;
                    }
                    case WEB: 
                    case NEWS: {
                        document = new Document(entryProperties.title, entryProperties.description, entryProperties.url);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                document.setLanguage(languageCode);
                if (entryProperties.displayUrl != null) {
                    document.setField("click-url", (Object)entryProperties.displayUrl);
                }
                if (entryProperties.source != null) {
                    document.setField("sources", Arrays.asList(entryProperties.source));
                }
                if (entryProperties.thumbnail != null && entryProperties.thumbnail.mediaUrl != null) {
                    document.setField("thumbnail-url", (Object)entryProperties.thumbnail.mediaUrl);
                }
                searchEngineResponse.results.add(document);
            }
        }
        return searchEngineResponse;
    }

    protected static String stringValue(Object object) {
        if (object == null || object.toString().trim().isEmpty()) {
            return null;
        }
        return "'" + object + "'";
    }

    @Root(strict=false)
    public static class AtomEntry {
        @Element(name="id", required=true)
        public String id;
        @Element(name="content", required=false)
        public ContentEntry content;
    }

    @Root(name="feed", strict=false)
    @NamespaceList(value={@Namespace(reference="http://www.w3.org/2005/Atom"), @Namespace(prefix="m", reference="http://schemas.microsoft.com/ado/2007/08/dataservices/metadata"), @Namespace(prefix="d", reference="http://schemas.microsoft.com/ado/2007/08/dataservices"), @Namespace(prefix="base", reference="https://api.datamarket.azure.com/Data.ashx/Bing/Search/Web")})
    public static class AtomFeed {
        @ElementList(inline=true, entry="entry", required=false, type=AtomEntry.class)
        public List<AtomEntry> entries;
    }

    @Root(strict=false)
    public static class ContentEntry {
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices/metadata")
        @Element(name="properties", required=false)
        public EntryProperties properties;
    }

    @Root(strict=false)
    public static class EntryProperties {
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Title", required=false)
        public String title;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Description", required=false)
        public String description;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="DisplayUrl", required=false)
        public String displayUrl;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Url", required=false)
        public String url;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Source", required=false)
        public String source;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="MediaUrl", required=false)
        public String mediaUrl;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="SourceUrl", required=false)
        public String sourceUrl;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Thumbnail", required=false)
        public Thumbnail thumbnail;
    }

    @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
    @Root(name="Thumbnail", strict=false)
    public static class Thumbnail {
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="MediaUrl", required=false)
        public String mediaUrl;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Width", required=false)
        public int width;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="Height", required=false)
        public int height;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="ContentType", required=false)
        public String contentType;
        @Namespace(reference="http://schemas.microsoft.com/ado/2007/08/dataservices")
        @Element(name="FileSize", required=false)
        public long fileSize;
    }
}

