/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source.microsoft;

import java.util.ArrayList;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.microsoft.Bing3DocumentSource;
import org.carrot2.source.microsoft.NewsCategory;
import org.carrot2.source.microsoft.SortOrder;
import org.carrot2.source.microsoft.SourceType;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;

@Bindable(prefix="Bing3NewsDocumentSource")
public class Bing3NewsDocumentSource
extends Bing3DocumentSource {
    static final MultipageSearchEngineMetadata metadata = new MultipageSearchEngineMetadata(15, 100);
    @Processing
    @Input
    @Attribute
    @Label(value="Sort order")
    @Level(value=AttributeLevel.MEDIUM)
    @Group(value="Filtering")
    public SortOrder sortOrder;
    @Processing
    @Input
    @Attribute
    @Label(value="Category")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Filtering")
    public NewsCategory newsCategory;

    public Bing3NewsDocumentSource() {
        super(SourceType.NEWS);
    }

    @Override
    public void process() throws ProcessingException {
        super.process(metadata, this.getSharedExecutor(10, ((Object)((Object)this)).getClass()));
    }

    @Override
    protected void appendSourceParams(ArrayList<NameValuePair> arrayList) {
        super.appendSourceParams(arrayList);
        this.addIfNotEmpty(arrayList, "NewsSortBy", Bing3NewsDocumentSource.stringValue((Object)this.sortOrder));
        if (this.newsCategory != null) {
            arrayList.add((NameValuePair)new BasicNameValuePair("NewsCategory", Bing3NewsDocumentSource.stringValue(this.newsCategory.catValue)));
        }
    }
}

