/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.carrot2.core.Controller;
import org.carrot2.core.ControllerUtils;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.IProcessingComponentManager;
import org.carrot2.core.ProcessingComponentBase;
import org.carrot2.core.ProcessingComponentConfiguration;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Processing;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.Pair;
import org.carrot2.util.attribute.AttributeDescriptor;
import org.carrot2.util.attribute.BindableDescriptorBuilder;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;

public class CachingProcessingComponentManager
implements IProcessingComponentManager,
Controller.IControllerStatisticsProvider {
    final IProcessingComponentManager delegate;
    private final Map<Pair<Class<? extends IProcessingComponent>, String>, InputOutputAttributeDescriptors> cachedComponentAttributeDescriptors = Maps.newHashMap();
    final Set<Class<? extends IProcessingComponent>> cachedComponentClasses;
    private Cache<AttributeMapCacheKey, Map<String, Object>> cache;
    static final String CACHE_MISSES = "cache.misses";
    static final String CACHE_HITS_TOTAL = "cache.hits.total";
    private static final String COMPONENT_CLASS_KEY = String.valueOf(CachingProcessingComponentManager.class.getName()) + ".componentClass";
    private static final String COMPONENT_ID_KEY = String.valueOf(CachingProcessingComponentManager.class.getName()) + ".componentId";
    public static final String CACHE_BYPASS_ATTR = String.valueOf(CachingProcessingComponentManager.class.getName()) + ".cacheBypass";

    public CachingProcessingComponentManager(IProcessingComponentManager iProcessingComponentManager, Class<? extends IProcessingComponent> ... classArray) {
        this.delegate = iProcessingComponentManager;
        this.cachedComponentClasses = ImmutableSet.copyOf((Object[])classArray);
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).recordStats().build();
    }

    @Override
    public void init(IControllerContext iControllerContext, Map<String, Object> map, ProcessingComponentConfiguration ... processingComponentConfigurationArray) {
        this.delegate.init(iControllerContext, map, processingComponentConfigurationArray);
    }

    @Override
    public IProcessingComponent prepare(Class<? extends IProcessingComponent> clazz, String string, Map<String, Object> map, Map<String, Object> map2) {
        for (Class<? extends IProcessingComponent> clazz2 : this.cachedComponentClasses) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return new CachedProcessingComponent(clazz, string, map, map2);
        }
        return this.delegate.prepare(clazz, string, map, map2);
    }

    @Override
    public void recycle(IProcessingComponent iProcessingComponent, String string) {
        if (!(iProcessingComponent instanceof CachedProcessingComponent)) {
            this.delegate.recycle(iProcessingComponent, string);
        }
    }

    @Override
    public void dispose() {
        try {
            this.delegate.dispose();
            if (this.cache != null) {
                this.cache.invalidateAll();
            }
        }
        finally {
            this.cache = null;
        }
    }

    @Override
    public Map<String, Object> getStatistics() {
        CacheStats cacheStats = this.cache.stats();
        HashMap hashMap = Maps.newHashMap();
        if (this.delegate instanceof Controller.IControllerStatisticsProvider) {
            hashMap.putAll(((Controller.IControllerStatisticsProvider)((Object)this.delegate)).getStatistics());
        }
        hashMap.put(CACHE_MISSES, cacheStats.missCount());
        hashMap.put(CACHE_HITS_TOTAL, cacheStats.hitCount());
        return hashMap;
    }

    private static final class AttributeMapCacheKey {
        private Map<String, Object> inputProcessingAttributes;
        private int hashCode;
        private Map<String, Object> inputAttributes;

        private AttributeMapCacheKey(Map<String, Object> map, Map<String, Object> map2) {
            assert (map != null && map.size() > 0);
            this.inputProcessingAttributes = Collections.unmodifiableMap(map);
            this.hashCode = map.hashCode();
            this.inputAttributes = map2;
        }

        public boolean equals(Object object) {
            boolean bl;
            if (!(object instanceof AttributeMapCacheKey)) {
                return false;
            }
            boolean bl2 = bl = object.hashCode() == this.hashCode;
            if (bl) assert (((AttributeMapCacheKey)object).inputProcessingAttributes.equals(this.inputProcessingAttributes));
            return bl;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private final class CachedProcessingComponent
    extends ProcessingComponentBase {
        private final Class<? extends IProcessingComponent> componentClass;
        private final String componentId;
        private final Map<String, Object> inputAttributes;
        private final Map<String, Object> outputAttributes;

        CachedProcessingComponent(Class<? extends IProcessingComponent> clazz, String string, Map<String, Object> map, Map<String, Object> map2) {
            this.componentClass = clazz;
            this.inputAttributes = map;
            this.outputAttributes = map2;
            this.componentId = string;
        }

        @Override
        public void process() throws ProcessingException {
            InputOutputAttributeDescriptors inputOutputAttributeDescriptors = this.prepareAttributeDescriptors();
            this.inputAttributes.putAll(this.outputAttributes);
            Map<String, Object> map = this.getAttributesForDescriptors(inputOutputAttributeDescriptors.inputProcessingDescriptors, this.inputAttributes);
            map.put(COMPONENT_CLASS_KEY, this.componentClass);
            map.put(COMPONENT_ID_KEY, this.componentId);
            AttributeMapCacheKey attributeMapCacheKey = new AttributeMapCacheKey(map, this.inputAttributes);
            if (this.inputAttributes.containsKey(CACHE_BYPASS_ATTR) && Boolean.valueOf(this.inputAttributes.get(CACHE_BYPASS_ATTR).toString()).booleanValue()) {
                CachingProcessingComponentManager.this.cache.invalidate((Object)attributeMapCacheKey);
            }
            try {
                Map map2 = (Map)CachingProcessingComponentManager.this.cache.get((Object)attributeMapCacheKey, (Callable)new ValueProducer(attributeMapCacheKey));
                this.outputAttributes.putAll(this.getAttributesForDescriptors(inputOutputAttributeDescriptors.outputDescriptors, map2));
            }
            catch (UncheckedExecutionException uncheckedExecutionException) {
                throw (ProcessingException)ExceptionUtils.wrapAs(ProcessingException.class, (Throwable)uncheckedExecutionException.getCause());
            }
            catch (ExecutionException executionException) {
                throw (ProcessingException)ExceptionUtils.wrapAs(ProcessingException.class, (Throwable)executionException.getCause());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InputOutputAttributeDescriptors prepareAttributeDescriptors() {
            InputOutputAttributeDescriptors inputOutputAttributeDescriptors = null;
            Map map = CachingProcessingComponentManager.this.cachedComponentAttributeDescriptors;
            synchronized (map) {
                inputOutputAttributeDescriptors = (InputOutputAttributeDescriptors)CachingProcessingComponentManager.this.cachedComponentAttributeDescriptors.get(new Pair(this.componentClass, (Object)this.componentId));
                if (inputOutputAttributeDescriptors == null) {
                    IProcessingComponent iProcessingComponent = null;
                    try {
                        iProcessingComponent = CachingProcessingComponentManager.this.delegate.prepare(this.componentClass, this.componentId, this.inputAttributes, Maps.newHashMap());
                        inputOutputAttributeDescriptors = new InputOutputAttributeDescriptors(BindableDescriptorBuilder.buildDescriptor((Object)iProcessingComponent).only((Class[])new Class[]{Input.class, Processing.class}).flatten().attributeDescriptors, BindableDescriptorBuilder.buildDescriptor((Object)iProcessingComponent).only((Class[])new Class[]{Output.class}).flatten().attributeDescriptors);
                        CachingProcessingComponentManager.this.cachedComponentAttributeDescriptors.put(new Pair(this.componentClass, (Object)this.componentId), inputOutputAttributeDescriptors);
                    }
                    catch (Throwable throwable) {
                        if (iProcessingComponent != null) {
                            CachingProcessingComponentManager.this.delegate.recycle(iProcessingComponent, this.componentId);
                        }
                        throw throwable;
                    }
                    if (iProcessingComponent != null) {
                        CachingProcessingComponentManager.this.delegate.recycle(iProcessingComponent, this.componentId);
                    }
                }
            }
            return inputOutputAttributeDescriptors;
        }

        Map<String, Object> getAttributesForDescriptors(Map<String, AttributeDescriptor> map, Map<String, Object> map2) {
            HashMap hashMap = Maps.newHashMap();
            for (AttributeDescriptor attributeDescriptor : map.values()) {
                if (!map2.containsKey(attributeDescriptor.key)) continue;
                hashMap.put(attributeDescriptor.key, map2.get(attributeDescriptor.key));
            }
            return hashMap;
        }
    }

    private static final class InputOutputAttributeDescriptors {
        final Map<String, AttributeDescriptor> inputProcessingDescriptors;
        final Map<String, AttributeDescriptor> outputDescriptors;

        InputOutputAttributeDescriptors(Map<String, AttributeDescriptor> map, Map<String, AttributeDescriptor> map2) {
            this.inputProcessingDescriptors = map;
            this.outputDescriptors = map2;
        }
    }

    private final class ValueProducer
    implements Callable<Map<String, Object>> {
        private final AttributeMapCacheKey key;

        public ValueProducer(AttributeMapCacheKey attributeMapCacheKey) {
            this.key = attributeMapCacheKey;
        }

        @Override
        public Map<String, Object> call() throws Exception {
            Map map = this.key.inputProcessingAttributes;
            Class clazz = (Class)map.get(COMPONENT_CLASS_KEY);
            String string = (String)map.get(COMPONENT_ID_KEY);
            IProcessingComponent iProcessingComponent = null;
            try {
                HashMap hashMap = Maps.newHashMap();
                iProcessingComponent = CachingProcessingComponentManager.this.delegate.prepare(clazz, string, this.key.inputAttributes, hashMap);
                ControllerUtils.performProcessing(iProcessingComponent, map, hashMap);
                HashMap hashMap2 = hashMap;
                if (iProcessingComponent != null) {
                    CachingProcessingComponentManager.this.delegate.recycle(iProcessingComponent, string);
                }
                return hashMap2;
            }
            catch (Throwable throwable) {
                if (iProcessingComponent != null) {
                    CachingProcessingComponentManager.this.delegate.recycle(iProcessingComponent, string);
                }
                throw throwable;
            }
        }
    }
}

