/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Document;
import org.carrot2.util.MapUtils;
import org.carrot2.util.StringUtils;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;

@Root(name="group", strict=false)
@JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Cluster {
    public static final String OTHER_TOPICS = "other-topics";
    public static final String OTHER_TOPICS_LABEL = "Other Topics";
    public static final String SCORE = "score";
    @Attribute(required=false)
    Integer id;
    @ElementList(required=false, name="title", entry="phrase")
    private ArrayList<String> phrases = new ArrayList();
    private List<String> phrasesView = Collections.unmodifiableList(this.phrases);
    @ElementList(required=false, inline=true)
    private ArrayList<Cluster> subclusters = new ArrayList();
    private List<Cluster> subclustersView = Collections.unmodifiableList(this.subclusters);
    private final ArrayList<Document> documents = new ArrayList();
    private final List<Document> documentsView = Collections.unmodifiableList(this.documents);
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, Object> attributesView = Collections.unmodifiableMap(this.attributes);
    private String labelCache = null;
    private List<Document> allDocuments;
    @ElementMap(entry="attribute", key="key", attribute=true, inline=true, required=false)
    private HashMap<String, SimpleXmlWrapperValue> otherAttributesForSerialization;
    @ElementList(required=false, inline=true)
    List<DocumentRefid> documentIds;
    public static final Comparator<Cluster> BY_SIZE_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)new Function<Cluster, Integer>(){

        public Integer apply(Cluster cluster) {
            return cluster.size();
        }
    });
    public static final Comparator<Cluster> BY_SCORE_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)new Function<Cluster, Double>(){

        public Double apply(Cluster cluster) {
            return (Double)cluster.getAttribute(Cluster.SCORE);
        }
    });
    public static final Comparator<Cluster> BY_LABEL_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)new Function<Cluster, String>(){

        public String apply(Cluster cluster) {
            return cluster.getLabel();
        }
    });
    public static final Comparator<Cluster> BY_REVERSED_SIZE_AND_LABEL_COMPARATOR = Ordering.from(Collections.reverseOrder(BY_SIZE_COMPARATOR)).compound(BY_LABEL_COMPARATOR);
    public static final Comparator<Cluster> BY_REVERSED_SCORE_AND_LABEL_COMPARATOR = Ordering.from(Collections.reverseOrder(BY_SCORE_COMPARATOR)).compound(BY_LABEL_COMPARATOR);
    public static final Comparator<Cluster> OTHER_TOPICS_AT_THE_END = Ordering.natural().onResultOf((Function)new Function<Cluster, Double>(){

        public Double apply(Cluster cluster) {
            return cluster.isOtherTopics() ? 1.0 : -1.0;
        }
    });
    private static Function<Document, String> DOCUMENT_TO_ID = new Function<Document, String>(){

        public String apply(Document document) {
            return document.getStringId();
        }
    };

    public Cluster() {
    }

    public Cluster(String string, Document ... documentArray) {
        this.addPhrases(string);
        this.addDocuments(documentArray);
    }

    public Cluster(Integer n, String string, Document ... documentArray) {
        this(string, documentArray);
        this.id = n;
    }

    public String getLabel() {
        if (this.labelCache == null) {
            this.labelCache = StringUtils.toString(this.phrases, (String)", ");
        }
        return this.labelCache;
    }

    @JsonProperty
    public List<String> getPhrases() {
        return this.phrasesView;
    }

    public List<Cluster> getSubclusters() {
        return this.subclustersView;
    }

    @JsonProperty(value="clusters")
    private List<Cluster> getSubclustersForSerialization() {
        return this.subclustersView.isEmpty() ? null : this.subclustersView;
    }

    public List<Document> getDocuments() {
        return this.documentsView;
    }

    public List<Document> getAllDocuments() {
        if (this.allDocuments == null) {
            this.allDocuments = new ArrayList<Document>(Cluster.collectAllDocuments(this, new LinkedHashSet<Document>()));
        }
        return this.allDocuments;
    }

    public List<Document> getAllDocuments(Comparator<Document> comparator) {
        ArrayList arrayList = Lists.newArrayList(this.getAllDocuments());
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    private static Set<Document> collectAllDocuments(Cluster cluster, Set<Document> set) {
        if (cluster == null) {
            return set;
        }
        set.addAll(cluster.getDocuments());
        List<Cluster> list = cluster.getSubclusters();
        for (Cluster cluster2 : list) {
            Cluster.collectAllDocuments(cluster2, set);
        }
        return set;
    }

    public Cluster addPhrases(String ... stringArray) {
        this.labelCache = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            this.phrases.add(string);
            ++n2;
        }
        return this;
    }

    public Cluster addPhrases(Iterable<String> iterable) {
        this.labelCache = null;
        for (String string : iterable) {
            this.phrases.add(string);
        }
        return this;
    }

    public Cluster addDocuments(Document ... documentArray) {
        Document[] documentArray2 = documentArray;
        int n = documentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Document document = documentArray2[n2];
            this.documents.add(document);
            ++n2;
        }
        this.allDocuments = null;
        return this;
    }

    public Cluster addDocument(Document document) {
        this.documents.add(document);
        this.allDocuments = null;
        return this;
    }

    public Cluster addDocuments(Iterable<Document> iterable) {
        for (Document document : iterable) {
            this.documents.add(document);
        }
        this.allDocuments = null;
        return this;
    }

    public Cluster addSubclusters(Cluster ... clusterArray) {
        Cluster[] clusterArray2 = clusterArray;
        int n = clusterArray.length;
        int n2 = 0;
        while (n2 < n) {
            Cluster cluster = clusterArray2[n2];
            this.subclusters.add(cluster);
            ++n2;
        }
        this.allDocuments = null;
        return this;
    }

    public Cluster addSubcluster(Cluster cluster) {
        this.subclusters.add(cluster);
        this.allDocuments = null;
        return this;
    }

    public Cluster addSubclusters(Iterable<Cluster> iterable) {
        for (Cluster cluster : iterable) {
            this.subclusters.add(cluster);
        }
        this.allDocuments = null;
        return this;
    }

    @JsonProperty
    @Attribute(required=false)
    public Double getScore() {
        return (Double)this.getAttribute(SCORE);
    }

    @Attribute(required=false)
    public Cluster setScore(Double d) {
        return this.setAttribute(SCORE, d);
    }

    public <T> T getAttribute(String string) {
        return (T)this.attributes.get(string);
    }

    public <T> Cluster setAttribute(String string, T t) {
        this.attributes.put(string, t);
        return this;
    }

    public <T> Cluster removeAttribute(String string) {
        this.attributes.remove(string);
        return this;
    }

    public Map<String, Object> getAttributes() {
        return this.attributesView;
    }

    public int size() {
        return this.getAllDocuments().size();
    }

    @JsonProperty
    @Attribute(required=false)
    private int getSize() {
        return this.size();
    }

    @Attribute(required=false)
    private void setSize(int n) {
    }

    @JsonProperty
    public Integer getId() {
        return this.id;
    }

    public boolean isOtherTopics() {
        Boolean bl = (Boolean)this.getAttribute(OTHER_TOPICS);
        return bl != null && bl != false;
    }

    public Cluster setOtherTopics(boolean bl) {
        if (bl) {
            this.setAttribute(OTHER_TOPICS, Boolean.TRUE).setScore(0.0);
        } else {
            this.removeAttribute(OTHER_TOPICS);
        }
        return this;
    }

    public static Comparator<Cluster> byReversedWeightedScoreAndSizeComparator(final double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Score weight must be between 0.0 (inclusive) and 1.0 (inclusive) ");
        }
        return Ordering.natural().onResultOf((Function)new Function<Cluster, Double>(){

            public Double apply(Cluster cluster) {
                return -Math.pow(cluster.size(), 1.0 - d) * Math.pow((Double)cluster.getAttribute(Cluster.SCORE), d);
            }
        }).compound(BY_LABEL_COMPARATOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void assignClusterIds(Collection<Cluster> collection) {
        List<Cluster> list = Cluster.flatten(collection);
        Collection<Cluster> collection2 = collection;
        synchronized (collection2) {
            boolean bl = false;
            for (Cluster cluster : list) {
                if (cluster.id == null) continue;
                bl = true;
                break;
            }
            if (bl) {
                HashSet hashSet = Sets.newHashSet();
                for (Cluster cluster : list) {
                    if (hashSet.add(cluster.id)) continue;
                    throw new IllegalArgumentException("Cluster identifiers must be unique, duplicated identifier: " + cluster.id);
                }
                if (hashSet.contains(null)) {
                    throw new IllegalArgumentException("Null cluster identifiers cannot be mixed with existing non-null identifiers.");
                }
            } else {
                boolean bl2 = false;
                for (Cluster cluster : list) {
                    void var4_12;
                    if (cluster.id != null) continue;
                    cluster.id = (int)(++var4_12);
                }
            }
        }
    }

    public static List<Cluster> flatten(Collection<Cluster> collection) {
        return Cluster.flatten(collection, Lists.newArrayList());
    }

    private static List<Cluster> flatten(Collection<Cluster> collection, List<Cluster> list) {
        for (Cluster cluster : collection) {
            list.add(cluster);
            Cluster.flatten(cluster.getSubclusters(), list);
        }
        return list;
    }

    public static Cluster find(int n, Collection<Cluster> collection) {
        for (Cluster cluster : collection) {
            Cluster cluster2;
            if (cluster == null) continue;
            if (cluster.id != null && cluster.id == n) {
                return cluster;
            }
            if (cluster.getSubclusters().isEmpty() || (cluster2 = Cluster.find(n, cluster.getSubclusters())) == null) continue;
            return cluster2;
        }
        return null;
    }

    public static Cluster buildOtherTopics(List<Document> list, List<Cluster> list2) {
        return Cluster.buildOtherTopics(list, list2, OTHER_TOPICS_LABEL);
    }

    public static Cluster buildOtherTopics(List<Document> list, List<Cluster> list2, String string) {
        Cluster cluster2;
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet(list);
        HashSet hashSet = Sets.newHashSet();
        for (Cluster cluster2 : list2) {
            Cluster.collectAllDocuments(cluster2, hashSet);
        }
        linkedHashSet.removeAll(hashSet);
        cluster2 = new Cluster(string, new Document[0]);
        cluster2.addDocuments(linkedHashSet);
        cluster2.setOtherTopics(true);
        return cluster2;
    }

    public static Cluster appendOtherTopics(List<Document> list, List<Cluster> list2) {
        return Cluster.appendOtherTopics(list, list2, OTHER_TOPICS_LABEL);
    }

    public static Cluster appendOtherTopics(List<Document> list, List<Cluster> list2, String string) {
        Cluster cluster = Cluster.buildOtherTopics(list, list2, string);
        if (!cluster.getDocuments().isEmpty()) {
            list2.add(cluster);
        }
        return cluster;
    }

    public void remapDocumentReferences(IdentityHashMap<Document, Document> identityHashMap) {
        if (this.id != null) {
            throw new IllegalStateException();
        }
        int n = this.documents.size();
        while (--n >= 0) {
            Document document = this.documents.get(n);
            Document document2 = identityHashMap.get(document);
            if (document2 == null) continue;
            this.documents.set(n, document2);
        }
        this.allDocuments = null;
    }

    @Persist
    private void beforeSerialization() {
        this.documentIds = Lists.transform(this.documents, (Function)new Function<Document, DocumentRefid>(){

            public DocumentRefid apply(Document document) {
                return new DocumentRefid(document.getStringId());
            }
        });
        this.otherAttributesForSerialization = MapUtils.asHashMap((Map)SimpleXmlWrappers.wrap(this.attributes));
        this.otherAttributesForSerialization.remove(SCORE);
        if (this.otherAttributesForSerialization.isEmpty()) {
            this.otherAttributesForSerialization = null;
        }
    }

    @Commit
    private void afterDeserialization() throws Exception {
        if (this.otherAttributesForSerialization != null) {
            this.attributes.putAll(SimpleXmlWrappers.unwrap(this.otherAttributesForSerialization));
        }
        this.phrasesView = Collections.unmodifiableList(this.phrases);
        this.subclustersView = Collections.unmodifiableList(this.subclusters);
    }

    @JsonProperty(value="documents")
    private List<String> getDocumentIds() {
        return Lists.transform(this.documents, DOCUMENT_TO_ID);
    }

    @JsonProperty(value="attributes")
    private Map<String, Object> getOtherAttributes() {
        HashMap hashMap = Maps.newHashMap(this.attributesView);
        return hashMap.isEmpty() ? null : hashMap;
    }

    public String toString() {
        return "[Cluster, label: " + this.getLabel() + ", docs: " + this.size() + ", subclusters: " + this.getSubclusters().size() + "]";
    }

    @Root(name="document")
    static class DocumentRefid {
        @Attribute
        String refid;

        DocumentRefid() {
        }

        DocumentRefid(String string) {
            this.refid = string;
        }
    }
}

