/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.ComponentInitializationException;
import org.carrot2.core.ControllerContextImpl;
import org.carrot2.core.ControllerStatistics;
import org.carrot2.core.ControllerUtils;
import org.carrot2.core.Document;
import org.carrot2.core.HttpAuthHub;
import org.carrot2.core.IClusteringAlgorithm;
import org.carrot2.core.IDocumentSource;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.IProcessingComponentManager;
import org.carrot2.core.ProcessingComponentConfiguration;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.ProcessingResult;
import org.carrot2.core.SimpleProcessingComponentManager;
import org.carrot2.util.ReflectionUtils;
import org.carrot2.util.RollingWindowAverage;

public final class Controller
implements Closeable {
    private volatile boolean closed = false;
    private ControllerContextImpl context = new ControllerContextImpl();
    IProcessingComponentManager componentManager;
    private Map<String, Object> initAttributes;
    private Map<String, ProcessingComponentConfiguration> componentIdToConfiguration;
    private ProcessingStatistics statistics = new ProcessingStatistics();

    Controller() {
        this(new SimpleProcessingComponentManager());
    }

    public Controller(IProcessingComponentManager iProcessingComponentManager) {
        HttpAuthHub.setupAuthenticator();
        this.componentManager = iProcessingComponentManager;
    }

    public synchronized Controller init() throws ComponentInitializationException {
        return this.init((Map<String, Object>)ImmutableMap.of());
    }

    public synchronized Controller init(Map<String, Object> map) throws ComponentInitializationException {
        return this.init(map, new ProcessingComponentConfiguration[0]);
    }

    public synchronized Controller init(Map<String, Object> map, ProcessingComponentConfiguration ... processingComponentConfigurationArray) throws ComponentInitializationException {
        this.checkClosed();
        if (this.componentIdToConfiguration != null) {
            throw new IllegalStateException("This controller is already initialized.");
        }
        this.initAttributes = Collections.unmodifiableMap(Maps.newHashMap(map));
        this.componentIdToConfiguration = ProcessingComponentConfiguration.indexByComponentId(processingComponentConfigurationArray);
        this.componentManager.init(this.context, map, processingComponentConfigurationArray);
        return this;
    }

    public ProcessingResult process(String string, Integer n, Class<?> ... classArray) throws ProcessingException {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("query", string);
        if (n != null) {
            hashMap.put("results", n);
        }
        return this.process((Map<String, Object>)hashMap, classArray);
    }

    public ProcessingResult process(List<Document> list, String string, Class<?> ... classArray) throws ProcessingException {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("documents", list);
        if (StringUtils.isNotBlank((String)string)) {
            hashMap.put("query", string);
        }
        return this.process((Map<String, Object>)hashMap, classArray);
    }

    public ProcessingResult process(Map<String, Object> map, Class<?> ... classArray) throws ProcessingException {
        return this.process(map, (Object[])classArray);
    }

    public ProcessingResult process(Map<String, Object> map, String ... stringArray) throws ProcessingException {
        return this.process(map, (Object[])stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ProcessingResult process(Map<String, Object> var1_1, Object ... var2_2) throws ProcessingException {
        this.checkClosed();
        var3_3 = this;
        synchronized (this) {
            if (this.componentIdToConfiguration == null) {
                this.init();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            var3_3 = new IProcessingComponent[var2_2.length];
            var4_4 = new ProcessingComponentConfiguration[var3_3.length];
            var5_5 = null;
            try {
                var6_6 = Maps.newHashMap();
                var7_7 = 0;
                while (var7_7 < var2_2.length) {
                    var4_4[var7_7] = super.resolveComponent(var2_2[var7_7]);
                    var6_6.putAll(this.initAttributes);
                    var6_6.putAll(var4_4[var7_7].attributes);
                    var6_6.putAll(var1_1);
                    ++var7_7;
                }
                var7_8 = Maps.newHashMap(var1_1);
                var8_9 = Maps.newHashMap(var1_1);
                var9_10 = 0;
                while (var9_10 < var3_3.length) {
                    var3_3[var9_10] = this.componentManager.prepare(var4_4[var9_10].componentClass, var4_4[var9_10].componentId, var6_6, var8_9);
                    var10_12 = System.currentTimeMillis();
                    try {
                        ControllerUtils.performProcessing(var3_3[var9_10], var7_8, var8_9);
                        var7_8.putAll(var8_9);
                    }
                    finally {
                        var13_13 = System.currentTimeMillis();
                        var15_14 = var13_13 - var10_12;
                        if (IDocumentSource.class.isAssignableFrom(var4_4[var9_10].componentClass)) {
                            Controller.addTime("processing-time-source", var15_14, var8_9);
                        }
                        if (IClusteringAlgorithm.class.isAssignableFrom(var4_4[var9_10].componentClass)) {
                            Controller.addTime("processing-time-algorithm", var15_14, var8_9);
                        }
                        Controller.addTime("processing-time-total", var15_14, var8_9);
                    }
                    ++var9_10;
                }
                try {
                    var5_5 = new ProcessingResult(var8_9);
                }
                catch (IllegalArgumentException var9_11) {
                    throw new ProcessingException(var9_11);
                }
                var18_16 = var5_5;
                this.statistics.update(var5_5);
                var19_17 = 0;
                ** while (var19_17 < var3_3.length)
            }
            catch (Throwable var17_21) {
                this.statistics.update(var5_5);
                var19_18 = 0;
                ** while (var19_18 < var3_3.length)
            }
lbl-1000:
            // 1 sources

            {
                var20_19 = var3_3[var19_17];
                if (var20_19 != null) {
                    this.componentManager.recycle(var20_19, var4_4[var19_17].componentId);
                }
                ++var19_17;
                continue;
            }
lbl62:
            // 1 sources

            return var18_16;
lbl-1000:
            // 1 sources

            {
                var20_20 = var3_3[var19_18];
                if (var20_20 != null) {
                    this.componentManager.recycle(var20_20, var4_4[var19_18].componentId);
                }
                ++var19_18;
                continue;
            }
lbl72:
            // 1 sources

            throw var17_21;
        }
    }

    public void dispose() {
        if (this.closed) {
            return;
        }
        try {
            if (this.context != null) {
                this.componentManager.dispose();
                this.context.dispose();
                this.context = null;
            }
        }
        finally {
            this.closed = true;
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Controller closed.");
        }
    }

    private ProcessingComponentConfiguration resolveComponent(Object object) {
        Object object2;
        if (object instanceof String) {
            object2 = this.componentIdToConfiguration.get(object);
            if (object2 != null) {
                return object2;
            }
            try {
                object = ReflectionUtils.classForName((String)((String)object));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Unknown component id: " + object);
            }
        }
        if (object instanceof Class) {
            object2 = (Class)object;
            if (!IProcessingComponent.class.isAssignableFrom((Class<?>)object2)) {
                throw new IllegalArgumentException("Expected a Class<? extends " + IProcessingComponent.class.getSimpleName() + "> but got: " + ((Class)object2).getName());
            }
            return new ProcessingComponentConfiguration(((Class)object2).asSubclass(IProcessingComponent.class), null);
        }
        throw new IllegalArgumentException("Expected a String or a Class<? extends " + IProcessingComponent.class.getSimpleName() + ">");
    }

    private static void addTime(String string, Long l, Map<String, Object> map) {
        Long l2 = (Long)map.get(string);
        if (l2 == null) {
            map.put(string, l);
        } else {
            map.put(string, l2 + l);
        }
    }

    public ControllerStatistics getStatistics() {
        return this.statistics.getStatistics();
    }

    static interface IControllerStatisticsProvider {
        public Map<String, Object> getStatistics();
    }

    final class ProcessingStatistics {
        long totalQueries = 0L;
        long goodQueries = 0L;
        RollingWindowAverage sourceTimeAverage = new RollingWindowAverage(300000L, 10000L);
        RollingWindowAverage algorithmTimeAverage = new RollingWindowAverage(300000L, 10000L);
        RollingWindowAverage totalTimeAverage = new RollingWindowAverage(300000L, 10000L);

        ProcessingStatistics() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(ProcessingResult processingResult) {
            ProcessingStatistics processingStatistics = this;
            synchronized (processingStatistics) {
                ++this.totalQueries;
                if (processingResult != null) {
                    ++this.goodQueries;
                    Map<String, Object> map = processingResult.getAttributes();
                    this.addTimeToAverage(map, "processing-time-source", this.sourceTimeAverage);
                    this.addTimeToAverage(map, "processing-time-algorithm", this.algorithmTimeAverage);
                    this.addTimeToAverage(map, "processing-time-total", this.totalTimeAverage);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ControllerStatistics getStatistics() {
            Map<Object, Object> map = Controller.this.componentManager instanceof IControllerStatisticsProvider ? ((IControllerStatisticsProvider)((Object)Controller.this.componentManager)).getStatistics() : Collections.emptyMap();
            ProcessingStatistics processingStatistics = this;
            synchronized (processingStatistics) {
                return new ControllerStatistics(this.totalQueries, this.goodQueries, this.algorithmTimeAverage.getCurrentAverage(), this.algorithmTimeAverage.getUpdatesInWindow(), this.algorithmTimeAverage.getWindowSizeMillis(), this.sourceTimeAverage.getCurrentAverage(), this.sourceTimeAverage.getUpdatesInWindow(), this.sourceTimeAverage.getWindowSizeMillis(), this.totalTimeAverage.getCurrentAverage(), this.totalTimeAverage.getUpdatesInWindow(), this.totalTimeAverage.getWindowSizeMillis(), (Long)map.get("cache.misses"), (Long)map.get("cache.hits.total"));
            }
        }

        private void addTimeToAverage(Map<String, Object> map, String string, RollingWindowAverage rollingWindowAverage) {
            Long l = (Long)map.get(string);
            if (l != null) {
                rollingWindowAverage.add(System.currentTimeMillis(), l.longValue());
            }
        }
    }
}

