/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IControllerContextListener;
import org.slf4j.LoggerFactory;

final class ControllerContextImpl
implements IControllerContext {
    private final ArrayList<IControllerContextListener> listeners = Lists.newArrayList();
    private final HashMap<String, Object> attributes = Maps.newHashMap();

    ControllerContextImpl() {
    }

    @Override
    public synchronized Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    @Override
    public synchronized void setAttribute(String string, Object object) {
        this.attributes.put(string, object);
    }

    @Override
    public synchronized void removeListener(IControllerContextListener iControllerContextListener) {
        this.listeners.remove(iControllerContextListener);
    }

    @Override
    public synchronized void addListener(IControllerContextListener iControllerContextListener) {
        this.listeners.add(iControllerContextListener);
    }

    public synchronized void dispose() {
        for (IControllerContextListener iControllerContextListener : this.listeners) {
            try {
                iControllerContextListener.beforeDisposal(this);
            }
            catch (Throwable throwable) {
                LoggerFactory.getLogger(ControllerContextImpl.class).warn("Unhandled exception in context listener.", throwable);
            }
        }
        this.listeners.clear();
        this.attributes.clear();
    }
}

