/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import org.carrot2.core.CachingProcessingComponentManager;
import org.carrot2.core.Controller;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.IProcessingComponentManager;
import org.carrot2.core.PoolingProcessingComponentManager;
import org.carrot2.core.SimpleProcessingComponentManager;
import org.carrot2.util.annotations.AspectModified;
import org.carrot2.util.pool.FixedSizePool;
import org.carrot2.util.pool.IParameterizedPool;

public final class ControllerFactory {
    private ControllerFactory() {
    }

    public static Controller createSimple() {
        return ControllerFactory.create(false, new Class[0]);
    }

    public static Controller createPooling() {
        return ControllerFactory.create(true, new Class[0]);
    }

    public static Controller createPooling(int n) {
        return ControllerFactory.create(n, new Class[0]);
    }

    public static Controller createCaching(Class<? extends IProcessingComponent> ... classArray) {
        return ControllerFactory.create(false, classArray);
    }

    public static Controller createCachingPooling(Class<? extends IProcessingComponent> ... classArray) {
        return ControllerFactory.create(true, classArray);
    }

    public static Controller create(boolean bl, Class<? extends IProcessingComponent> ... classArray) {
        IProcessingComponentManager iProcessingComponentManager = bl ? new PoolingProcessingComponentManager() : new SimpleProcessingComponentManager();
        return new Controller(ControllerFactory.addCachingManager(iProcessingComponentManager, classArray));
    }

    public static Controller create(int n, Class<? extends IProcessingComponent> ... classArray) {
        if (n <= 0) {
            throw new IllegalArgumentException("Instance pool size must be greater than zero: " + n);
        }
        PoolingProcessingComponentManager poolingProcessingComponentManager = new PoolingProcessingComponentManager((IParameterizedPool<IProcessingComponent, String>)new FixedSizePool(n));
        return new Controller(ControllerFactory.addCachingManager(poolingProcessingComponentManager, classArray));
    }

    @AspectModified(value="Throws an exception in .NET")
    private static IProcessingComponentManager addCachingManager(IProcessingComponentManager iProcessingComponentManager, Class<? extends IProcessingComponent> ... classArray) {
        if (classArray.length == 0) {
            return iProcessingComponentManager;
        }
        return new CachingProcessingComponentManager(iProcessingComponentManager, classArray);
    }
}

