/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.carrot2.core.ComponentInitializationException;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.util.attribute.AttributeBinder;
import org.carrot2.util.attribute.AttributeBindingException;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;

final class ControllerUtils {
    private ControllerUtils() {
    }

    public static void init(IProcessingComponent iProcessingComponent, Map<String, Object> map, Map<String, Object> map2, boolean bl, IControllerContext iControllerContext) throws ComponentInitializationException {
        try {
            AttributeBinder.set((Object)iProcessingComponent, map, (boolean)bl, (Class[])new Class[]{Input.class, Init.class});
            iProcessingComponent.init(iControllerContext);
            AttributeBinder.get((Object)iProcessingComponent, map2, (Class[])new Class[]{Output.class, Init.class});
        }
        catch (InstantiationException instantiationException) {
            throw new ComponentInitializationException("Attribute binding failed", instantiationException);
        }
    }

    public static void beforeProcessing(IProcessingComponent iProcessingComponent, Map<String, Object> map) throws ProcessingException {
        try {
            if (iProcessingComponent.getClass().getAnnotation(Bindable.class) != null) {
                AttributeBinder.set((Object)iProcessingComponent, map, (Class[])new Class[]{Input.class, Processing.class});
            }
            iProcessingComponent.beforeProcessing();
        }
        catch (InstantiationException instantiationException) {
            throw new ProcessingException("Attribute binding failed: " + instantiationException.getMessage(), instantiationException);
        }
        catch (AttributeBindingException attributeBindingException) {
            throw new ProcessingException("Attribute binding failed: " + attributeBindingException.getMessage(), attributeBindingException);
        }
    }

    public static void performProcessing(IProcessingComponent iProcessingComponent, Map<String, Object> map, Map<String, Object> map2) {
        try {
            ControllerUtils.beforeProcessing(iProcessingComponent, map);
            iProcessingComponent.process();
        }
        finally {
            ControllerUtils.afterProcessing(iProcessingComponent, map2);
        }
    }

    public static void afterProcessing(IProcessingComponent iProcessingComponent, Map<String, Object> map) {
        try {
            iProcessingComponent.afterProcessing();
            HashMap hashMap = Maps.newHashMap();
            if (iProcessingComponent.getClass().getAnnotation(Bindable.class) != null) {
                AttributeBinder.get((Object)iProcessingComponent, (Map)hashMap, (Class[])new Class[]{Output.class, Processing.class});
            }
            map.putAll(Maps.filterValues((Map)hashMap, (Predicate)Predicates.notNull()));
        }
        catch (InstantiationException instantiationException) {
            throw new ProcessingException("Attribute binding failed", instantiationException);
        }
    }
}

