/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.LanguageCode;
import org.carrot2.util.MapUtils;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;

@Root(name="document")
@JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Document
implements Cloneable {
    public static final String TITLE = "title";
    public static final String SUMMARY = "snippet";
    public static final String CONTENT_URL = "url";
    public static final String CLICK_URL = "click-url";
    public static final String THUMBNAIL_URL = "thumbnail-url";
    public static final String SIZE = "size";
    public static final String SCORE = "score";
    public static final String SOURCES = "sources";
    public static final String LANGUAGE = "language";
    public static final String PARTITIONS = "partitions";
    private final Map<String, Object> fields = Maps.newHashMap();
    private final Map<String, Object> fieldsView = Collections.unmodifiableMap(this.fields);
    @Attribute(required=false)
    String id;
    private ArrayList<IDocumentSerializationListener> serializationListeners;
    public static final Comparator<Document> BY_ID_COMPARATOR = Ordering.natural().nullsFirst().onResultOf((Function)DocumentToId.INSTANCE);

    public Document() {
    }

    public Document(String string) {
        this(string, null);
    }

    public Document(String string, String string2) {
        this(string, string2, (String)null);
    }

    public Document(String string, String string2, LanguageCode languageCode) {
        this(string, string2, null, languageCode);
    }

    public Document(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public Document(String string, String string2, String string3, LanguageCode languageCode) {
        this.setField(TITLE, string);
        this.setField(SUMMARY, string2);
        if (StringUtils.isNotBlank((String)string3)) {
            this.setField(CONTENT_URL, string3);
        }
        if (languageCode != null) {
            this.setField(LANGUAGE, (Object)languageCode);
        }
    }

    public Document(String string, String string2, String string3, LanguageCode languageCode, String string4) {
        this(string, string2, string3, languageCode);
        this.id = string4;
    }

    public Integer getId() {
        try {
            return this.id != null ? Integer.valueOf(Integer.parseInt(this.id)) : null;
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Could not parse document identifier as an integer: " + this.id);
        }
    }

    @JsonProperty(value="id")
    public String getStringId() {
        return this.id;
    }

    @JsonProperty
    @Element(required=false)
    public String getTitle() {
        return (String)this.getField(TITLE);
    }

    @Element(required=false)
    public Document setTitle(String string) {
        return this.setField(TITLE, string);
    }

    @JsonProperty(value="snippet")
    @Element(name="snippet", required=false)
    public String getSummary() {
        return (String)this.getField(SUMMARY);
    }

    @Element(name="snippet", required=false)
    public Document setSummary(String string) {
        return this.setField(SUMMARY, string);
    }

    @JsonProperty(value="url")
    @Element(name="url", required=false)
    public String getContentUrl() {
        return (String)this.getField(CONTENT_URL);
    }

    @Element(name="url", required=false)
    public Document setContentUrl(String string) {
        return this.setField(CONTENT_URL, string);
    }

    @JsonProperty
    @ElementList(entry="source", required=false)
    public List<String> getSources() {
        return (List)this.getField(SOURCES);
    }

    @ElementList(entry="source", required=false)
    public Document setSources(List<String> list) {
        return this.setField(SOURCES, list);
    }

    public LanguageCode getLanguage() {
        return (LanguageCode)((Object)this.getField(LANGUAGE));
    }

    public Document setLanguage(LanguageCode languageCode) {
        return this.setField(LANGUAGE, (Object)languageCode);
    }

    @Attribute(name="score", required=false)
    public Double getScore() {
        return (Double)this.getField(SCORE);
    }

    @Attribute(name="score", required=false)
    public Document setScore(Double d) {
        return this.setField(SCORE, d);
    }

    @JsonProperty(value="language")
    @Attribute(required=false, name="language")
    private String getLanguageIsoCode() {
        LanguageCode languageCode = this.getLanguage();
        return languageCode != null ? languageCode.getIsoCode() : null;
    }

    @Attribute(required=false, name="language")
    private void setLanguageIsoCode(String string) {
        if (string != null) {
            LanguageCode languageCode = LanguageCode.forISOCode(string);
            if (languageCode != null) {
                this.setLanguage(languageCode);
            } else {
                this.setLanguage(LanguageCode.valueOf(string));
            }
        } else {
            this.setLanguage(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonProperty(value="fields")
    private Map<String, Object> getOtherFields() {
        HashMap hashMap;
        Document document = this;
        synchronized (document) {
            hashMap = Maps.newHashMap(this.fields);
        }
        hashMap.remove(TITLE);
        hashMap.remove(SUMMARY);
        hashMap.remove(CONTENT_URL);
        hashMap.remove(SOURCES);
        hashMap.remove(LANGUAGE);
        hashMap.remove(SCORE);
        this.fireSerializationListeners(hashMap);
        return hashMap.isEmpty() ? null : hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ElementMap(entry="field", key="key", attribute=true, inline=true, required=false)
    private HashMap<String, SimpleXmlWrapperValue> getOtherFieldsXml() {
        HashMap hashMap;
        Document document = this;
        synchronized (document) {
            hashMap = MapUtils.asHashMap((Map)SimpleXmlWrappers.wrap(this.fields));
        }
        hashMap.remove(TITLE);
        hashMap.remove(SUMMARY);
        hashMap.remove(CONTENT_URL);
        hashMap.remove(SOURCES);
        hashMap.remove(LANGUAGE);
        hashMap.remove(SCORE);
        this.fireSerializationListeners(hashMap);
        return hashMap.isEmpty() ? null : hashMap;
    }

    @ElementMap(entry="field", key="key", attribute=true, inline=true, required=false)
    private void setOtherFieldsXml(HashMap<String, SimpleXmlWrapperValue> hashMap) {
        if (hashMap != null) {
            this.fields.putAll(SimpleXmlWrappers.unwrap(hashMap));
        }
    }

    public Map<String, Object> getFields() {
        return this.fieldsView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getField(String string) {
        Document document = this;
        synchronized (document) {
            return (T)this.fields.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document setField(String string, Object object) {
        Document document = this;
        synchronized (document) {
            this.fields.put(string, object);
        }
        return this;
    }

    public Document clone() {
        Document document = new Document();
        document.id = this.id;
        document.fields.putAll(this.fields);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void assignDocumentIds(Collection<Document> collection) {
        Collection<Document> collection2 = collection;
        synchronized (collection2) {
            boolean bl = false;
            for (Document document : collection) {
                if (document.id == null) continue;
                bl = true;
                break;
            }
            if (bl) {
                HashSet hashSet = Sets.newHashSet();
                for (Document document : collection) {
                    String string = document.getStringId();
                    if (hashSet.add(string) || string == null) continue;
                    throw new IllegalArgumentException("Identifiers must be unique, duplicated identifier: " + string + " [existing: " + hashSet.toString() + "]");
                }
                if (hashSet.contains(null)) {
                    throw new IllegalArgumentException("Null identifiers cannot be mixed with existing non-null identifiers:  [existing: " + hashSet.toString() + "]");
                }
            } else {
                boolean bl2 = false;
                for (Document document : collection) {
                    void var3_11;
                    document.id = Integer.toString((int)var3_11);
                    ++var3_11;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSerializationListener(IDocumentSerializationListener iDocumentSerializationListener) {
        Document document = this;
        synchronized (document) {
            if (this.serializationListeners == null) {
                this.serializationListeners = Lists.newArrayList();
            }
            this.serializationListeners.add(iDocumentSerializationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSerializationListeners(Map<String, ?> map) {
        Document document = this;
        synchronized (document) {
            if (this.serializationListeners != null) {
                for (IDocumentSerializationListener iDocumentSerializationListener : this.serializationListeners) {
                    iDocumentSerializationListener.beforeSerialization(this, map);
                }
            }
        }
    }

    public static final class DocumentToId
    implements Function<Document, Integer> {
        public static final DocumentToId INSTANCE = new DocumentToId();

        private DocumentToId() {
        }

        public Integer apply(Document document) {
            return document.getId();
        }
    }

    public static interface IDocumentSerializationListener {
        public void beforeSerialization(Document var1, Map<String, ?> var2);
    }
}

