/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.concurrent.atomic.AtomicBoolean;

public final class HttpAuthHub {
    public static final String USERNAME_PROPERTY = "http.auth.username";
    public static final String PASSWORD_PROPERTY = "http.auth.password";
    public static final AtomicBoolean once = new AtomicBoolean(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void setupAuthenticator() {
        if (System.getProperty(USERNAME_PROPERTY) == null && System.getProperty(PASSWORD_PROPERTY) == null) return;
        Class<HttpAuthHub> clazz = HttpAuthHub.class;
        synchronized (HttpAuthHub.class) {
            if (!once.getAndSet(false)) return;
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(HttpAuthHub.getUser(), HttpAuthHub.getPassword());
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String getUser() {
        return System.getProperty(USERNAME_PROPERTY, null);
    }

    public static char[] getPassword() {
        String string = System.getProperty(PASSWORD_PROPERTY, null);
        return string == null ? null : string.toCharArray();
    }
}

