/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.carrot2.util.StringUtils;

public enum LanguageCode {
    ARABIC("ar"),
    BULGARIAN("bg"),
    CZECH("cz"),
    CHINESE_SIMPLIFIED("zh_cn"),
    CROATIAN("hr"),
    DANISH("da"),
    DUTCH("nl"),
    ENGLISH("en"),
    ESTONIAN("ee"),
    FINNISH("fi"),
    FRENCH("fr"),
    GERMAN("de"),
    GREEK("gr"),
    HUNGARIAN("hu"),
    HINDI("hi"),
    ITALIAN("it"),
    IRISH("ie"),
    JAPANESE("ja"),
    KOREAN("ko"),
    LATVIAN("lv"),
    LITHUANIAN("lt"),
    MALTESE("mt"),
    NORWEGIAN("no"),
    POLISH("pl"),
    PORTUGUESE("pt"),
    ROMANIAN("ro"),
    RUSSIAN("ru"),
    SLOVAK("sk"),
    SLOVENE("sl"),
    SPANISH("es"),
    SWEDISH("sv"),
    THAI("th"),
    TURKISH("tr");

    private final String isoCode;
    private final Locale locale;
    private static final Map<String, LanguageCode> isoToLangCode;
    private static final Set<LanguageCode> noSpaceLanguages;

    static {
        isoToLangCode = Maps.newHashMap();
        LanguageCode[] languageCodeArray = LanguageCode.values();
        int n = languageCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageCode languageCode = languageCodeArray[n2];
            isoToLangCode.put(languageCode.getIsoCode(), languageCode);
            ++n2;
        }
        noSpaceLanguages = EnumSet.of(CHINESE_SIMPLIFIED, JAPANESE);
    }

    private LanguageCode(String string2) {
        this.isoCode = string2;
        this.locale = new Locale(string2);
    }

    public String getIsoCode() {
        return this.isoCode;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static LanguageCode forISOCode(String string) {
        string = string.toLowerCase();
        return isoToLangCode.get(string);
    }

    public boolean usesSpaceDelimiters() {
        return !noSpaceLanguages.contains((Object)this);
    }

    public String toString() {
        return StringUtils.identifierToHumanReadable((String)this.name());
    }
}

