/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.carrot2.core.ComponentInitializationException;
import org.carrot2.core.ControllerUtils;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.IProcessingComponentManager;
import org.carrot2.core.ProcessingComponentConfiguration;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.ReferenceEquality;
import org.carrot2.core.attribute.Init;
import org.carrot2.core.attribute.Processing;
import org.carrot2.util.ExceptionUtils;
import org.carrot2.util.Pair;
import org.carrot2.util.annotations.ThreadSafe;
import org.carrot2.util.attribute.AttributeBinder;
import org.carrot2.util.attribute.AttributeBindingException;
import org.carrot2.util.attribute.BindableUtils;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.pool.IActivationListener;
import org.carrot2.util.pool.IDisposalListener;
import org.carrot2.util.pool.IInstantiationListener;
import org.carrot2.util.pool.IParameterizedPool;
import org.carrot2.util.pool.IPassivationListener;
import org.carrot2.util.pool.SoftUnboundedPool;
import org.carrot2.util.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolingProcessingComponentManager
implements IProcessingComponentManager {
    private IControllerContext context;
    private volatile IParameterizedPool<IProcessingComponent, String> componentPool;
    private Map<String, Object> initAttributes;
    private Map<String, ProcessingComponentConfiguration> componentIdToConfiguration;
    private ConcurrentHashMap<Pair<Class<? extends IProcessingComponent>, String>, Map<String, Object>> initOutputAttributes = new ConcurrentHashMap();

    public PoolingProcessingComponentManager() {
        this((IParameterizedPool<IProcessingComponent, String>)new SoftUnboundedPool());
    }

    public PoolingProcessingComponentManager(IParameterizedPool<IProcessingComponent, String> iParameterizedPool) {
        this.componentPool = iParameterizedPool;
        ComponentResetListener componentResetListener = new ComponentResetListener();
        iParameterizedPool.init((IInstantiationListener)new ComponentInstantiationListener(), (IActivationListener)componentResetListener, (IPassivationListener)componentResetListener, (IDisposalListener)ComponentDisposalListener.INSTANCE);
    }

    @Override
    public void init(IControllerContext iControllerContext, Map<String, Object> map, ProcessingComponentConfiguration ... processingComponentConfigurationArray) {
        assert (iControllerContext != null);
        if (this.context != null) {
            throw new IllegalStateException("This manager has already been initialized.");
        }
        this.context = iControllerContext;
        this.initAttributes = Maps.newHashMap(map);
        this.componentIdToConfiguration = ProcessingComponentConfiguration.indexByComponentId(processingComponentConfigurationArray);
    }

    @Override
    public IProcessingComponent prepare(Class<? extends IProcessingComponent> clazz, String string, Map<String, Object> map, Map<String, Object> map2) {
        try {
            IProcessingComponent iProcessingComponent = (IProcessingComponent)this.componentPool.borrowObject(clazz, (Object)string);
            Map<String, Object> map3 = this.initOutputAttributes.get(new Pair(iProcessingComponent.getClass(), (Object)string));
            if (map3 != null) {
                map2.putAll(map3);
            }
            return iProcessingComponent;
        }
        catch (InstantiationException instantiationException) {
            throw new ComponentInitializationException("Could not instantiate component class: " + clazz.getName(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ComponentInitializationException("Could not instantiate component class: " + clazz.getName(), illegalAccessException);
        }
    }

    @Override
    public void recycle(IProcessingComponent iProcessingComponent, String string) {
        this.componentPool.returnObject((Object)iProcessingComponent, (Object)string);
    }

    @Override
    public void dispose() {
        this.componentPool.dispose();
    }

    private static final class ComponentDisposalListener
    implements IDisposalListener<IProcessingComponent, String> {
        static final ComponentDisposalListener INSTANCE = new ComponentDisposalListener();

        private ComponentDisposalListener() {
        }

        public void dispose(IProcessingComponent iProcessingComponent, String string) {
            iProcessingComponent.dispose();
        }
    }

    private final class ComponentInstantiationListener
    implements IInstantiationListener<IProcessingComponent, String> {
        private ComponentInstantiationListener() {
        }

        public void objectInstantiated(IProcessingComponent iProcessingComponent, String string) {
            try {
                HashMap hashMap = Maps.newHashMap((Map)PoolingProcessingComponentManager.this.initAttributes);
                if (string != null) {
                    hashMap.putAll(((ProcessingComponentConfiguration)((PoolingProcessingComponentManager)PoolingProcessingComponentManager.this).componentIdToConfiguration.get((Object)string)).attributes);
                }
                HashMap hashMap2 = Maps.newHashMap();
                this.checkNonPrimitiveInstances(iProcessingComponent, hashMap, (Predicate<Field>)new AttributeBinder.AllAnnotationsPresentPredicate(new Class[]{Input.class, Init.class}));
                ControllerUtils.init(iProcessingComponent, hashMap, hashMap2, false, PoolingProcessingComponentManager.this.context);
                PoolingProcessingComponentManager.this.initOutputAttributes.putIfAbsent(new Pair(iProcessingComponent.getClass(), (Object)string), Collections.unmodifiableMap(Maps.newHashMap((Map)hashMap2)));
                try {
                    Predicate<Field> predicate = new Predicate<Field>(){

                        public boolean apply(Field field) {
                            return field.getAnnotation(Input.class) != null && field.getAnnotation(Processing.class) != null && field.getAnnotation(Init.class) == null;
                        }
                    };
                    this.checkNonPrimitiveInstances(iProcessingComponent, hashMap, predicate);
                    AttributeBinder.set((Object)iProcessingComponent, (Map)hashMap, (boolean)false, (Predicate)predicate);
                }
                catch (AttributeBindingException attributeBindingException) {
                    throw new ComponentInitializationException("Could not initialize component", attributeBindingException);
                }
                catch (InstantiationException instantiationException) {
                    throw new ComponentInitializationException("Could not initialize component", instantiationException);
                }
            }
            catch (Exception exception) {
                iProcessingComponent.dispose();
                throw (ComponentInitializationException)ExceptionUtils.wrapAs(ComponentInitializationException.class, (Throwable)exception);
            }
        }

        void checkNonPrimitiveInstances(IProcessingComponent iProcessingComponent, Map<String, Object> map, Predicate<Field> predicate) throws InstantiationException {
            AttributeBinder.bind((Object)iProcessingComponent, (AttributeBinder.IAttributeBinderAction[])new AttributeBinder.IAttributeBinderAction[]{new NonPrimitiveInputAttributesCheck(map)}, predicate);
        }
    }

    private static final class ComponentResetListener
    implements IPassivationListener<IProcessingComponent, String>,
    IActivationListener<IProcessingComponent, String> {
        private ConcurrentHashMap<ReferenceEquality, Map<String, Object>> resetValues = new ConcurrentHashMap();

        private ComponentResetListener() {
        }

        public void activate(IProcessingComponent iProcessingComponent, String string) {
            HashMap hashMap = Maps.newHashMap();
            try {
                AttributeBinder.get((Object)iProcessingComponent, (Map)hashMap, (Class[])new Class[]{Input.class, Processing.class});
                this.resetValues.put(new ReferenceEquality(iProcessingComponent), hashMap);
            }
            catch (Exception exception) {
                throw new ProcessingException("Could not unbind attribute values", exception);
            }
        }

        public void passivate(IProcessingComponent iProcessingComponent, String string) {
            try {
                Map<String, Object> map = this.resetValues.get(new ReferenceEquality(iProcessingComponent));
                if (map != null) {
                    AttributeBinder.set((Object)iProcessingComponent, map, (boolean)false, (Class[])new Class[]{Input.class, Processing.class});
                }
            }
            catch (Exception exception) {
                throw new ProcessingException("Could not reset attribute values", exception);
            }
        }
    }

    static final class NonPrimitiveInputAttributesCheck
    implements AttributeBinder.IAttributeBinderAction {
        static boolean makeAssertion = false;
        private static final Logger log = LoggerFactory.getLogger(NonPrimitiveInputAttributesCheck.class);
        static final Set<Class<?>> ALLOWED_PLAIN_TYPES = ImmutableSet.of(Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, (Object[])new Class[]{Double.class, Character.class, File.class, String.class, Calendar.class, Date.class});
        static final Set<Class<?>> ALLOWED_ASSIGNABLE_TYPES = ImmutableSet.of(Enum.class, IResource.class, Collection.class, Map.class);
        static final Set<String> ALLOWED_PLAIN_TYPES_BY_NAME = ImmutableSet.of((Object)"org.apache.lucene.store.FSDirectory", (Object)"org.apache.lucene.store.RAMDirectory", (Object)"org.apache.lucene.store.MMapDirectory", (Object)"org.apache.lucene.store.SimpleFSDirectory", (Object)"org.apache.lucene.store.SimpleFSDirectory");
        private final Map<String, Object> values;

        NonPrimitiveInputAttributesCheck(Map<String, Object> map) {
            this.values = map;
        }

        public void performAction(AttributeBinder.BindingTracker bindingTracker, int n, Object object, Field field, Object object2, Predicate<Field> predicate) throws InstantiationException {
            String string = BindableUtils.getKey((Field)field);
            Object object3 = this.values.get(string);
            if (object3 == null || Class.class.isInstance(object3) || Proxy.isProxyClass(object3.getClass()) || object3.getClass().getAnnotation(ThreadSafe.class) != null) {
                return;
            }
            Class<?> clazz = object3.getClass();
            if (!(ALLOWED_PLAIN_TYPES.contains(clazz) || ALLOWED_PLAIN_TYPES_BY_NAME.contains(clazz.getName()) || NonPrimitiveInputAttributesCheck.isAllowedAssignableType(clazz))) {
                log.info("An object of a non-@ThreadSafe class " + clazz.getName() + " bound at initialization-time to attribute " + string + ". Make sure this is intended.");
                if (makeAssertion) assert (false) : "An object of a non-@ThreadSafe class " + clazz.getName() + " bound at initialization-time to attribute " + string + ". Make sure this intended.";
            }
        }

        private static boolean isAllowedAssignableType(Class<?> clazz) {
            for (Class<?> clazz2 : ALLOWED_ASSIGNABLE_TYPES) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }
    }
}

