/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import java.util.concurrent.ExecutorService;
import org.carrot2.core.ExecutorServiceShutdownListener;
import org.carrot2.core.IControllerContext;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.ProcessingException;
import org.carrot2.util.ExecutorServiceUtils;

public abstract class ProcessingComponentBase
implements IProcessingComponent {
    private IControllerContext context;

    @Override
    public void init(IControllerContext iControllerContext) {
        this.context = iControllerContext;
    }

    @Override
    public void beforeProcessing() throws ProcessingException {
    }

    @Override
    public void process() throws ProcessingException {
    }

    @Override
    public void afterProcessing() {
    }

    protected final IControllerContext getContext() {
        if (this.context == null) {
            throw new IllegalStateException("Context not available (check if you call super.init(ControllerContext)).");
        }
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutorService getSharedExecutor(int n, Class<?> clazz) {
        IControllerContext iControllerContext;
        IControllerContext iControllerContext2 = iControllerContext = this.getContext();
        synchronized (iControllerContext2) {
            String string = String.valueOf(clazz.getName()) + ".executorService";
            ExecutorService executorService = (ExecutorService)iControllerContext.getAttribute(string);
            if (executorService == null) {
                executorService = ExecutorServiceUtils.createExecutorService((int)n, clazz);
                iControllerContext.setAttribute(string, executorService);
                iControllerContext.addListener(new ExecutorServiceShutdownListener(string));
            }
            return executorService;
        }
    }

    @Override
    public void dispose() {
    }
}

