/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.carrot2.core.IProcessingComponent;

public class ProcessingComponentConfiguration {
    public final Class<? extends IProcessingComponent> componentClass;
    public final String componentId;
    public final Map<String, Object> attributes;

    public ProcessingComponentConfiguration(Class<? extends IProcessingComponent> clazz, String string, Map<String, Object> map) {
        this.componentClass = clazz;
        this.componentId = string;
        this.attributes = Collections.unmodifiableMap(Maps.newHashMap(map));
    }

    public ProcessingComponentConfiguration(Class<? extends IProcessingComponent> clazz, String string) {
        this(clazz, string, Collections.emptyMap());
    }

    static Map<String, ProcessingComponentConfiguration> indexByComponentId(ProcessingComponentConfiguration ... processingComponentConfigurationArray) {
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)processingComponentConfigurationArray.length);
        ProcessingComponentConfiguration[] processingComponentConfigurationArray2 = processingComponentConfigurationArray;
        int n = processingComponentConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessingComponentConfiguration processingComponentConfiguration = processingComponentConfigurationArray2[n2];
            if (hashMap.put(processingComponentConfiguration.componentId, processingComponentConfiguration) != null) {
                throw new IllegalArgumentException("Duplicate processing component id: " + processingComponentConfiguration.componentId);
            }
            ++n2;
        }
        return Collections.unmodifiableMap(hashMap);
    }
}

