/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.carrot2.core.ControllerContextImpl;
import org.carrot2.core.IProcessingComponent;
import org.carrot2.core.ProcessingComponentConfiguration;
import org.carrot2.core.attribute.Init;
import org.carrot2.util.CloseableUtils;
import org.carrot2.util.ReflectionUtils;
import org.carrot2.util.attribute.AttributeBinder;
import org.carrot2.util.attribute.AttributeValueSet;
import org.carrot2.util.attribute.AttributeValueSets;
import org.carrot2.util.attribute.BindableDescriptor;
import org.carrot2.util.attribute.BindableDescriptorBuilder;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.ResourceLookup;
import org.carrot2.util.simplexml.PersisterHelpers;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.core.Commit;
import org.slf4j.LoggerFactory;

public class ProcessingComponentDescriptor {
    @Attribute(name="component-class")
    private String componentClassName;
    private Class<? extends IProcessingComponent> componentClass;
    private Throwable initializationException;
    @Attribute
    private String id;
    @Element
    private String label;
    @Element(required=false)
    private String mnemonic;
    @Element
    private String title;
    @Element(required=false, name="icon-path")
    private String iconPath;
    @Element(required=false)
    private String description;
    private AttributeValueSets attributeSets;
    @Attribute(name="attribute-sets-resource", required=false)
    private String attributeSetsResource;
    @Attribute(name="attribute-set-id", required=false)
    private String attributeSetId;
    private BindableDescriptor bindableDescriptor;

    ProcessingComponentDescriptor() {
    }

    public ProcessingComponentConfiguration getComponentConfiguration() {
        return new ProcessingComponentConfiguration(this.getComponentClass(), this.id, this.getAttributes());
    }

    private Map<String, Object> getAttributes() {
        Map map = AttributeValueSet.getAttributeValues((AttributeValueSet)this.getAttributeSets().getAttributeValueSet(this.attributeSetId, true));
        if (map == null) {
            map = Maps.newHashMap();
        }
        return map;
    }

    public synchronized Class<? extends IProcessingComponent> getComponentClass() {
        if (this.componentClass == null) {
            try {
                this.componentClass = ReflectionUtils.classForName((String)this.componentClassName);
            }
            catch (Exception exception) {
                throw new RuntimeException("Component class cannot be acquired: " + this.componentClassName, exception);
            }
        }
        return this.componentClass;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMnemonic() {
        return this.mnemonic;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAttributeSetsResource() {
        return this.attributeSetsResource;
    }

    public AttributeValueSets getAttributeSets() {
        return this.attributeSets;
    }

    public String getAttributeSetId() {
        return this.attributeSetId;
    }

    private IProcessingComponent newInitializedInstance() throws InstantiationException, IllegalAccessException {
        IProcessingComponent iProcessingComponent = this.getComponentClass().newInstance();
        HashMap hashMap = Maps.newHashMap();
        AttributeValueSet attributeValueSet = this.attributeSets.getDefaultAttributeValueSet();
        if (attributeValueSet != null) {
            hashMap.putAll(attributeValueSet.getAttributeValues());
        }
        ControllerContextImpl controllerContextImpl = new ControllerContextImpl();
        try {
            AttributeBinder.set((Object)iProcessingComponent, (Map)hashMap, (boolean)false, (Class[])new Class[]{Input.class});
            try {
                iProcessingComponent.init(controllerContextImpl);
            }
            catch (Throwable throwable) {}
            AttributeBinder.get((Object)iProcessingComponent, (Map)hashMap, (Class[])new Class[]{Output.class, Init.class});
        }
        finally {
            controllerContextImpl.dispose();
        }
        return iProcessingComponent;
    }

    public BindableDescriptor getBindableDescriptor() {
        if (this.bindableDescriptor == null) {
            throw new RuntimeException("Descriptor not available.", this.initializationException);
        }
        return this.bindableDescriptor;
    }

    public boolean isComponentAvailable() {
        return this.initializationException == null;
    }

    public Throwable getInitializationFailure() {
        return this.initializationException;
    }

    private void loadAttributeSets(ResourceLookup resourceLookup) throws Exception {
        this.attributeSets = new AttributeValueSets();
        IResource iResource = null;
        if (!StringUtils.isBlank((String)this.attributeSetsResource) && (iResource = resourceLookup.getFirst(this.attributeSetsResource)) == null) {
            throw new IOException("Attribute set resource not found: " + this.attributeSetsResource);
        }
        if (iResource != null) {
            InputStream inputStream = iResource.open();
            try {
                this.attributeSets = AttributeValueSets.deserialize((InputStream)inputStream);
            }
            finally {
                CloseableUtils.close((Closeable)inputStream);
            }
        }
        if (this.getAttributeSets() == null) {
            this.attributeSets = new AttributeValueSets();
        }
    }

    @Commit
    private void onCommit(Map<Object, Object> map) {
        this.initializationException = null;
        try {
            ResourceLookup resourceLookup = PersisterHelpers.getResourceLookup(map);
            this.loadAttributeSets(resourceLookup);
            this.bindableDescriptor = BindableDescriptorBuilder.buildDescriptor((Object)this.newInitializedInstance());
        }
        catch (Throwable throwable) {
            LoggerFactory.getLogger(this.getClass()).warn("Component unavailable: " + this.componentClassName, throwable);
            this.initializationException = throwable;
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static final class ProcessingComponentDescriptorToId
    implements Function<ProcessingComponentDescriptor, String> {
        public static final ProcessingComponentDescriptorToId INSTANCE = new ProcessingComponentDescriptorToId();

        private ProcessingComponentDescriptorToId() {
        }

        public String apply(ProcessingComponentDescriptor processingComponentDescriptor) {
            return processingComponentDescriptor.id;
        }
    }
}

