/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.carrot2.core.DocumentSourceDescriptor;
import org.carrot2.core.ProcessingComponentConfiguration;
import org.carrot2.core.ProcessingComponentDescriptor;
import org.carrot2.core.ProcessingComponentSuiteInclude;
import org.carrot2.util.CloseableUtils;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.ResourceLookup;
import org.carrot2.util.simplexml.PersisterHelpers;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;
import org.simpleframework.xml.strategy.TreeStrategy;

@Root(name="component-suite")
public class ProcessingComponentSuite {
    @ElementList(inline=true, required=false, entry="include")
    ArrayList<ProcessingComponentSuiteInclude> includes;
    @ElementList(name="sources", entry="source", required=false)
    private ArrayList<DocumentSourceDescriptor> sources;
    @ElementList(name="algorithms", entry="algorithm", required=false)
    private ArrayList<ProcessingComponentDescriptor> algorithms;
    @ElementList(name="components", entry="component", required=false)
    private ArrayList<ProcessingComponentDescriptor> otherComponents;

    public ProcessingComponentSuite() {
    }

    public ProcessingComponentSuite(ArrayList<DocumentSourceDescriptor> arrayList, ArrayList<ProcessingComponentDescriptor> arrayList2) {
        this.algorithms = arrayList2;
        this.sources = arrayList;
        this.otherComponents = Lists.newArrayList();
    }

    public List<DocumentSourceDescriptor> getSources() {
        return this.sources;
    }

    public List<ProcessingComponentDescriptor> getAlgorithms() {
        return this.algorithms;
    }

    public List<ProcessingComponentDescriptor> getOtherComponents() {
        return this.otherComponents;
    }

    public List<ProcessingComponentDescriptor> getComponents() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.sources, this.algorithms, this.otherComponents));
    }

    @Commit
    private void postDeserialize(Map<Object, Object> map) throws Exception {
        if (this.sources == null) {
            this.sources = Lists.newArrayList();
        }
        if (this.algorithms == null) {
            this.algorithms = Lists.newArrayList();
        }
        if (this.includes == null) {
            this.includes = Lists.newArrayList();
        }
        if (this.otherComponents == null) {
            this.otherComponents = Lists.newArrayList();
        }
        ResourceLookup resourceLookup = PersisterHelpers.getResourceLookup(map);
        ArrayList arrayList = Lists.newArrayList();
        for (ProcessingComponentSuiteInclude object : this.includes) {
            IResource iResource = resourceLookup.getFirst(object.suite);
            if (iResource == null) {
                throw new Exception("Could not locate resource: " + object.suite);
            }
            arrayList.add(ProcessingComponentSuite.deserialize(iResource, resourceLookup));
        }
        for (ProcessingComponentSuite processingComponentSuite : arrayList) {
            this.sources.addAll(processingComponentSuite.getSources());
            this.algorithms.addAll(processingComponentSuite.getAlgorithms());
            this.otherComponents.addAll(processingComponentSuite.getOtherComponents());
        }
    }

    public static ProcessingComponentSuite deserialize(IResource iResource, ResourceLookup resourceLookup) throws Exception {
        if (iResource == null) {
            throw new IOException("Resource must not be null.");
        }
        InputStream inputStream = iResource.open();
        try {
            if (inputStream == null) {
                throw new IOException("Input stream must not be null.");
            }
            Persister persister = PersisterHelpers.createPersister((ResourceLookup)resourceLookup, (Strategy)new TreeStrategy());
            ProcessingComponentSuite processingComponentSuite = (ProcessingComponentSuite)persister.read(ProcessingComponentSuite.class, inputStream);
            processingComponentSuite.includes = null;
            ProcessingComponentSuite processingComponentSuite2 = processingComponentSuite;
            return processingComponentSuite2;
        }
        finally {
            CloseableUtils.close((Closeable)inputStream);
        }
    }

    public void serialize(OutputStream outputStream) throws Exception {
        new Persister().write((Object)this, outputStream);
    }

    public List<ProcessingComponentDescriptor> removeUnavailableComponents() {
        ArrayList arrayList = Lists.newArrayList();
        Iterator iterator = Iterators.concat(this.sources.iterator(), this.algorithms.iterator());
        while (iterator.hasNext()) {
            ProcessingComponentDescriptor processingComponentDescriptor = (ProcessingComponentDescriptor)iterator.next();
            if (processingComponentDescriptor.isComponentAvailable()) continue;
            arrayList.add(processingComponentDescriptor);
            iterator.remove();
        }
        return arrayList;
    }

    public ProcessingComponentConfiguration[] getComponentConfigurations() {
        List<ProcessingComponentDescriptor> list = this.getComponents();
        ProcessingComponentConfiguration[] processingComponentConfigurationArray = new ProcessingComponentConfiguration[list.size()];
        int n = 0;
        for (ProcessingComponentDescriptor processingComponentDescriptor : list) {
            processingComponentConfigurationArray[n++] = processingComponentDescriptor.getComponentConfiguration();
        }
        return processingComponentConfigurationArray;
    }
}

