/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.util.MapUtils;
import org.carrot2.util.simplexml.SimpleXmlWrapperValue;
import org.carrot2.util.simplexml.SimpleXmlWrappers;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.ElementMap;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.Persist;
import org.simpleframework.xml.core.Persister;

@Root(name="searchresult", strict=false)
public final class ProcessingResult {
    private Map<String, Object> attributes = Maps.newHashMap();
    private Map<String, Object> attributesView;
    @Element(required=false)
    private String query;
    @ElementList(inline=true, required=false)
    private List<Document> documents;
    @ElementList(inline=true, required=false)
    private List<Cluster> clusters;
    @ElementMap(entry="attribute", key="key", attribute=true, inline=true, required=false)
    private HashMap<String, SimpleXmlWrapperValue> otherAttributesForSerialization;

    ProcessingResult() {
        this(new HashMap<String, Object>());
    }

    ProcessingResult(Map<String, Object> map) {
        List list;
        this.attributes = map;
        List list2 = (List)map.get("documents");
        if (list2 != null) {
            Document.assignDocumentIds(list2);
            map.put("documents", Collections.unmodifiableList(list2));
        }
        if ((list = (List)map.get("clusters")) != null) {
            Cluster.assignClusterIds(list);
            map.put("clusters", Collections.unmodifiableList(list));
        }
        this.attributesView = Collections.unmodifiableMap(map);
    }

    public Map<String, Object> getAttributes() {
        return this.attributesView;
    }

    public <T> T getAttribute(String string) {
        return (T)this.attributesView.get(string);
    }

    public List<Document> getDocuments() {
        return (List)this.attributes.get("documents");
    }

    public List<Cluster> getClusters() {
        return (List)this.attributes.get("clusters");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Persist
    private void beforeSerialization() {
        ProcessingResult processingResult = this;
        synchronized (processingResult) {
            this.query = (String)this.attributes.get("query");
            this.documents = this.getDocuments() != null ? Lists.newArrayList(this.getDocuments()) : null;
            this.clusters = this.getClusters() != null ? Lists.newArrayList(this.getClusters()) : null;
            this.otherAttributesForSerialization = MapUtils.asHashMap((Map)SimpleXmlWrappers.wrap(this.attributes));
            this.otherAttributesForSerialization.remove("query");
            this.otherAttributesForSerialization.remove("clusters");
            this.otherAttributesForSerialization.remove("documents");
            if (this.otherAttributesForSerialization.isEmpty()) {
                this.otherAttributesForSerialization = null;
            }
        }
    }

    @Commit
    private void afterDeserialization() throws Exception {
        if (this.otherAttributesForSerialization != null) {
            this.attributes = SimpleXmlWrappers.unwrap(this.otherAttributesForSerialization);
        }
        this.attributesView = Collections.unmodifiableMap(this.attributes);
        this.attributes.put("query", this.query != null ? this.query.trim() : null);
        this.attributes.put("documents", this.documents);
        this.attributes.put("clusters", this.clusters);
        if (this.clusters != null && this.documents != null) {
            HashMap hashMap = Maps.newHashMap();
            for (Document object : this.documents) {
                hashMap.put(object.getStringId(), object);
            }
            for (Cluster cluster : this.clusters) {
                this.documentIdToReference(cluster, hashMap);
            }
        }
    }

    private void documentIdToReference(Cluster cluster, Map<String, Document> map) {
        if (cluster.documentIds != null) {
            for (Cluster.DocumentRefid object : cluster.documentIds) {
                cluster.addDocuments(map.get(object.refid));
            }
        }
        for (Cluster cluster2 : cluster.getSubclusters()) {
            this.documentIdToReference(cluster2, map);
        }
    }

    public String serialize() {
        try {
            StringWriter stringWriter = new StringWriter();
            new Persister().write((Object)this, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void serialize(OutputStream outputStream) throws Exception {
        this.serialize(outputStream, true, true);
    }

    public void serialize(OutputStream outputStream, boolean bl, boolean bl2) throws Exception {
        this.serialize(outputStream, bl, bl2, true);
    }

    public void serialize(OutputStream outputStream, boolean bl, boolean bl2, boolean bl3) throws Exception {
        Map<String, Object> map = this.attributes;
        this.attributes = this.prepareAttributesForSerialization(bl, bl2, bl3);
        new Persister().write((Object)this, outputStream);
        this.attributes = map;
    }

    public static ProcessingResult deserialize(CharSequence charSequence) throws Exception {
        return (ProcessingResult)new Persister().read(ProcessingResult.class, charSequence.toString());
    }

    public static ProcessingResult deserialize(InputStream inputStream) throws Exception {
        return (ProcessingResult)new Persister().read(ProcessingResult.class, inputStream);
    }

    public void serializeJson(Writer writer) throws IOException {
        this.serializeJson(writer, null);
    }

    public void serializeJson(Writer writer, String string) throws IOException {
        this.serializeJson(writer, string, true, true);
    }

    public void serializeJson(Writer writer, String string, boolean bl, boolean bl2) throws IOException {
        this.serializeJson(writer, string, false, bl, bl2);
    }

    public void serializeJson(Writer writer, String string, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.serializeJson(writer, string, bl, bl2, bl3, true);
    }

    public void serializeJson(Writer writer, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.getFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        if (StringUtils.isNotBlank((String)string)) {
            writer.write(String.valueOf(string) + "(");
        }
        Map<String, Object> map = this.prepareAttributesForSerialization(bl2, bl3, bl4);
        objectMapper.writeValue(writer, map);
        if (StringUtils.isNotBlank((String)string)) {
            writer.write(");");
        }
    }

    private Map<String, Object> prepareAttributesForSerialization(boolean bl, boolean bl2, boolean bl3) {
        HashMap hashMap = Maps.newHashMap();
        if (bl3) {
            hashMap.putAll(this.attributes);
            hashMap.remove("documents");
            hashMap.remove("clusters");
        } else {
            hashMap.put("query", this.attributes.get("query"));
        }
        if (bl) {
            hashMap.put("documents", this.getDocuments());
        }
        if (bl2) {
            hashMap.put("clusters", this.getClusters());
        }
        return hashMap;
    }
}

