/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.core.attribute;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class CommonAttributesDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.core.attribute.CommonAttributes";
    public final String prefix = "";
    public final String title = "Attributes shared and inherited by many clustering algorithms";
    public final String label = "";
    public final String description = "Extracted for consistency.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(CommonAttributesDescriptor.attributes.clusters);
        hashSet.add(CommonAttributesDescriptor.attributes.documents);
        hashSet.add(CommonAttributesDescriptor.attributes.processingResultTitle);
        hashSet.add(CommonAttributesDescriptor.attributes.processingTimeAlgorithm);
        hashSet.add(CommonAttributesDescriptor.attributes.processingTimeSource);
        hashSet.add(CommonAttributesDescriptor.attributes.processingTimeTotal);
        hashSet.add(CommonAttributesDescriptor.attributes.query);
        hashSet.add(CommonAttributesDescriptor.attributes.results);
        hashSet.add(CommonAttributesDescriptor.attributes.resultsTotal);
        hashSet.add(CommonAttributesDescriptor.attributes.start);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(CommonAttributesDescriptor.attributes.clusters);
        hashSet2.add(CommonAttributesDescriptor.attributes.documents);
        hashSet2.add(CommonAttributesDescriptor.attributes.processingResultTitle);
        hashSet2.add(CommonAttributesDescriptor.attributes.processingTimeAlgorithm);
        hashSet2.add(CommonAttributesDescriptor.attributes.processingTimeSource);
        hashSet2.add(CommonAttributesDescriptor.attributes.processingTimeTotal);
        hashSet2.add(CommonAttributesDescriptor.attributes.query);
        hashSet2.add(CommonAttributesDescriptor.attributes.results);
        hashSet2.add(CommonAttributesDescriptor.attributes.resultsTotal);
        hashSet2.add(CommonAttributesDescriptor.attributes.start);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "";
    }

    public String getTitle() {
        return "Attributes shared and inherited by many clustering algorithms";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "Extracted for consistency.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public List<Cluster> clusters() {
            return (List)this.map.get("clusters");
        }

        public AttributeBuilder documents(List<Document> list) {
            this.map.put("documents", list);
            return this;
        }

        public AttributeBuilder documents(IObjectFactory<? extends List<Document>> iObjectFactory) {
            this.map.put("documents", iObjectFactory);
            return this;
        }

        public List<Document> documents() {
            return (List)this.map.get("documents");
        }

        public String processingResultTitle() {
            return (String)this.map.get("processing-result.title");
        }

        public Long processingTimeAlgorithm() {
            return (Long)this.map.get("processing-time-algorithm");
        }

        public Long processingTimeSource() {
            return (Long)this.map.get("processing-time-source");
        }

        public Long processingTimeTotal() {
            return (Long)this.map.get("processing-time-total");
        }

        public AttributeBuilder query(String string) {
            this.map.put("query", string);
            return this;
        }

        public AttributeBuilder query(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("query", iObjectFactory);
            return this;
        }

        public AttributeBuilder results(int n) {
            this.map.put("results", n);
            return this;
        }

        public AttributeBuilder results(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("results", iObjectFactory);
            return this;
        }

        public Long resultsTotal() {
            return (Long)this.map.get("results-total");
        }

        public AttributeBuilder start(int n) {
            this.map.put("start", n);
            return this;
        }

        public AttributeBuilder start(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("start", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo clusters = new AttributeInfo("clusters", "org.carrot2.core.attribute.CommonAttributes", "clusters", "Clusters created by the clustering algorithm.", "Clusters", "Clusters created by the clustering algorithm", null, "Search result information", AttributeLevel.BASIC, null);
        public final AttributeInfo documents = new AttributeInfo("documents", "org.carrot2.core.attribute.CommonAttributes", "documents", "Documents returned by the search engine/ document retrieval system or\ndocuments passed as input to the clustering algorithm.", "Documents", "Documents returned by the search engine/ document retrieval system or documents passed as input to the clustering algorithm", null, "Documents", AttributeLevel.BASIC, null);
        public final AttributeInfo processingResultTitle = new AttributeInfo("processing-result.title", "org.carrot2.core.attribute.CommonAttributes", "processingResultTitle", "Processing result title. A typical title for a processing result will be the query\nused to fetch documents from that source. For certain document sources the query\nmay not be needed (on-disk XML, feed of syndicated news); in such cases, the input\ncomponent should set its title properly for visual interfaces such as the\nworkbench.", "Title", "Processing result title", "A typical title for a processing result will be the query used to fetch documents from that source. For certain document sources the query may not be needed (on-disk XML, feed of syndicated news); in such cases, the input component should set its title properly for visual interfaces such as the workbench.", "Search result information", AttributeLevel.BASIC, null);
        public final AttributeInfo processingTimeAlgorithm = new AttributeInfo("processing-time-algorithm", "org.carrot2.core.attribute.CommonAttributes", "processingTimeAlgorithm", "Algorithm processing time in milliseconds. A sum of processing times of all\n{@link org.carrot2.core.IClusteringAlgorithm}s in the chain, including the\n{@link org.carrot2.core.IProcessingComponent#beforeProcessing()} and\n{@link org.carrot2.core.IProcessingComponent#afterProcessing()} hooks.", "Clustering algorithm processing time", "Algorithm processing time in milliseconds", "A sum of processing times of all <code>org.carrot2.core.IClusteringAlgorithm</code>s in the chain, including the <code>org.carrot2.core.IProcessingComponent.beforeProcessing()</code> and <code>org.carrot2.core.IProcessingComponent.afterProcessing()</code> hooks.", "Search result information", AttributeLevel.BASIC, null);
        public final AttributeInfo processingTimeSource = new AttributeInfo("processing-time-source", "org.carrot2.core.attribute.CommonAttributes", "processingTimeSource", "Data source processing time in milliseconds. A sum of processing times of all\n{@link org.carrot2.core.IDocumentSource}s in the chain, including the\n{@link org.carrot2.core.IProcessingComponent#beforeProcessing()} and\n{@link org.carrot2.core.IProcessingComponent#afterProcessing()} hooks.", "Data source processing time", "Data source processing time in milliseconds", "A sum of processing times of all <code>org.carrot2.core.IDocumentSource</code>s in the chain, including the <code>org.carrot2.core.IProcessingComponent.beforeProcessing()</code> and <code>org.carrot2.core.IProcessingComponent.afterProcessing()</code> hooks.", "Search result information", AttributeLevel.BASIC, null);
        public final AttributeInfo processingTimeTotal = new AttributeInfo("processing-time-total", "org.carrot2.core.attribute.CommonAttributes", "processingTimeTotal", "Total processing time in milliseconds. A sum of processing times of all components in the chain.\nTotal processing time may be greater than the sum of\n{@link org.carrot2.core.attribute.CommonAttributes#processingTimeTotal} and {@link org.carrot2.core.attribute.CommonAttributes#processingTimeAlgorithm}.", "Total processing time", "Total processing time in milliseconds", "A sum of processing times of all components in the chain. Total processing time may be greater than the sum of <code>org.carrot2.core.attribute.CommonAttributes.processingTimeTotal</code> and <code>org.carrot2.core.attribute.CommonAttributes.processingTimeAlgorithm</code>.", "Search result information", AttributeLevel.BASIC, null);
        public final AttributeInfo query = new AttributeInfo("query", "org.carrot2.core.attribute.CommonAttributes", "query", "Query to perform.", "Query", "Query to perform", null, "Search query", AttributeLevel.BASIC, null);
        public final AttributeInfo results = new AttributeInfo("results", "org.carrot2.core.attribute.CommonAttributes", "results", "Maximum number of documents/ search results to fetch. The query hint can be used\nby clustering algorithms to avoid creating trivial clusters (combination of query words).", "Results", "Maximum number of documents/ search results to fetch", "The query hint can be used by clustering algorithms to avoid creating trivial clusters (combination of query words).", "Search query", AttributeLevel.BASIC, null);
        public final AttributeInfo resultsTotal = new AttributeInfo("results-total", "org.carrot2.core.attribute.CommonAttributes", "resultsTotal", "Estimated total number of matching documents.", "Total results", "Estimated total number of matching documents", null, "Search result information", null, null);
        public final AttributeInfo start = new AttributeInfo("start", "org.carrot2.core.attribute.CommonAttributes", "start", "Index of the first document/ search result to fetch. The index starts at zero.", "Start index", "Index of the first document/ search result to fetch", "The index starts at zero.", "Search query", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys {
        public static final String CLUSTERS = "clusters";
        public static final String DOCUMENTS = "documents";
        public static final String PROCESSING_RESULT_TITLE = "processing-result.title";
        public static final String PROCESSING_TIME_ALGORITHM = "processing-time-algorithm";
        public static final String PROCESSING_TIME_SOURCE = "processing-time-source";
        public static final String PROCESSING_TIME_TOTAL = "processing-time-total";
        public static final String QUERY = "query";
        public static final String RESULTS = "results";
        public static final String RESULTS_TOTAL = "results-total";
        public static final String START = "start";

        protected Keys() {
        }
    }
}

