/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.carrot2.core.Document;
import org.carrot2.core.ProcessingException;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.MultipageSearchEngineMetadata;
import org.carrot2.source.SearchEngineBase;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.UniqueFieldPredicate;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;

@Bindable
public abstract class MultipageSearchEngine
extends SearchEngineBase {
    @Processing
    @Input
    @Attribute(key="search-mode")
    @Level(value=AttributeLevel.ADVANCED)
    @Label(value="Search Mode")
    @Group(value="Data source paging")
    public SearchMode searchMode = SearchMode.SPECULATIVE;

    protected void process(MultipageSearchEngineMetadata multipageSearchEngineMetadata, ExecutorService executorService) throws ProcessingException {
        SearchEngineResponse[] searchEngineResponseArray = this.runQuery(this.query, this.start, this.results, multipageSearchEngineMetadata, executorService);
        this.compressed = false;
        if (searchEngineResponseArray.length > 0) {
            this.documents = new ArrayList(Math.min(this.results, multipageSearchEngineMetadata.maxResultIndex));
            this.collectDocuments(this.documents, searchEngineResponseArray);
            Iterator iterator = this.documents.iterator();
            UniqueFieldPredicate uniqueFieldPredicate = new UniqueFieldPredicate("url");
            while (iterator.hasNext()) {
                if (uniqueFieldPredicate.apply((Document)iterator.next())) continue;
                iterator.remove();
            }
            this.resultsTotal = searchEngineResponseArray[0].getResultsTotal();
            int n = 0;
            while (n < searchEngineResponseArray.length) {
                String string = (String)searchEngineResponseArray[n].metadata.get("compression");
                if (string != null && "gzip".contains(string)) {
                    this.compressed = true;
                }
                ++n;
            }
        } else {
            this.documents = Collections.emptyList();
            this.resultsTotal = 0L;
        }
    }

    protected abstract Callable<SearchEngineResponse> createFetcher(SearchRange var1);

    protected final void collectDocuments(Collection<Document> collection, SearchEngineResponse[] searchEngineResponseArray) {
        SearchEngineResponse[] searchEngineResponseArray2 = searchEngineResponseArray;
        int n = searchEngineResponseArray.length;
        int n2 = 0;
        while (n2 < n) {
            SearchEngineResponse searchEngineResponse = searchEngineResponseArray2[n2];
            collection.addAll(searchEngineResponse.results);
            ++n2;
        }
    }

    protected final SearchEngineResponse[] runQuery(String string, int n, int n2, MultipageSearchEngineMetadata multipageSearchEngineMetadata, ExecutorService executorService) throws ProcessingException {
        this.statistics.incrQueryCount();
        SearchRange[] searchRangeArray = SearchRange.getSearchRanges(n, n2, multipageSearchEngineMetadata.maxResultIndex, multipageSearchEngineMetadata.resultsPerPage, multipageSearchEngineMetadata.incrementByPage);
        if (string == null || string.trim().equals("") || searchRangeArray.length == 0) {
            return new SearchEngineResponse[0];
        }
        try {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>(searchRangeArray.length);
            if (searchRangeArray.length == 1 || this.searchMode == SearchMode.CONSERVATIVE) {
                object = this.createFetcher(searchRangeArray[0]).call();
                long l = ((SearchEngineResponse)object).getResultsTotal();
                arrayList.add(object);
                if (searchRangeArray.length == 1) {
                    return arrayList.toArray(new SearchEngineResponse[arrayList.size()]);
                }
                if (l != -1L && l < (long)n2) {
                    searchRangeArray = SearchRange.getSearchRanges(searchRangeArray[0].results, (int)l, multipageSearchEngineMetadata.maxResultIndex, multipageSearchEngineMetadata.resultsPerPage, multipageSearchEngineMetadata.incrementByPage);
                }
            }
            object = new ArrayList(searchRangeArray.length);
            SearchRange[] searchRangeArray2 = searchRangeArray;
            int n3 = searchRangeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                SearchRange searchRange = searchRangeArray2[n4];
                ((ArrayList)object).add(this.createFetcher(searchRange));
                ++n4;
            }
            List list = executorService.invokeAll(object);
            for (Future future : list) {
                if (future.isCancelled()) continue;
                arrayList.add((SearchEngineResponse)future.get());
            }
            return arrayList.toArray(new SearchEngineResponse[arrayList.size()]);
        }
        catch (IOException iOException) {
            throw new ProcessingException(iOException.getMessage(), iOException);
        }
        catch (InterruptedException interruptedException) {
            return new SearchEngineResponse[0];
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            if (throwable == null) {
                throwable = exception;
            }
            throw new ProcessingException(throwable.getMessage(), exception);
        }
    }

    protected abstract class SearchEngineResponseCallable
    implements Callable<SearchEngineResponse> {
        protected SearchEngineResponseCallable() {
        }

        @Override
        public final SearchEngineResponse call() throws Exception {
            MultipageSearchEngine.this.statistics.incrPageRequestCount();
            SearchEngineResponse searchEngineResponse = this.search();
            MultipageSearchEngine.this.afterFetch(searchEngineResponse);
            return searchEngineResponse;
        }

        public abstract SearchEngineResponse search() throws Exception;
    }

    public static enum SearchMode {
        CONSERVATIVE,
        SPECULATIVE;

    }

    protected static final class SearchRange {
        private static final SearchRange[] EMPTY_RANGE = new SearchRange[0];
        public final int start;
        public final int results;

        public SearchRange(int n, int n2) {
            this.start = n;
            this.results = n2;
        }

        public static SearchRange[] getSearchRanges(int n, int n2, int n3, int n4, boolean bl) {
            n2 = Math.max(n2, 0);
            n = Math.max(n, 0);
            int n5 = Math.min(n * (bl ? n4 : 1), n3);
            int n6 = Math.min(n * (bl ? n4 : 1) + n2, n3);
            int n7 = n6 - n5;
            if (n7 == 0) {
                return EMPTY_RANGE;
            }
            int n8 = n7 % n4;
            int n9 = n7 / n4 + (n8 > 0 ? 1 : 0);
            SearchRange[] searchRangeArray = new SearchRange[n9];
            int n10 = 0;
            while (n10 < searchRangeArray.length) {
                int n11 = Math.min(n4, n6 - n5);
                searchRangeArray[n10] = new SearchRange(bl ? n + n10 : n5, n11);
                n5 += n11;
                ++n10;
            }
            return searchRangeArray;
        }
    }
}

