/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.source.MultipageSearchEngine;
import org.carrot2.source.SearchEngineBaseDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class MultipageSearchEngineDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.MultipageSearchEngine";
    public final String prefix = "";
    public final String title = "A base class facilitating implementation of <code>IDocumentSource</code>s wrapping external search engines with remote/ network-based interfaces";
    public final String label = "";
    public final String description = "This class implements helper methods for concurrent querying of search services that limit the number of search results returned in one request.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(MultipageSearchEngineDescriptor.attributes.searchMode);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(MultipageSearchEngineDescriptor.attributes.searchMode);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.compressed);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.documents);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.query);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.results);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.start);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "";
    }

    public String getTitle() {
        return "A base class facilitating implementation of <code>IDocumentSource</code>s wrapping external search engines with remote/ network-based interfaces";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "This class implements helper methods for concurrent querying of search services that limit the number of search results returned in one request.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder
    extends SearchEngineBaseDescriptor.AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            super(map);
            this.map = map;
        }

        public AttributeBuilder searchMode(MultipageSearchEngine.SearchMode searchMode) {
            this.map.put("search-mode", (Object)searchMode);
            return this;
        }

        public AttributeBuilder searchMode(Class<?> clazz) {
            this.map.put("search-mode", clazz);
            return this;
        }

        public AttributeBuilder searchMode(IObjectFactory<? extends MultipageSearchEngine.SearchMode> iObjectFactory) {
            this.map.put("search-mode", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo searchMode = new AttributeInfo("search-mode", "org.carrot2.source.MultipageSearchEngine", "searchMode", "Search mode defines how fetchers returned from {@link org.carrot2.source.MultipageSearchEngine#createFetcher}\nare called.", "Search Mode", "Search mode defines how fetchers returned from <code>org.carrot2.source.MultipageSearchEngine.createFetcher</code> are called", null, "Data source paging", AttributeLevel.ADVANCED, null);

        private Attributes() {
        }
    }

    public static class Keys
    extends SearchEngineBaseDescriptor.Keys {
        public static final String SEARCH_MODE = "search-mode";

        protected Keys() {
        }
    }
}

