/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.carrot2.core.Document;
import org.carrot2.core.IDocumentSource;
import org.carrot2.core.ProcessingComponentBase;
import org.carrot2.core.attribute.CommonAttributes;
import org.carrot2.core.attribute.Internal;
import org.carrot2.core.attribute.Processing;
import org.carrot2.source.SearchEngineResponse;
import org.carrot2.source.SearchEngineStats;
import org.carrot2.util.StringUtils;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.IntRange;
import org.carrot2.util.attribute.constraint.NotBlank;

@Bindable(prefix="SearchEngineBase", inherit={CommonAttributes.class})
public abstract class SearchEngineBase
extends ProcessingComponentBase
implements IDocumentSource {
    public static final String SERVICE = "Service";
    protected static final String POSTPROCESSING = "Postprocessing";
    @Processing
    @Input
    @Attribute(key="start", inherit=true)
    @IntRange(min=0)
    public int start = 0;
    @Processing
    @Input
    @Attribute(key="results", inherit=true)
    @IntRange(min=1)
    public int results = 100;
    @Processing
    @Input
    @Attribute(key="query", inherit=true)
    @Required
    @NotBlank
    public String query;
    @Processing
    @Output
    @Attribute(key="results-total", inherit=true)
    public long resultsTotal;
    @Processing
    @Output
    @Attribute(key="documents", inherit=true)
    @Internal
    public Collection<Document> documents;
    @Processing
    @Output
    @Attribute
    @Label(value="Compression used")
    @Group(value="Search result information")
    public boolean compressed;
    public SearchEngineStats statistics = new SearchEngineStats();
    private static Pattern HIGHLIGHTS_PATTERN = Pattern.compile("</?b>");

    protected static void clean(SearchEngineResponse searchEngineResponse, boolean bl, String ... stringArray) {
        for (Document document : searchEngineResponse.results) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                String string2 = (String)document.getField(string);
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)string2)) {
                    String string3 = string2;
                    if (!bl) {
                        Matcher matcher = HIGHLIGHTS_PATTERN.matcher(string3);
                        string3 = matcher.replaceAll("");
                    }
                    string3 = StringEscapeUtils.unescapeHtml((String)string3);
                    document.setField(string, string3);
                }
                ++n2;
            }
        }
    }

    protected void afterFetch(SearchEngineResponse searchEngineResponse) {
    }

    protected static final String urlEncode(String string) {
        return StringUtils.urlEncodeWrapException((String)string, (String)"UTF-8");
    }
}

