/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.source;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.core.Document;
import org.carrot2.core.attribute.CommonAttributesDescriptor;
import org.carrot2.util.attribute.AttributeInfo;
import org.carrot2.util.attribute.IBindableDescriptor;
import org.carrot2.util.attribute.IObjectFactory;

public final class SearchEngineBaseDescriptor
implements IBindableDescriptor {
    public final String bindableClassName = "org.carrot2.source.SearchEngineBase";
    public final String prefix = "SearchEngineBase";
    public final String title = "A base class facilitating implementation of <code>IDocumentSource</code>s wrapping external search engines with remote/ network-based interfaces";
    public final String label = "";
    public final String description = "The base class defines the common attribute fields used by more specific base classes and concrete implementations.";
    public static final Attributes attributes = new Attributes();
    private static final Set<AttributeInfo> ownAttributes;
    private static final Set<AttributeInfo> allAttributes;
    private static final Map<String, AttributeInfo> allAttributesByKey;
    private static final Map<String, AttributeInfo> allAttributesByFieldName;

    static {
        HashSet<AttributeInfo> hashSet = new HashSet<AttributeInfo>();
        hashSet.add(SearchEngineBaseDescriptor.attributes.compressed);
        hashSet.add(SearchEngineBaseDescriptor.attributes.documents);
        hashSet.add(SearchEngineBaseDescriptor.attributes.query);
        hashSet.add(SearchEngineBaseDescriptor.attributes.results);
        hashSet.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        hashSet.add(SearchEngineBaseDescriptor.attributes.start);
        HashSet<AttributeInfo> hashSet2 = new HashSet<AttributeInfo>();
        hashSet2.add(SearchEngineBaseDescriptor.attributes.compressed);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.documents);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.query);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.results);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.resultsTotal);
        hashSet2.add(SearchEngineBaseDescriptor.attributes.start);
        allAttributes = Collections.unmodifiableSet(hashSet2);
        ownAttributes = Collections.unmodifiableSet(hashSet);
        HashMap<String, AttributeInfo> hashMap = new HashMap<String, AttributeInfo>();
        HashMap<String, AttributeInfo> hashMap2 = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : hashSet2) {
            hashMap.put(attributeInfo.key, attributeInfo);
            hashMap2.put(attributeInfo.fieldName, attributeInfo);
        }
        allAttributesByKey = Collections.unmodifiableMap(hashMap);
        allAttributesByFieldName = Collections.unmodifiableMap(hashMap2);
    }

    public static AttributeBuilder attributeBuilder(Map<String, Object> map) {
        return new AttributeBuilder(map);
    }

    public String getPrefix() {
        return "SearchEngineBase";
    }

    public String getTitle() {
        return "A base class facilitating implementation of <code>IDocumentSource</code>s wrapping external search engines with remote/ network-based interfaces";
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return "The base class defines the common attribute fields used by more specific base classes and concrete implementations.";
    }

    public Set<AttributeInfo> getOwnAttributes() {
        return ownAttributes;
    }

    public Set<AttributeInfo> getAttributes() {
        return allAttributes;
    }

    public Map<String, AttributeInfo> getAttributesByKey() {
        return allAttributesByKey;
    }

    public Map<String, AttributeInfo> getAttributesByFieldName() {
        return allAttributesByFieldName;
    }

    public static class AttributeBuilder {
        public final Map<String, Object> map;

        protected AttributeBuilder(Map<String, Object> map) {
            this.map = map;
        }

        public boolean compressed() {
            return (Boolean)this.map.get("SearchEngineBase.compressed");
        }

        public Collection<Document> documents() {
            return (Collection)this.map.get("documents");
        }

        public AttributeBuilder query(String string) {
            this.map.put("query", string);
            return this;
        }

        public AttributeBuilder query(IObjectFactory<? extends String> iObjectFactory) {
            this.map.put("query", iObjectFactory);
            return this;
        }

        public AttributeBuilder results(int n) {
            this.map.put("results", n);
            return this;
        }

        public AttributeBuilder results(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("results", iObjectFactory);
            return this;
        }

        public long resultsTotal() {
            return (Long)this.map.get("results-total");
        }

        public AttributeBuilder start(int n) {
            this.map.put("start", n);
            return this;
        }

        public AttributeBuilder start(IObjectFactory<? extends Integer> iObjectFactory) {
            this.map.put("start", iObjectFactory);
            return this;
        }
    }

    public static final class Attributes {
        public final AttributeInfo compressed = new AttributeInfo("SearchEngineBase.compressed", "org.carrot2.source.SearchEngineBase", "compressed", "Indicates whether the search engine returned a compressed result stream.", "Compression used", "Indicates whether the search engine returned a compressed result stream", null, "Search result information", null, null);
        public final AttributeInfo documents;
        public final AttributeInfo query;
        public final AttributeInfo results;
        public final AttributeInfo resultsTotal;
        public final AttributeInfo start;

        private Attributes() {
            this.documents = new AttributeInfo("documents", "org.carrot2.source.SearchEngineBase", "documents", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.documents);
            this.query = new AttributeInfo("query", "org.carrot2.source.SearchEngineBase", "query", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.query);
            this.results = new AttributeInfo("results", "org.carrot2.source.SearchEngineBase", "results", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.results);
            this.resultsTotal = new AttributeInfo("results-total", "org.carrot2.source.SearchEngineBase", "resultsTotal", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.resultsTotal);
            this.start = new AttributeInfo("start", "org.carrot2.source.SearchEngineBase", "start", null, null, null, null, null, null, CommonAttributesDescriptor.attributes.start);
        }
    }

    public static class Keys {
        public static final String COMPRESSED = "SearchEngineBase.compressed";
        public static final String DOCUMENTS = "documents";
        public static final String QUERY = "query";
        public static final String RESULTS = "results";
        public static final String RESULTS_TOTAL = "results-total";
        public static final String START = "start";

        protected Keys() {
        }
    }
}

