/*
 * Decompiled with CFR 0.152.
 */
package biz.aduna.map.cluster.render.anim;

import biz.aduna.map.cluster.Classification;
import biz.aduna.map.cluster.Cluster;
import biz.aduna.map.cluster.graph.ClassificationEdge;
import biz.aduna.map.cluster.graph.ClassificationVertex;
import biz.aduna.map.cluster.graph.ClusterEdge;
import biz.aduna.map.cluster.graph.ClusterGraph;
import biz.aduna.map.cluster.graph.ClusterVertex;
import biz.aduna.map.cluster.graph.ObjectVertex;
import biz.aduna.map.cluster.render.ClassificationIdentityScheme;
import biz.aduna.map.cluster.render.ClassificationRenderer;
import biz.aduna.map.cluster.render.ClusterEdgeRenderer;
import biz.aduna.map.cluster.render.ClusterGraphRendering;
import biz.aduna.map.cluster.render.ClusterRenderer;
import biz.aduna.map.cluster.render.GraphRenderingProperties;
import biz.aduna.map.cluster.render.Scheme;
import biz.aduna.map.cluster.render.anim.SubCluster;
import biz.aduna.map.cluster.render.anim.SubClusterModel;
import biz.aduna.map.graph.Graph;
import biz.aduna.map.graph.Vertex;
import biz.aduna.util.State;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class TransitionAnimator {
    public static final boolean DEFAULT_ANIMATING_EDGES = true;
    public static final boolean DEFAULT_ANIMATING_TEXT = true;
    public static final double FIRST_SHIFT = 0.35;
    public static final double SECOND_SHIFT = 0.65;
    public static final State FIRST_PHASE = new State("first phase");
    public static final State SECOND_PHASE = new State("second phase");
    public static final State THIRD_PHASE = new State("third phase");
    public static final Color EDGE_BORDER_COLOR = new Color(194, 194, 194);
    public static final Color CLASS_EDGE_COLOR = Scheme.CLASSIFICATION_EDGE_COLOR_NORMAL;
    public static final float CLASS_EDGE_THICKNESS = 1.5f;
    private static final double F = 1.5707963267948966;
    private static final double e = -1.5707963267948966;
    private boolean L = true;
    private boolean X = true;
    private State G;
    private long D;
    private long I;
    private long P;
    private long J;
    private float b;
    private boolean W;
    private boolean B;
    private double C;
    private double T;
    private double U;
    private Font g;
    private HashMap f;
    private Image i = null;
    private float _ = -1.0f;
    private BufferedImage j;
    private ImageSprite[] A;
    private TextSprite[] M;
    private SubClusterSprite[] a;
    private ClassEdgeSprite[] R;
    private ClusterEdgeSprite[] V;
    private ImageSprite[] H;
    private TextSprite[] Z;
    private SubClusterSprite[] c;
    private ClassEdgeSprite[] O;
    private ClusterEdgeSprite[] h;
    private ImageSprite[] Y;
    private TextSprite[] N;
    private SubClusterSprite[] d;
    private ClassEdgeSprite[] K;
    private ClusterEdgeSprite[] S;
    protected ClusterGraph _oldGraph;
    protected ClusterGraph _newGraph;
    protected ClusterGraphRendering _oldRendering;
    protected ClusterGraphRendering _newRendering;
    protected Rectangle _oldBoundingBox;
    protected Rectangle _newBoundingBox;
    protected Dimension _oldSize;
    protected Dimension _newSize;
    protected double _oldScale;
    protected double _newScale;
    protected Insets _oldMargin;
    protected Insets _newMargin;
    private SubClusterModel E;
    private HashMap Q = new HashMap();

    public TransitionAnimator() {
        this.f = new HashMap();
    }

    public void setAnimatingEdges(boolean bl) {
        this.L = bl;
    }

    public boolean isAnimatingEdges() {
        return this.L;
    }

    public void setAnimatingText(boolean bl) {
        this.X = bl;
    }

    public boolean isAnimatingText() {
        return this.X;
    }

    public void prepareFor(ClusterGraph clusterGraph, ClusterGraph clusterGraph2, long l) {
        ClusterGraphRendering clusterGraphRendering;
        this._oldGraph = clusterGraph;
        this._newGraph = clusterGraph2;
        this._oldRendering = clusterGraphRendering = (ClusterGraphRendering)clusterGraph.getGraphRendering();
        this._oldBoundingBox = clusterGraphRendering.getBoundingBox((Graph)clusterGraph);
        this._oldSize = clusterGraphRendering.getSize();
        this._oldScale = clusterGraphRendering.getScale();
        this._oldMargin = clusterGraphRendering.getMargin();
        this._newRendering = clusterGraphRendering = (ClusterGraphRendering)clusterGraph2.getGraphRendering();
        this._newBoundingBox = clusterGraphRendering.getBoundingBox((Graph)clusterGraph2);
        this._newSize = clusterGraphRendering.getSize();
        this._newScale = clusterGraphRendering.getScale();
        this._newMargin = clusterGraphRendering.getMargin();
        this.g = clusterGraphRendering.getGraphRenderingProperties().getClassificationNameFont();
        this.A(clusterGraph, clusterGraph2);
        this.D(clusterGraph, clusterGraph2);
        this.A(l);
        this.W = false;
        this.B = false;
    }

    private final void A(ClusterGraph clusterGraph, ClusterGraph clusterGraph2) {
        ArrayList arrayList = this.A(clusterGraph);
        ArrayList arrayList2 = this.A(clusterGraph2);
        this.E = new SubClusterModel((Collection)arrayList, (Collection)arrayList2);
    }

    private final ArrayList A(ClusterGraph clusterGraph) {
        List list = clusterGraph.getClusterVertices();
        int n = list.size();
        ArrayList<Cluster> arrayList = new ArrayList<Cluster>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(((ClusterVertex)list.get(n2)).getCluster());
            ++n2;
        }
        return arrayList;
    }

    private final void D(ClusterGraph clusterGraph, ClusterGraph clusterGraph2) {
        this.C(clusterGraph, clusterGraph2);
        this.B(clusterGraph, clusterGraph2);
        this.E(clusterGraph, clusterGraph2);
    }

    private final void C(ClusterGraph clusterGraph, ClusterGraph clusterGraph2) {
        Classification classification;
        ImageSprite imageSprite;
        Object object;
        Vertex vertex;
        Rectangle rectangle = new Rectangle();
        Collection collection = clusterGraph.getClusterModel().getClassifications();
        Collection collection2 = clusterGraph2.getClusterModel().getClassifications();
        ArrayList arrayList = new ArrayList(300);
        ArrayList<ImageSprite> arrayList2 = new ArrayList<ImageSprite>(300);
        ArrayList<ImageSprite> arrayList3 = new ArrayList<ImageSprite>(300);
        ArrayList arrayList4 = new ArrayList(1000);
        arrayList4.addAll(clusterGraph.getClassificationVertices());
        arrayList4.addAll(this._getAnimatedObjectVertices(clusterGraph));
        HashMap<Object, ImageSprite> hashMap = new HashMap<Object, ImageSprite>(401);
        int n = arrayList4.size();
        int n2 = 0;
        while (n2 < n) {
            vertex = (Vertex)arrayList4.get(n2);
            object = this.A(vertex);
            imageSprite = new ImageSprite(this._oldRendering.getImageFor(vertex));
            this._oldRendering.getShapeBoundingBox(vertex, rectangle);
            imageSprite.oldX = rectangle.x - this._oldBoundingBox.x;
            imageSprite.oldY = rectangle.y - this._oldBoundingBox.y;
            hashMap.put(object, imageSprite);
            if (vertex instanceof ClassificationVertex) {
                classification = ((ClassificationVertex)vertex).getClassification();
                this.Q.put(classification, imageSprite);
                ClassificationRenderer classificationRenderer = (ClassificationRenderer)vertex.getRenderingAttribute();
                if (!classificationRenderer.isImageVisible() && !collection2.contains(classification)) {
                    imageSprite.image = null;
                }
            }
            ++n2;
        }
        arrayList4.clear();
        arrayList4.addAll(clusterGraph2.getClassificationVertices());
        arrayList4.addAll(this._getAnimatedObjectVertices(clusterGraph2));
        n = arrayList4.size();
        n2 = 0;
        while (n2 < n) {
            vertex = (Vertex)arrayList4.get(n2);
            object = this.A(vertex);
            imageSprite = (ImageSprite)hashMap.remove(object);
            if (imageSprite == null) {
                imageSprite = new ImageSprite(this._newRendering.getImageFor(vertex));
                arrayList3.add(imageSprite);
                if (object instanceof Classification) {
                    this.Q.put(object, imageSprite);
                    classification = (ClassificationRenderer)vertex.getRenderingAttribute();
                    if (!classification.isImageVisible() && !collection.contains(object)) {
                        imageSprite.image = null;
                    }
                }
            } else {
                arrayList2.add(imageSprite);
            }
            this._newRendering.getShapeBoundingBox(vertex, rectangle);
            imageSprite.newX = rectangle.x - this._newBoundingBox.x;
            imageSprite.newY = rectangle.y - this._newBoundingBox.y;
            ++n2;
        }
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        this.A = new ImageSprite[arrayList.size()];
        this.A = arrayList.toArray(this.A);
        this.H = new ImageSprite[arrayList2.size()];
        this.H = arrayList2.toArray(this.H);
        this.Y = new ImageSprite[arrayList3.size()];
        this.Y = arrayList3.toArray(this.Y);
    }

    protected List _getAnimatedObjectVertices(ClusterGraph clusterGraph) {
        ArrayList arrayList = new ArrayList(clusterGraph.getObjectVertices().size());
        List list = clusterGraph.getClusterVertices();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ClusterVertex clusterVertex = (ClusterVertex)list.get(n2);
            ClusterRenderer clusterRenderer = (ClusterRenderer)clusterVertex.getRenderingAttribute();
            if (clusterRenderer.getDisplayMode() == GraphRenderingProperties.MULTIPLE_ENTITIES_MODE) {
                arrayList.addAll(clusterVertex.getObjectVertices());
            }
            ++n2;
        }
        return arrayList;
    }

    private final void B(ClusterGraph clusterGraph, ClusterGraph clusterGraph2) {
        Point point = new Point();
        ArrayList arrayList = new ArrayList();
        ArrayList<TextSprite> arrayList2 = new ArrayList<TextSprite>();
        ArrayList<TextSprite> arrayList3 = new ArrayList<TextSprite>();
        if (this.X) {
            Object object;
            Vertex vertex;
            ArrayList arrayList4 = new ArrayList(clusterGraph.getClassificationVertices());
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            int n = arrayList4.size();
            int n2 = 0;
            while (n2 < n) {
                vertex = (Vertex)arrayList4.get(n2);
                object = new TextSprite(this._oldRendering.getTextFor(vertex));
                this._oldRendering.getTextCoordinate(vertex, point);
                ((TextSprite)object).oldX = point.x - this._oldBoundingBox.x;
                ((TextSprite)object).oldY = point.y - this._oldBoundingBox.y;
                hashMap.put(this.A(vertex), object);
                ++n2;
            }
            arrayList4.clear();
            arrayList4.addAll(clusterGraph2.getClassificationVertices());
            n = arrayList4.size();
            n2 = 0;
            while (n2 < n) {
                vertex = (Vertex)arrayList4.get(n2);
                object = this.A(vertex);
                TextSprite textSprite = (TextSprite)hashMap.remove(object);
                if (textSprite == null) {
                    textSprite = new TextSprite(this._newRendering.getTextFor(vertex));
                    arrayList3.add(textSprite);
                } else {
                    arrayList2.add(textSprite);
                }
                this._newRendering.getTextCoordinate(vertex, point);
                textSprite.newX = point.x - this._newBoundingBox.x;
                textSprite.newY = point.y - this._newBoundingBox.y;
                ++n2;
            }
            Iterator iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        this.M = new TextSprite[arrayList.size()];
        this.M = arrayList.toArray(this.M);
        this.Z = new TextSprite[arrayList2.size()];
        this.Z = arrayList2.toArray(this.Z);
        this.N = new TextSprite[arrayList3.size()];
        this.N = arrayList3.toArray(this.N);
    }

    private final void E(ClusterGraph clusterGraph, ClusterGraph clusterGraph2) {
        Point point = new Point();
        Collection collection = clusterGraph.getClusterModel().getClassifications();
        Collection collection2 = clusterGraph2.getClusterModel().getClassifications();
        ArrayList<SubClusterSprite> arrayList = new ArrayList<SubClusterSprite>(100);
        ArrayList<SubClusterSprite> arrayList2 = new ArrayList<SubClusterSprite>(100);
        ArrayList<SubClusterSprite> arrayList3 = new ArrayList<SubClusterSprite>(100);
        ArrayList<ClassEdgeSprite> arrayList4 = new ArrayList<ClassEdgeSprite>();
        ArrayList<ClassEdgeSprite> arrayList5 = new ArrayList<ClassEdgeSprite>();
        ArrayList<ClassEdgeSprite> arrayList6 = new ArrayList<ClassEdgeSprite>();
        ArrayList arrayList7 = new ArrayList(100);
        ArrayList arrayList8 = new ArrayList(100);
        ArrayList arrayList9 = new ArrayList(100);
        if (this.L) {
            ImageSprite imageSprite;
            Classification classification;
            Object object;
            Object object2;
            Object object32;
            Scheme scheme = this._newRendering.getGraphRenderingProperties().getScheme();
            Color color = scheme instanceof ClassificationIdentityScheme ? null : Scheme.CLUSTER_EDGE_BORDER_COLOR_NORMAL;
            Collection collection3 = this.E.getSubClusters();
            for (Object object32 : collection3) {
                boolean bl;
                object2 = object32.getFirstCluster();
                Cluster cluster = object32.getSecondCluster();
                SubClusterSprite subClusterSprite = new SubClusterSprite();
                this.A(subClusterSprite, (SubCluster)object32);
                if (object2 == null) {
                    subClusterSprite.diameter = this.A((SubCluster)object32, cluster, clusterGraph2, this._newRendering);
                    this.A(cluster, this._newRendering, this._newBoundingBox, subClusterSprite.diameter / 2, point);
                    subClusterSprite.newX = point.x;
                    subClusterSprite.newY = point.y;
                    subClusterSprite.oldX = subClusterSprite.newX;
                    subClusterSprite.oldY = subClusterSprite.newY;
                    arrayList3.add(subClusterSprite);
                    bl = true;
                    object = cluster.getClassifications();
                    if (object.size() == 1) {
                        classification = (Classification)object.iterator().next();
                        imageSprite = clusterGraph2.getVertexFor(classification);
                        bl = ((ClassificationRenderer)imageSprite.getRenderingAttribute()).isImageVisible();
                    }
                    if (!bl) continue;
                    this.A(subClusterSprite, cluster, color, this._newGraph, arrayList9);
                    continue;
                }
                if (cluster == null) {
                    subClusterSprite.diameter = this.A((SubCluster)object32, (Cluster)object2, clusterGraph, this._oldRendering);
                    this.A((Cluster)object2, this._oldRendering, this._oldBoundingBox, subClusterSprite.diameter / 2, point);
                    subClusterSprite.oldX = point.x;
                    subClusterSprite.oldY = point.y;
                    subClusterSprite.newX = subClusterSprite.oldX;
                    subClusterSprite.newY = subClusterSprite.oldY;
                    arrayList.add(subClusterSprite);
                    bl = true;
                    object = object2.getClassifications();
                    if (object.size() == 1) {
                        classification = (Classification)object.iterator().next();
                        imageSprite = clusterGraph.getVertexFor(classification);
                        bl = ((ClassificationRenderer)imageSprite.getRenderingAttribute()).isImageVisible();
                    }
                    if (!bl) continue;
                    this.A(subClusterSprite, (Cluster)object2, color, this._oldGraph, arrayList7);
                    continue;
                }
                subClusterSprite.oldDiameter = this.A((SubCluster)object32, (Cluster)object2, clusterGraph, this._oldRendering);
                this.A((Cluster)object2, this._oldRendering, this._oldBoundingBox, subClusterSprite.oldDiameter / 2, point);
                subClusterSprite.oldX = point.x;
                subClusterSprite.oldY = point.y;
                subClusterSprite.newDiameter = this.A((SubCluster)object32, cluster, clusterGraph2, this._newRendering);
                this.A(cluster, this._newRendering, this._newBoundingBox, subClusterSprite.newDiameter / 2, point);
                subClusterSprite.newX = point.x;
                subClusterSprite.newY = point.y;
                subClusterSprite.diameter = subClusterSprite.oldDiameter;
                arrayList2.add(subClusterSprite);
                this.A((SubCluster)object32, subClusterSprite, color, arrayList7, arrayList8, arrayList9);
            }
            object32 = new ArrayList(clusterGraph.getClassificationEdges());
            ((ArrayList)object32).addAll(clusterGraph2.getClassificationEdges());
            object2 = new ArrayList();
            int n = ((ArrayList)object32).size();
            int n2 = 0;
            while (n2 < n) {
                ClassificationEdge classificationEdge = (ClassificationEdge)((ArrayList)object32).get(n2);
                object = classificationEdge.getParentVertex().getClassification();
                classification = classificationEdge.getChildVertex().getClassification();
                if (!((ArrayList)object2).contains(classification)) {
                    ((ArrayList)object2).add(classification);
                    imageSprite = (ImageSprite)this.Q.get(object);
                    ImageSprite imageSprite2 = (ImageSprite)this.Q.get(classification);
                    ClassEdgeSprite classEdgeSprite = new ClassEdgeSprite(imageSprite, imageSprite2);
                    if (!collection2.contains(object) || !collection2.contains(classification)) {
                        arrayList4.add(classEdgeSprite);
                    } else if (!collection.contains(object) || !collection.contains(classification)) {
                        arrayList6.add(classEdgeSprite);
                    } else {
                        arrayList5.add(classEdgeSprite);
                    }
                }
                ++n2;
            }
        }
        this.a = new SubClusterSprite[arrayList.size()];
        this.a = arrayList.toArray(this.a);
        this.c = new SubClusterSprite[arrayList2.size()];
        this.c = arrayList2.toArray(this.c);
        this.d = new SubClusterSprite[arrayList3.size()];
        this.d = arrayList3.toArray(this.d);
        this.R = new ClassEdgeSprite[arrayList4.size()];
        this.R = arrayList4.toArray(this.R);
        this.O = new ClassEdgeSprite[arrayList5.size()];
        this.O = arrayList5.toArray(this.O);
        this.K = new ClassEdgeSprite[arrayList6.size()];
        this.K = arrayList6.toArray(this.K);
        this.V = new ClusterEdgeSprite[arrayList7.size()];
        this.V = arrayList7.toArray(this.V);
        this.h = new ClusterEdgeSprite[arrayList8.size()];
        this.h = arrayList8.toArray(this.h);
        this.S = new ClusterEdgeSprite[arrayList9.size()];
        this.S = arrayList9.toArray(this.S);
    }

    private final int A(SubCluster subCluster, Cluster cluster, ClusterGraph clusterGraph, ClusterGraphRendering clusterGraphRendering) {
        ClusterVertex clusterVertex = clusterGraph.getVertexFor(cluster);
        ClusterRenderer clusterRenderer = (ClusterRenderer)clusterGraph.getVertexFor(cluster).getRenderingAttribute();
        int n = clusterGraphRendering.getDiameter(clusterVertex);
        if (clusterRenderer.getDisplayMode() == GraphRenderingProperties.MULTIPLE_ENTITIES_MODE) {
            return n;
        }
        double d = (double)n / 2.0;
        double d2 = cluster.getSize();
        double d3 = subCluster.getSize();
        double d4 = Math.sqrt(d3 * d * d / d2);
        return (int)Math.round(2.0 * d4);
    }

    private final void A(Cluster cluster, ClusterGraphRendering clusterGraphRendering, Rectangle rectangle, int n, Point point) {
        Point point2 = new Point();
        clusterGraphRendering.getCoordinate(cluster, point2);
        point.x = point2.x - n - rectangle.x;
        point.y = point2.y - n - rectangle.y;
    }

    private void A(SubClusterSprite subClusterSprite, SubCluster subCluster) {
        Cluster cluster = subCluster.getFirstCluster();
        Cluster cluster2 = subCluster.getSecondCluster();
        if (cluster == null) {
            subClusterSprite.fillColor = this.A(cluster2, this._newGraph);
        } else if (cluster2 == null) {
            subClusterSprite.fillColor = this.A(cluster, this._oldGraph);
        } else {
            subClusterSprite.oldFillColor = this.A(cluster, this._oldGraph);
            subClusterSprite.newFillColor = this.A(cluster2, this._newGraph);
            subClusterSprite.fillColor = subClusterSprite.oldFillColor;
        }
    }

    private Color A(Cluster cluster, ClusterGraph clusterGraph) {
        ClusterVertex clusterVertex = clusterGraph.getVertexFor(cluster);
        ClusterRenderer clusterRenderer = (ClusterRenderer)clusterVertex.getRenderingAttribute();
        if (clusterRenderer.getDisplayMode() == GraphRenderingProperties.SINGLE_ENTITY_MODE) {
            return clusterRenderer.getFillColor();
        }
        double d = 255.0;
        double d2 = 255.0;
        double d3 = 255.0;
        List list = clusterVertex.getEdges();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ClusterEdge clusterEdge = (ClusterEdge)list.get(n2);
            ClusterEdgeRenderer clusterEdgeRenderer = (ClusterEdgeRenderer)clusterEdge.getRenderingAttribute();
            Color color = clusterEdgeRenderer.getFillColor();
            double d4 = (double)color.getAlpha() / 255.0;
            double d5 = 1.0 - d4;
            d = d4 * (double)color.getRed() + d5 * d;
            d2 = d4 * (double)color.getGreen() + d5 * d2;
            d3 = d4 * (double)color.getBlue() + d5 * d3;
            ++n2;
        }
        return new Color(this.A(d), this.A(d2), this.A(d3));
    }

    private final Object A(Vertex vertex) {
        if (vertex instanceof ObjectVertex) {
            return ((ObjectVertex)vertex).getObject();
        }
        return ((ClassificationVertex)vertex).getClassification();
    }

    private final void A(SubClusterSprite subClusterSprite, Cluster cluster, Color color, ClusterGraph clusterGraph, ArrayList arrayList) {
        if (this.L) {
            ClusterVertex clusterVertex = clusterGraph.getVertexFor(cluster);
            List list = clusterVertex.getEdges();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                ClusterEdge clusterEdge = (ClusterEdge)list.get(n2);
                Sprite sprite = (Sprite)this.Q.get(clusterEdge.getClassification());
                ClusterEdgeSprite clusterEdgeSprite = new ClusterEdgeSprite(sprite, subClusterSprite);
                clusterEdgeSprite.fillColor = this.A(clusterEdge);
                clusterEdgeSprite.borderColor = color;
                arrayList.add(clusterEdgeSprite);
                ++n2;
            }
        }
    }

    private Color A(ClusterEdge clusterEdge) {
        ClusterEdgeRenderer clusterEdgeRenderer = (ClusterEdgeRenderer)clusterEdge.getRenderingAttribute();
        Color color = clusterEdgeRenderer.getFillColor();
        double d = (double)color.getAlpha() / 255.0;
        double d2 = (1.0 - d) * 255.0;
        double d3 = d * (double)color.getRed() + d2;
        double d4 = d * (double)color.getGreen() + d2;
        double d5 = d * (double)color.getBlue() + d2;
        return new Color(this.A(d3), this.A(d4), this.A(d5));
    }

    private final void A(SubCluster subCluster, SubClusterSprite subClusterSprite, Color color, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        Sprite sprite;
        Sprite sprite2;
        Classification classification;
        if (!this.L) {
            return;
        }
        Cluster cluster = subCluster.getFirstCluster();
        Cluster cluster2 = subCluster.getSecondCluster();
        Collection collection = cluster.getMostSpecificClassifications();
        Collection collection2 = cluster2.getMostSpecificClassifications();
        ClusterVertex clusterVertex = this._oldGraph.getVertexFor(cluster);
        List list = clusterVertex.getEdges();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ClusterEdge clusterEdge = (ClusterEdge)list.get(n2);
            classification = clusterEdge.getClassification();
            sprite2 = (Sprite)this.Q.get(classification);
            sprite = new ClusterEdgeSprite(sprite2, subClusterSprite);
            sprite.borderColor = color;
            if (collection2.contains(classification)) {
                sprite.oldFillColor = this.A(clusterEdge);
                sprite.newFillColor = this.A(this.A(cluster2, classification, this._newGraph));
                sprite.fillColor = sprite.oldFillColor;
                arrayList2.add(sprite);
            } else {
                sprite.fillColor = this.A(clusterEdge);
                arrayList.add(sprite);
            }
            ++n2;
        }
        ClusterVertex clusterVertex2 = this._newGraph.getVertexFor(cluster2);
        list = clusterVertex2.getEdges();
        n = list.size();
        int n3 = 0;
        while (n3 < n) {
            classification = (ClusterEdge)list.get(n3);
            sprite2 = classification.getClassification();
            if (!collection.contains(sprite2)) {
                sprite = (Sprite)this.Q.get(sprite2);
                ClusterEdgeSprite clusterEdgeSprite = new ClusterEdgeSprite(sprite, subClusterSprite);
                clusterEdgeSprite.fillColor = this.A((ClusterEdge)classification);
                clusterEdgeSprite.borderColor = color;
                arrayList3.add(clusterEdgeSprite);
            }
            ++n3;
        }
    }

    private ClusterEdge A(Cluster cluster, Classification classification, ClusterGraph clusterGraph) {
        ClusterVertex clusterVertex = clusterGraph.getVertexFor(cluster);
        List list = clusterVertex.getEdges();
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ClusterEdge clusterEdge = (ClusterEdge)list.get(n2);
            if (clusterEdge.getClassification() == classification) {
                return clusterEdge;
            }
            ++n2;
        }
        throw new IllegalStateException("edge not found");
    }

    private final void A(long l) {
        this.D = (long)(0.35 * (double)l);
        this.I = (long)(0.30000000000000004 * (double)l);
        this.P = (long)(0.35 * (double)l);
        if (this.A.length == 0 && this.M.length == 0 && this.a.length == 0 && this.R.length == 0 && this.V.length == 0) {
            this.D = 0L;
        }
        if (this.H.length == 0 && this.Z.length == 0 && this.c.length == 0 && this.O.length == 0 && this.h.length == 0) {
            this.I = 0L;
        }
        if (this.Y.length == 0 && this.N.length == 0 && this.d.length == 0 && this.K.length == 0 && this.S.length == 0) {
            this.P = 0L;
        }
    }

    public void cleanUp() {
        this.A = null;
        this.M = null;
        this.a = null;
        this.R = null;
        this.V = null;
        this.H = null;
        this.Z = null;
        this.c = null;
        this.O = null;
        this.h = null;
        this.Y = null;
        this.N = null;
        this.d = null;
        this.K = null;
        this.S = null;
        this.Q.clear();
        this.f.clear();
        this.i = null;
        this.E = null;
    }

    public void prepareForFrame(long l) {
        this.J = l;
        if (l < this.D) {
            this.G = FIRST_PHASE;
            this.B();
        } else if (l < this.D + this.I) {
            this.G = SECOND_PHASE;
            this.A();
        } else {
            this.G = THIRD_PHASE;
            this.C();
        }
    }

    private final void B() {
        if (!this.W) {
            this.C = this._oldMargin.left;
            this.T = this._oldMargin.top;
            this.U = this._oldScale;
            this.A(this.H);
            this.A(this.Z);
            this.A(this.c);
            this.A(this.A);
            this.A(this.M);
            this.A(this.a);
            this.A(this.R);
            this.A(this.V);
            this.A(this.O);
            this.A(this.h);
            int n = 0;
            while (n < this.A.length) {
                ImageSprite imageSprite = this.A[n];
                imageSprite.baseImage = imageSprite.image;
                ++n;
            }
            this.W = true;
        }
        float f = (float)(this.D - this.J) / (float)this.D;
        f = this.A(f);
        int n = 0;
        while (n < this.A.length) {
            ImageSprite imageSprite = this.A[n];
            if (imageSprite.baseImage != null) {
                imageSprite.image = this.A(imageSprite.baseImage, f);
            }
            ++n;
        }
    }

    private final void A() {
        Color color;
        Color color2;
        Sprite sprite;
        float f;
        this.b = f = (float)(this.J - this.D) / (float)this.I;
        float f2 = 1.0f - f;
        this.C = f * (float)this._newMargin.left + f2 * (float)this._oldMargin.left;
        this.T = f * (float)this._newMargin.top + f2 * (float)this._oldMargin.top;
        this.U = (double)f * this._newScale + (double)f2 * this._oldScale;
        this.C(this.H);
        this.C(this.Z);
        this.C(this.c);
        int n = 0;
        while (n < this.c.length) {
            sprite = this.c[n];
            sprite.diameter = sprite.oldDiameter + (int)(f * (float)(sprite.newDiameter - sprite.oldDiameter));
            color2 = sprite.oldFillColor;
            color = sprite.newFillColor;
            sprite.fillColor = color2 == color ? color : new Color(this.A(f2 * (float)color2.getRed() + f * (float)color.getRed()), this.A(f2 * (float)color2.getGreen() + f * (float)color.getGreen()), this.A(f2 * (float)color2.getBlue() + f * (float)color.getBlue()));
            ++n;
        }
        n = 0;
        while (n < this.h.length) {
            sprite = this.h[n];
            color2 = ((ClusterEdgeSprite)sprite).oldFillColor;
            color = ((ClusterEdgeSprite)sprite).newFillColor;
            ((ClusterEdgeSprite)sprite).fillColor = new Color(this.A(f2 * (float)color2.getRed() + f * (float)color.getRed()), this.A(f2 * (float)color2.getGreen() + f * (float)color.getGreen()), this.A(f2 * (float)color2.getBlue() + f * (float)color.getBlue()));
            ++n;
        }
        this.A(this.O);
        this.A(this.h);
    }

    private int A(double d) {
        int n = (int)d;
        n = Math.max(n, 0);
        n = Math.min(n, 255);
        return n;
    }

    private final void C() {
        if (!this.B) {
            this.C = this._newMargin.left;
            this.T = this._newMargin.top;
            this.U = this._newScale;
            this.B(this.H);
            this.B(this.Z);
            this.B(this.c);
            this.B(this.Y);
            this.B(this.N);
            this.B(this.d);
            this.A(this.O);
            this.A(this.h);
            this.A(this.K);
            this.A(this.S);
            int n = 0;
            while (n < this.Y.length) {
                ImageSprite imageSprite = this.Y[n];
                imageSprite.baseImage = imageSprite.image;
                ++n;
            }
            this.B = true;
        }
        float f = (float)(this.J - this.I - this.D) / (float)this.P;
        f = this.A(f);
        int n = 0;
        while (n < this.Y.length) {
            ImageSprite imageSprite = this.Y[n];
            if (imageSprite.baseImage != null) {
                imageSprite.image = this.A(imageSprite.baseImage, f);
            }
            ++n;
        }
    }

    private final void A(Sprite[] spriteArray) {
        int n = 0;
        while (n < spriteArray.length) {
            Sprite sprite = spriteArray[n];
            sprite.x = sprite.oldX;
            sprite.y = sprite.oldY;
            ++n;
        }
    }

    private final void B(Sprite[] spriteArray) {
        int n = 0;
        while (n < spriteArray.length) {
            Sprite sprite = spriteArray[n];
            sprite.x = sprite.newX;
            sprite.y = sprite.newY;
            ++n;
        }
    }

    private final void A(EdgeSprite[] edgeSpriteArray) {
        int n = 0;
        while (n < edgeSpriteArray.length) {
            edgeSpriteArray[n].prepare();
            ++n;
        }
    }

    private final void C(Sprite[] spriteArray) {
        float f = this.b;
        float f2 = 1.0f - f;
        int n = 0;
        while (n < spriteArray.length) {
            Sprite sprite = spriteArray[n];
            sprite.x = (int)(f * (float)sprite.newX + f2 * (float)sprite.oldX);
            sprite.y = (int)(f * (float)sprite.newY + f2 * (float)sprite.oldY);
            ++n;
        }
    }

    private final BufferedImage A(Image image, float f) {
        if (image == this.i && f == this._) {
            return this.j;
        }
        this.i = image;
        this._ = f;
        AlphaImageKey alphaImageKey = new AlphaImageKey(image, f);
        BufferedImage bufferedImage = (BufferedImage)this.f.get(alphaImageKey);
        if (bufferedImage != null) {
            this.j = bufferedImage;
            return bufferedImage;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.sanitizeAlpha(f)));
        graphics2D.drawImage(image, 0, 0, null);
        this.f.put(alphaImageKey, bufferedImage2);
        this.j = bufferedImage2;
        return bufferedImage2;
    }

    private float sanitizeAlpha(float f) {
        return Math.max(0.0f, Math.min(1.0f, f));
    }

    private final float A(float f) {
        float f2 = Math.min(f, 1.0f);
        f2 = Math.max(f2, 0.0f);
        return f2;
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.translate(this.C, this.T);
        graphics2D.scale(this.U, this.U);
        graphics2D.setFont(this.g);
        if (this.G == FIRST_PHASE) {
            this.C(graphics2D);
        } else if (this.G == SECOND_PHASE) {
            this.A(graphics2D);
        } else {
            this.B(graphics2D);
        }
    }

    private final void C(Graphics2D graphics2D) {
        this.A(this.h, graphics2D);
        this.A(this.O, graphics2D);
        Composite composite = graphics2D.getComposite();
        float f = (float)(this.D - this.J) / (float)this.D;
        f = this.A(f);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.sanitizeAlpha(f));
        graphics2D.setComposite(alphaComposite);
        this.A(this.V, graphics2D);
        this.A(this.R, graphics2D);
        this.A(this.a, graphics2D);
        graphics2D.setComposite(composite);
        this.A(this.c, graphics2D);
        this.A(this.H, graphics2D);
        this.A(this.A, graphics2D);
        graphics2D.setColor(Color.black);
        this.A(this.Z, graphics2D);
        graphics2D.setComposite(alphaComposite);
        this.A(this.M, graphics2D);
    }

    private final void A(Graphics2D graphics2D) {
        this.A(this.h, graphics2D);
        this.A(this.O, graphics2D);
        this.A(this.c, graphics2D);
        this.A(this.H, graphics2D);
        graphics2D.setColor(Color.black);
        this.A(this.Z, graphics2D);
    }

    private final void B(Graphics2D graphics2D) {
        this.A(this.h, graphics2D);
        this.A(this.O, graphics2D);
        Composite composite = graphics2D.getComposite();
        float f = (float)(this.J - this.I - this.D) / (float)this.P;
        f = this.A(f);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.sanitizeAlpha(f));
        graphics2D.setComposite(alphaComposite);
        this.A(this.S, graphics2D);
        this.A(this.K, graphics2D);
        this.A(this.d, graphics2D);
        graphics2D.setComposite(composite);
        this.A(this.c, graphics2D);
        this.A(this.H, graphics2D);
        this.A(this.Y, graphics2D);
        graphics2D.setColor(Color.black);
        this.A(this.Z, graphics2D);
        graphics2D.setComposite(alphaComposite);
        this.A(this.N, graphics2D);
    }

    private final void A(Sprite[] spriteArray, Graphics2D graphics2D) {
        int n = 0;
        while (n < spriteArray.length) {
            spriteArray[n].draw(graphics2D);
            ++n;
        }
    }

    public long getNeededDuration() {
        return this.D + this.I + this.P;
    }

    public Dimension getSize() throws IllegalStateException {
        if (this.G == FIRST_PHASE) {
            return new Dimension(this._oldSize);
        }
        if (this.G == SECOND_PHASE) {
            float f = 1.0f - this.b;
            return new Dimension((int)(this.b * (float)this._newSize.width + f * (float)this._oldSize.width), (int)(this.b * (float)this._newSize.height + f * (float)this._oldSize.height));
        }
        if (this.G == THIRD_PHASE) {
            return new Dimension(this._newSize);
        }
        throw new IllegalStateException("no current phase has been set yet");
    }

    public static class AlphaImageKey {
        public Image image;
        public float alpha;

        public boolean equals(Object object) {
            AlphaImageKey alphaImageKey = (AlphaImageKey)object;
            return this.image == alphaImageKey.image && this.alpha == alphaImageKey.alpha;
        }

        public int hashCode() {
            return this.image.hashCode() + (int)(100.0f * this.alpha);
        }

        public AlphaImageKey(Image image, float f) {
            this.image = image;
            this.alpha = f;
        }
    }

    protected static class ClassEdgeSprite
    extends EdgeSprite {
        public Sprite firstSprite;
        public Sprite secondSprite;
        public int x1;
        public int y1;
        public int x2;
        public int y2;

        @Override
        public void prepare() {
            this.x1 = this.firstSprite.x + this.firstSprite.width / 2;
            this.y1 = this.firstSprite.y + this.firstSprite.height / 2;
            this.x2 = this.secondSprite.x + this.secondSprite.width / 2;
            this.y2 = this.secondSprite.y + this.secondSprite.height / 2;
        }

        @Override
        public void draw(Graphics2D graphics2D) {
            graphics2D.setColor(CLASS_EDGE_COLOR);
            graphics2D.setStroke(new BasicStroke(1.5f));
            graphics2D.drawLine(this.x1, this.y1, this.x2, this.y2);
        }

        public ClassEdgeSprite(Sprite sprite, Sprite sprite2) {
            this.firstSprite = sprite;
            this.secondSprite = sprite2;
        }
    }

    protected static class ClusterEdgeSprite
    extends EdgeSprite {
        public Sprite classSprite;
        public SubClusterSprite subClusterSprite;
        public GeneralPath shape;
        public Color oldFillColor;
        public Color newFillColor;
        public Color fillColor;
        public Color borderColor;

        @Override
        public void prepare() {
            int n = this.classSprite.x + this.classSprite.width / 2;
            int n2 = this.classSprite.y + this.classSprite.height / 2;
            int n3 = this.subClusterSprite.diameter / 2;
            int n4 = (n3 = (int)((double)n3 * 0.7)) * n3;
            int n5 = this.subClusterSprite.x + n3;
            int n6 = n5 - n;
            int n7 = this.subClusterSprite.y + n3;
            int n8 = n7 - n2;
            int n9 = n6 * n6 + n8 * n8;
            if (n4 < n9) {
                double d = Math.sqrt(n9 - n4);
                double d2 = 0.0;
                if (n6 == 0) {
                    d2 = n8 > 0 ? 1.5707963267948966 : -1.5707963267948966;
                } else {
                    d2 = Math.atan((double)n8 / (double)n6);
                    if (n6 < 0) {
                        d2 += Math.PI;
                    }
                }
                double d3 = Math.asin((double)n3 / Math.sqrt(n9));
                double d4 = d2 - d3;
                double d5 = d2 + d3;
                this.shape = new GeneralPath(0, 3);
                this.shape.moveTo(n, n2);
                this.shape.lineTo((int)(d * Math.cos(d4)) + n, (int)(d * Math.sin(d4)) + n2);
                this.shape.lineTo((int)(d * Math.cos(d5)) + n, (int)(d * Math.sin(d5)) + n2);
                this.shape.closePath();
            } else {
                this.shape = null;
            }
        }

        @Override
        public void draw(Graphics2D graphics2D) {
            if (this.shape != null) {
                if (this.fillColor != null) {
                    graphics2D.setColor(this.fillColor);
                    graphics2D.fill(this.shape);
                }
                if (this.borderColor != null) {
                    graphics2D.setColor(this.borderColor);
                    graphics2D.draw(this.shape);
                }
            }
        }

        public ClusterEdgeSprite(Sprite sprite, SubClusterSprite subClusterSprite) {
            this.classSprite = sprite;
            this.subClusterSprite = subClusterSprite;
        }
    }

    protected static abstract class EdgeSprite
    extends Sprite {
        public abstract void prepare();

        protected EdgeSprite() {
        }
    }

    protected static class ImageSprite
    extends Sprite {
        public Image image;
        public Image baseImage;

        @Override
        public void draw(Graphics2D graphics2D) {
            if (this.image != null) {
                graphics2D.drawImage(this.image, this.x, this.y, null);
            }
        }

        public ImageSprite(Image image) {
            this.image = image;
            if (image != null) {
                this.width = image.getWidth(null);
                this.height = image.getHeight(null);
            }
        }
    }

    protected static abstract class Sprite {
        public int x;
        public int y;
        public int oldX;
        public int oldY;
        public int newX;
        public int newY;
        public int width;
        public int height;

        public abstract void draw(Graphics2D var1);

        protected Sprite() {
        }
    }

    protected static class SubClusterSprite
    extends Sprite {
        public int oldDiameter;
        public int newDiameter;
        public int diameter;
        public Color oldFillColor;
        public Color newFillColor;
        public Color fillColor;

        @Override
        public void draw(Graphics2D graphics2D) {
            this._drawDisc(graphics2D);
        }

        protected void _drawDisc(Graphics2D graphics2D) {
            if (this.fillColor != null) {
                graphics2D.setColor(this.fillColor);
                graphics2D.fillOval(this.x, this.y, this.diameter, this.diameter);
            }
            graphics2D.setColor(EDGE_BORDER_COLOR);
            graphics2D.drawOval(this.x, this.y, this.diameter, this.diameter);
        }

        protected SubClusterSprite() {
        }
    }

    protected static class TextSprite
    extends Sprite {
        public String text;

        @Override
        public void draw(Graphics2D graphics2D) {
            graphics2D.drawString(this.text, this.x, this.y);
        }

        public TextSprite(String string) {
            this.text = string;
        }
    }
}

