/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.vis.aduna;

import biz.aduna.map.cluster.Classification;
import biz.aduna.map.cluster.ClusterGraphPanel;
import biz.aduna.map.cluster.ClusterMap;
import biz.aduna.map.cluster.ClusterMapFactory;
import biz.aduna.map.cluster.ClusterMapMediator;
import biz.aduna.map.cluster.DefaultClassification;
import biz.aduna.map.cluster.DefaultObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.carrot2.core.Cluster;
import org.carrot2.core.Document;
import org.carrot2.core.ProcessingResult;
import org.carrot2.workbench.core.helpers.DisposeBin;
import org.carrot2.workbench.core.helpers.PostponableJob;
import org.carrot2.workbench.core.ui.ISearchResultListener;
import org.carrot2.workbench.core.ui.PropertyChangeListenerAdapter;
import org.carrot2.workbench.core.ui.SearchEditor;
import org.carrot2.workbench.core.ui.SearchResultListenerAdapter;
import org.carrot2.workbench.core.ui.actions.ExportImageAction;
import org.carrot2.workbench.core.ui.actions.IImageStreamProvider;
import org.carrot2.workbench.vis.aduna.AdunaActivator;
import org.carrot2.workbench.vis.aduna.VisualizationMode;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.UIJob;

final class AdunaClusterMapViewPage
extends Page {
    private final int REFRESH_DELAY = 500;
    private DefaultClassification root;
    private Map<Integer, DefaultClassification> clusterMap = Maps.newHashMap();
    private Map<String, DefaultObject> documentMap = Maps.newHashMap();
    private PostponableJob selectionJob = new PostponableJob((Job)new UIJob("Aduna ClusterMap (selection)..."){
        private IStructuredSelection currentlyDisplayed;
        {
            this.currentlyDisplayed = null;
        }

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            VisualizationMode visualizationMode = VisualizationMode.valueOf(AdunaActivator.plugin.getPreferenceStore().getString("visualization-mode"));
            if (AdunaClusterMapViewPage.this.root != null) {
                IStructuredSelection iStructuredSelection;
                final IStructuredSelection iStructuredSelection2 = this.getSelected();
                switch (visualizationMode) {
                    case SHOW_ALL_CLUSTERS: {
                        iStructuredSelection = this.getAll();
                        break;
                    }
                    case SHOW_FIRST_LEVEL_CLUSTERS: {
                        iStructuredSelection = this.getFirstLevel();
                        break;
                    }
                    case SHOW_SELECTED_CLUSTERS: {
                        iStructuredSelection = iStructuredSelection2;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhanded case: " + (Object)((Object)visualizationMode));
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!iStructuredSelection.equals(currentlyDisplayed)) {
                            AdunaClusterMapViewPage.this.mapMediator.visualize(this.selectionToClassification(iStructuredSelection));
                            currentlyDisplayed = iStructuredSelection;
                        }
                        AdunaClusterMapViewPage.this.mapMediator.select((Collection)this.selectionToClassification(iStructuredSelection2));
                    }
                });
            }
            return Status.OK_STATUS;
        }

        private List<Classification> selectionToClassification(IStructuredSelection iStructuredSelection) {
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            ArrayList arrayList = Lists.newArrayList();
            for (Object e : iStructuredSelection.toList()) {
                Classification classification;
                if (e != null && e instanceof Classification) {
                    arrayList.add((Classification)e);
                    continue;
                }
                Cluster cluster = (Cluster)iAdapterManager.getAdapter(e, Cluster.class);
                if (cluster == null || (classification = (Classification)AdunaClusterMapViewPage.this.clusterMap.get(cluster.getId())) == null) continue;
                arrayList.add(classification);
            }
            return arrayList;
        }

        private IStructuredSelection getSelected() {
            ISelectionProvider iSelectionProvider = AdunaClusterMapViewPage.this.editor.getSite().getSelectionProvider();
            ISelection iSelection = iSelectionProvider.getSelection();
            return (IStructuredSelection)iSelection;
        }

        private IStructuredSelection getFirstLevel() {
            if (AdunaClusterMapViewPage.this.root == null) {
                return StructuredSelection.EMPTY;
            }
            return new StructuredSelection(AdunaClusterMapViewPage.this.root.getChildren().toArray());
        }

        protected IStructuredSelection getAll() {
            if (AdunaClusterMapViewPage.this.root == null) {
                return StructuredSelection.EMPTY;
            }
            ArrayList arrayList = Lists.newArrayList();
            LinkedList linkedList = Lists.newLinkedList();
            linkedList.add(AdunaClusterMapViewPage.this.root);
            while (!linkedList.isEmpty()) {
                Classification classification = (Classification)linkedList.remove(0);
                arrayList.add(classification);
                linkedList.addAll(classification.getChildren());
            }
            return new StructuredSelection((List)arrayList);
        }
    });
    private PostponableJob refreshJob = new PostponableJob((Job)new UIJob("Aduna ClusterMap (full refresh)..."){

        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
            ProcessingResult processingResult = AdunaClusterMapViewPage.this.editor.getSearchResult().getProcessingResult();
            if (processingResult != null) {
                AdunaClusterMapViewPage.this.root = new DefaultClassification("All clusters");
                AdunaClusterMapViewPage.this.clusterMap = Maps.newHashMap();
                AdunaClusterMapViewPage.this.documentMap = Maps.newHashMap();
                this.toClassification(AdunaClusterMapViewPage.this.root, processingResult.getClusters());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AdunaClusterMapViewPage.this.mapMediator.setClassificationTree((Classification)AdunaClusterMapViewPage.this.root);
                    }
                });
                AdunaClusterMapViewPage.this.selectionJob.reschedule(0);
            }
            return Status.OK_STATUS;
        }

        private void toClassification(DefaultClassification defaultClassification, List<Cluster> list) {
            for (Cluster cluster : list) {
                if (AdunaClusterMapViewPage.this.clusterMap.containsKey(cluster.getId())) continue;
                DefaultClassification defaultClassification2 = new DefaultClassification(cluster.getLabel(), (Classification)defaultClassification);
                AdunaClusterMapViewPage.this.clusterMap.put(cluster.getId(), defaultClassification2);
                for (Document document : cluster.getAllDocuments()) {
                    if (!AdunaClusterMapViewPage.this.documentMap.containsKey(document.getStringId())) {
                        String string = (String)document.getField("title");
                        String string2 = "[" + document.getStringId() + "]";
                        if (!StringUtils.isEmpty((String)string)) {
                            string2 = String.valueOf(string2) + " " + string;
                        }
                        AdunaClusterMapViewPage.this.documentMap.put(document.getStringId(), new DefaultObject(string2));
                    }
                    defaultClassification2.add(AdunaClusterMapViewPage.this.documentMap.get(document.getStringId()));
                }
                this.toClassification(defaultClassification2, cluster.getSubclusters());
            }
        }
    });
    private final SearchResultListenerAdapter editorSyncListener = new SearchResultListenerAdapter(){

        public void processingResultUpdated(ProcessingResult processingResult) {
            AdunaClusterMapViewPage.this.refreshJob.reschedule(500);
        }
    };
    private final ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            AdunaClusterMapViewPage.this.selectionJob.reschedule(500);
        }
    };
    private SearchEditor editor;
    private Composite scrollable;
    private DisposeBin disposeBin = new DisposeBin();
    private ClusterMapMediator mapMediator;
    private IPropertyChangeListener viewModeListener = new PropertyChangeListenerAdapter("visualization-mode"){

        protected void propertyChangeFiltered(PropertyChangeEvent propertyChangeEvent) {
            AdunaClusterMapViewPage.this.selectionJob.reschedule(500);
        }
    };
    private Composite embedded;
    private volatile Dimension graphPanelSize;

    public AdunaClusterMapViewPage(SearchEditor searchEditor) {
        this.editor = searchEditor;
    }

    public void init(IPageSite iPageSite) {
        super.init(iPageSite);
        iPageSite.getActionBars().getToolBarManager().add((IAction)new ExportImageAction(new IImageStreamProvider(){

            public void save(OutputStream outputStream) throws IOException {
                AdunaClusterMapViewPage.this.mapMediator.getClusterMap().exportPngImage(outputStream);
            }
        }));
    }

    public void createControl(Composite composite) {
        this.createAdunaControl(composite);
        this.disposeBin.add((Widget)this.scrollable);
        this.disposeBin.registerPropertyChangeListener(AdunaActivator.plugin.getPreferenceStore(), this.viewModeListener);
        if (this.editor.getSearchResult().getProcessingResult() != null) {
            this.refreshJob.reschedule(500);
        }
        this.editor.getSearchResult().addListener((ISearchResultListener)this.editorSyncListener);
        this.editor.getSite().getSelectionProvider().addSelectionChangedListener(this.selectionListener);
    }

    private void createAdunaControl(Composite composite) {
        ClusterMapMediator clusterMapMediator;
        System.setProperty("sun.awt.noerasebackground", "true");
        this.scrollable = new Composite(composite, 768);
        this.scrollable.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginBottom = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.scrollable.setLayout((Layout)gridLayout);
        this.embedded = new Composite(this.scrollable, 0x1040000);
        this.embedded.setLayoutData((Object)new GridData(4, 4, true, true));
        Frame frame = SWT_AWT.new_Frame((Composite)this.embedded);
        frame.setLayout(new BorderLayout());
        JApplet jApplet = new JApplet();
        frame.add(jApplet);
        jApplet.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(21, 31);
        jScrollPane.setDoubleBuffered(true);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jApplet.getContentPane().add((Component)jScrollPane, "Center");
        ClusterMapFactory clusterMapFactory = ClusterMapFactory.createFactory();
        ClusterMap clusterMap = clusterMapFactory.createClusterMap();
        this.mapMediator = clusterMapMediator = clusterMapFactory.createMediator(clusterMap);
        final ClusterGraphPanel clusterGraphPanel = clusterMapMediator.getGraphPanel();
        clusterGraphPanel.setDoubleBuffered(true);
        jScrollPane.setViewportView((Component)clusterGraphPanel);
        this.scrollable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                AdunaClusterMapViewPage.this.updateScrollBars();
            }
        });
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ScrollBar scrollBar = AdunaClusterMapViewPage.this.scrollable.getHorizontalBar();
                ScrollBar scrollBar2 = AdunaClusterMapViewPage.this.scrollable.getVerticalBar();
                final Rectangle rectangle = new Rectangle(scrollBar.getSelection(), scrollBar2.getSelection(), scrollBar.getThumb(), scrollBar2.getThumb());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        clusterGraphPanel.scrollRectToVisible(rectangle);
                    }
                });
            }
        };
        this.scrollable.getVerticalBar().addSelectionListener((SelectionListener)selectionAdapter);
        this.scrollable.getHorizontalBar().addSelectionListener((SelectionListener)selectionAdapter);
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AdunaClusterMapViewPage.this.updateScrollBars();
            }
        };
        clusterGraphPanel.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                AdunaClusterMapViewPage.this.graphPanelSize = clusterGraphPanel.getPreferredSize();
                Display.getDefault().asyncExec(runnable);
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                AdunaClusterMapViewPage.this.graphPanelSize = clusterGraphPanel.getPreferredSize();
                Display.getDefault().asyncExec(runnable);
            }
        });
    }

    protected void updateScrollBars() {
        if (Display.findDisplay((Thread)Thread.currentThread()) == null) {
            throw new IllegalStateException("Not an SWT thread: " + Thread.currentThread());
        }
        if (this.graphPanelSize == null) {
            return;
        }
        org.eclipse.swt.graphics.Rectangle rectangle = this.scrollable.getClientArea();
        int n = Math.max(this.graphPanelSize.width, 0);
        int n2 = Math.max(rectangle.width, 0);
        AdunaClusterMapViewPage.updateScrollBar(this.scrollable.getHorizontalBar(), n, n2);
        int n3 = Math.max(this.graphPanelSize.height, 0);
        int n4 = Math.max(rectangle.height, 0);
        AdunaClusterMapViewPage.updateScrollBar(this.scrollable.getVerticalBar(), n3, n4);
    }

    private static void updateScrollBar(ScrollBar scrollBar, int n, int n2) {
        int n3 = scrollBar.getSelection();
        int n4 = 0;
        int n5 = n;
        int n6 = Math.min(n2, n);
        int n7 = 64;
        int n8 = Math.max(n6 - 5 * n6 / 100, 5);
        scrollBar.setValues(n3, n4, n5, n6, n7, n8);
    }

    public Control getControl() {
        return this.scrollable;
    }

    public void dispose() {
        this.editor.getSearchResult().removeListener((ISearchResultListener)this.editorSyncListener);
        this.editor.getSite().getSelectionProvider().removeSelectionChangedListener(this.selectionListener);
        this.disposeBin.dispose();
        super.dispose();
    }

    public void setFocus() {
    }
}

