/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

final class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction closeOthersAction;
    private ActionFactory.IWorkbenchAction openPreferencesAction;
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private IContributionItem changePerspMenuItem;
    private IContributionItem showViewMenu;

    public ApplicationActionBarAdvisor(IActionBarConfigurer iActionBarConfigurer) {
        super(iActionBarConfigurer);
    }

    protected void makeActions(IWorkbenchWindow iWorkbenchWindow) {
        this.exitAction = ActionFactory.QUIT.create(iWorkbenchWindow);
        this.register((IAction)this.exitAction);
        this.saveAsAction = ActionFactory.SAVE_AS.create(iWorkbenchWindow);
        this.register((IAction)this.saveAsAction);
        this.closeAction = ActionFactory.CLOSE.create(iWorkbenchWindow);
        this.register((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(iWorkbenchWindow);
        this.register((IAction)this.closeAllAction);
        this.closeOthersAction = ActionFactory.CLOSE_OTHERS.create(iWorkbenchWindow);
        this.register((IAction)this.closeOthersAction);
        this.aboutAction = ActionFactory.ABOUT.create(iWorkbenchWindow);
        this.register((IAction)this.aboutAction);
        this.openPreferencesAction = ActionFactory.PREFERENCES.create(iWorkbenchWindow);
        this.register((IAction)this.openPreferencesAction);
        this.changePerspMenuItem = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(iWorkbenchWindow);
        this.showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(iWorkbenchWindow);
    }

    protected void fillCoolBar(ICoolBarManager iCoolBarManager) {
        super.fillCoolBar(iCoolBarManager);
        ToolBarManager toolBarManager = new ToolBarManager(iCoolBarManager.getStyle());
        toolBarManager.add((IAction)this.saveAsAction);
        toolBarManager.add((IContributionItem)new Separator("additions"));
        iCoolBarManager.add((IToolBarManager)toolBarManager);
    }

    protected void fillMenuBar(IMenuManager iMenuManager) {
        MenuManager menuManager = new MenuManager("&File", "org.carrot2.menus.file");
        menuManager.add((IAction)this.closeAction);
        menuManager.add((IAction)this.closeAllAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.saveAsAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.exitAction);
        MenuManager menuManager2 = new MenuManager("&About", "org.carrot2.menus.about");
        menuManager2.add((IContributionItem)new GroupMarker("additions"));
        menuManager2.add((IAction)this.aboutAction);
        MenuManager menuManager3 = new MenuManager("Open Perspective", "org.carrot2.menus.openperspective");
        menuManager3.add(this.changePerspMenuItem);
        MenuManager menuManager4 = new MenuManager("Show view", "org.carrot2.menus.showview");
        menuManager4.add(this.showViewMenu);
        MenuManager menuManager5 = new MenuManager("&Window", "org.carrot2.menus.window");
        menuManager5.add((IContributionItem)menuManager3);
        menuManager5.add((IContributionItem)menuManager4);
        menuManager5.add((IAction)this.openPreferencesAction);
        iMenuManager.add((IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)new GroupMarker("additions"));
        iMenuManager.add((IContributionItem)menuManager5);
        iMenuManager.add((IContributionItem)menuManager2);
    }
}

