/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.carrot2.core.ProcessingComponentDescriptor;
import org.carrot2.workbench.core.ApplicationActionBarAdvisor;
import org.carrot2.workbench.core.WorkbenchCorePlugin;
import org.carrot2.workbench.core.helpers.Utils;
import org.carrot2.workbench.core.ui.actions.DisplayWelcomeView;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.views.IViewDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationWorkbenchWindowAdvisor.class);

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer) {
        super(iWorkbenchWindowConfigurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer iActionBarConfigurer) {
        return new ApplicationActionBarAdvisor(iActionBarConfigurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer iWorkbenchWindowConfigurer = this.getWindowConfigurer();
        Monitor monitor = Display.getDefault().getPrimaryMonitor();
        Rectangle rectangle = monitor.getBounds();
        int n = this.calculateInitialSize(rectangle.width, 800);
        int n2 = this.calculateInitialSize(rectangle.height, 600);
        iWorkbenchWindowConfigurer.setInitialSize(new Point(n, n2));
        iWorkbenchWindowConfigurer.setShowStatusLine(true);
        iWorkbenchWindowConfigurer.setShowMenuBar(true);
        iWorkbenchWindowConfigurer.setShowPerspectiveBar(true);
        iWorkbenchWindowConfigurer.setShowProgressIndicator(true);
        iWorkbenchWindowConfigurer.setShowCoolBar(true);
    }

    public void postWindowCreate() {
        this.logContributionIdentifiers();
        IWorkbenchWindow iWorkbenchWindow = this.getWindowConfigurer().getWindow();
        IPerspectiveRegistry iPerspectiveRegistry = iWorkbenchWindow.getWorkbench().getPerspectiveRegistry();
        String[] stringArray = new String[]{"org.carrot2.workbench.core.perspective.visualization", "org.carrot2.workbench.core.perspective.tuning", "org.carrot2.workbench.core.perspective.search"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            iWorkbenchWindow.getActivePage().setPerspective(iPerspectiveRegistry.findPerspectiveWithId(string));
            ++n2;
        }
    }

    private void logContributionIdentifiers() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        ICoolBarManager iCoolBarManager = this.getWindowConfigurer().getActionBarConfigurer().getCoolBarManager();
        stringBuilder.append("Toolbar contributions:\n");
        IPreferenceNode iPreferenceNode2 = iCoolBarManager.getItems();
        int n = ((IContributionItem[])iPreferenceNode2).length;
        int n2 = 0;
        while (n2 < n) {
            object = iPreferenceNode2[n2];
            stringBuilder.append(String.valueOf(object.getId()) + " (" + object.getClass().getSimpleName() + ")");
            stringBuilder.append("\n");
            ++n2;
        }
        logger.debug(stringBuilder.toString());
        stringBuilder.setLength(0);
        object = new Stack();
        ((Stack)object).push(this.getWindowConfigurer().getActionBarConfigurer().getMenuManager());
        stringBuilder.append("Menu contributions:\n");
        while (!((Vector)object).isEmpty()) {
            IContributionItem iContributionItem = (IContributionItem)((Stack)object).pop();
            stringBuilder.append(String.valueOf(iContributionItem.getId()) + " (" + iContributionItem.getClass().getSimpleName() + ")");
            stringBuilder.append("\n");
            if (!(iContributionItem instanceof IMenuManager)) continue;
            IMenuManager iMenuManager = (IMenuManager)iContributionItem;
            ((Vector)object).addAll(Arrays.asList(iMenuManager.getItems()));
        }
        logger.debug(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("Preference page contributions:\n");
        PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
        List list = preferenceManager.getElements(0);
        for (IPreferenceNode iPreferenceNode2 : list) {
            stringBuilder.append(String.valueOf(iPreferenceNode2.getId()) + " (" + iPreferenceNode2.getLabelText() + ")\n");
        }
        logger.debug(stringBuilder.toString());
        stringBuilder.setLength(0);
        stringBuilder.append("View contributions:\n");
        IViewDescriptor[] iViewDescriptorArray = this.getWindowConfigurer().getWorkbenchConfigurer().getWorkbench().getViewRegistry().getViews();
        int n3 = iViewDescriptorArray.length;
        int n4 = 0;
        while (n4 < n3) {
            iPreferenceNode2 = iViewDescriptorArray[n4];
            stringBuilder.append(String.valueOf(iPreferenceNode2.getId()) + " (" + iPreferenceNode2.getLabel() + ")");
            stringBuilder.append("\n");
            ++n4;
        }
        logger.debug(stringBuilder.toString());
        stringBuilder.setLength(0);
    }

    public void postWindowOpen() {
        WorkbenchCorePlugin workbenchCorePlugin;
        super.postWindowOpen();
        ProcessingComponentDescriptor processingComponentDescriptor2 = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = ((IWorkbenchWindow[])processingComponentDescriptor2).length;
        int n2 = 0;
        while (n2 < n) {
            workbenchCorePlugin = processingComponentDescriptor2[n2];
            IEditorReference[] iEditorReferenceArray = workbenchCorePlugin.getActivePage().getEditorReferences();
            int n3 = iEditorReferenceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference iEditorReference = iEditorReferenceArray[n4];
                iEditorReference.getEditor(true);
                ++n4;
            }
            ++n2;
        }
        workbenchCorePlugin = WorkbenchCorePlugin.getDefault();
        List<ProcessingComponentDescriptor> list = workbenchCorePlugin.getFailed();
        if (!list.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (ProcessingComponentDescriptor processingComponentDescriptor2 : list) {
                Throwable throwable = processingComponentDescriptor2.getInitializationFailure();
                stringBuilder.append(String.valueOf(processingComponentDescriptor2.getTitle()) + ": " + throwable.getClass().getName());
                if (throwable.getMessage() != null && throwable.getMessage().length() > 0) {
                    stringBuilder.append("\n   " + throwable.getMessage());
                }
                stringBuilder.append("\n\n");
            }
            Utils.showView("org.eclipse.pde.runtime.LogView");
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Fatal errors", (String)"Plugin loading errors. See the error log for details.", (IStatus)new Status(4, "org.carrot2.workbench.core", stringBuilder.toString()));
        }
        if (!WorkbenchCorePlugin.getPreferences().getBoolean(DisplayWelcomeView.ALREADY_DISPLAYED, false)) {
            new DisplayWelcomeView().execute();
        }
    }

    private int calculateInitialSize(int n, int n2) {
        int n3 = (int)((double)n * 0.9) >= n2 ? (int)((double)n * 0.9) : (n >= n2 ? n2 : n);
        return n3;
    }
}

