/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.workbench.core;

import java.net.URL;
import org.carrot2.util.resource.IResource;
import org.carrot2.util.resource.IResourceLocator;
import org.carrot2.util.resource.URLResource;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

final class BundleResourceLocator
implements IResourceLocator {
    private final Bundle bundle;

    public BundleResourceLocator(Bundle bundle) {
        this.bundle = bundle;
    }

    public IResource[] getAll(String string) {
        URL uRL;
        if (this.bundle.getState() != 32) {
            try {
                this.bundle.start();
            }
            catch (BundleException bundleException) {
                return new IResource[0];
            }
        }
        if ((uRL = this.bundle.getEntry(string)) != null) {
            return new IResource[]{new URLResource(uRL)};
        }
        return new IResource[0];
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object instanceof BundleResourceLocator) {
            BundleResourceLocator bundleResourceLocator = (BundleResourceLocator)object;
            return this.bundle.equals(bundleResourceLocator.bundle);
        }
        return false;
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " [bundle: " + this.bundle + "]";
    }
}

